/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.hdfs;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.hdfs.bo.UploadHdfsFileInfoBO;
import com.yqsmartcity.data.swap.api.hdfs.service.UploadFile2HdfsService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UploadFile2HdfsServiceImpl
implements UploadFile2HdfsService {
    private static final Logger log = LoggerFactory.getLogger(UploadFile2HdfsServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(UploadFile2HdfsServiceImpl.class);
    @Value(value="${hdfs.defalutFS}")
    private String hdfsDefalutFS;

    public void uploadFile2Hdfs(List<UploadHdfsFileInfoBO> updateFile) throws ZTBusinessException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", this.hdfsDefalutFS);
        conf.set("user.name", "oozie");
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            for (UploadHdfsFileInfoBO ploadHdfsFileInfoBO : updateFile) {
                fs.copyFromLocalFile(new Path(ploadHdfsFileInfoBO.getLocalFile()), new Path(ploadHdfsFileInfoBO.getTargetFilePath()));
            }
            fs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230HDFS\u5931\u8d25\uff01");
        }
    }

    public void writeFile2Hdfs(List<UploadHdfsFileInfoBO> updateFile) throws ZTBusinessException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", this.hdfsDefalutFS);
        conf.set("user", "oozie");
        try {
            FileSystem fs = FileSystem.get((URI)new URI(this.hdfsDefalutFS), (Configuration)conf, (String)"hdfs");
            for (UploadHdfsFileInfoBO ploadHdfsFileInfoBO : updateFile) {
                logger.info("------\u51991\uff1a" + ploadHdfsFileInfoBO.getTargetFilePath());
                FSDataOutputStream out = fs.create(new Path("/" + ploadHdfsFileInfoBO.getTargetFilePath()));
                logger.info("------\u51992\uff1a");
                String fileContent = ploadHdfsFileInfoBO.getFileContent();
                out.write(fileContent.getBytes("UTF-8"));
                logger.info("------\u51993\uff1a");
                out.close();
            }
            fs.close();
            logger.info("------close1\uff1a");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230HDFS\u5931\u8d25\uff01");
        }
        catch (URISyntaxException ee2) {
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230HDFS\u5931\u8d25\uff01");
        }
        catch (InterruptedException ee2) {
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230HDFS\u5931\u8d25\uff01");
        }
    }
}

