/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.hdfs.util;

import com.yqsmartcity.data.swap.api.hdfs.bo.HdfsConfigurationBO;
import java.io.IOException;
import java.util.ResourceBundle;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUtil {
    private static final Logger log = LoggerFactory.getLogger(HdfsUtil.class);

    public static FileSystem getFileSystem() {
        FileSystem fileSystem = null;
        Configuration conf = HdfsUtil.getConf();
        try {
            fileSystem = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6hdfsFileSystem\u5bf9\u8c61\u5931\u8d25");
            e.printStackTrace();
        }
        log.info("\u6210\u529f\u83b7\u53d6hdfs\u6587\u4ef6\u94fe\u63a5\u5bf9\u8c61");
        return fileSystem;
    }

    public static Configuration getConf() {
        HdfsConfigurationBO hadoopConfBO = HdfsUtil.getHadoopConfBO();
        System.setProperty("HADOOP_USER_NAME", hadoopConfBO.getUserName());
        Configuration conf = new Configuration();
        log.info("\u5f53\u524d\u94fe\u63a5\uff1a{}", (Object)hadoopConfBO.getUrl());
        conf.set("fs.defaultFS", hadoopConfBO.getUrl());
        return conf;
    }

    public static HdfsConfigurationBO getHadoopConfBO() {
        HdfsConfigurationBO hdfs = new HdfsConfigurationBO();
        ResourceBundle bundle = ResourceBundle.getBundle("application");
        hdfs.setUrl(bundle.getString("hdfs.defalutFS"));
        hdfs.setFilePath(bundle.getString("hdfs.file.path"));
        hdfs.setStreamPath(bundle.getString("hdfs.stream.path"));
        hdfs.setHivePath(bundle.getString("hdfs.hive.path"));
        hdfs.setUserName(bundle.getString("hdfs.user.name"));
        return hdfs;
    }
}

