/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.hivedb;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.service.SwapQrySysParaListBusiService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.hivedb.SwapGetHiveDDlStringService;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.constant.DataUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SwapGetHiveDDlStringServiceImpl
implements SwapGetHiveDDlStringService {
    private static final Logger log = LoggerFactory.getLogger(SwapGetHiveDDlStringServiceImpl.class);
    @Value(value="${swap.partition.col}")
    private String swapPartitionCol;
    @Autowired
    private SwapQrySysParaListBusiService swapQrySysParaListBusiService;

    public StringBuffer getHiveDDlString(CreateImportFileReqBO reqBO) throws ZTBusinessException {
        StringBuffer hiveDdlSql = new StringBuffer();
        hiveDdlSql.append("--hive sql \n");
        hiveDdlSql.append("--********************************************************************--\n");
        hiveDdlSql.append("--author:" + reqBO.getUsername() + "\n");
        hiveDdlSql.append("--create time:" + DataUtil.getDate("yyyy-MM-dd HH:mm:ss") + "\n");
        hiveDdlSql.append("--\u521b\u5efa\u8868\uff1a" + reqBO.getTableNameContent() + "\n");
        hiveDdlSql.append("--********************************************************************--)\n");
        hiveDdlSql.append("use ods;\n");
        hiveDdlSql.append("--\u4ea4\u6362\u8868\n");
        this.createSql(hiveDdlSql, reqBO, "", "", 90);
        hiveDdlSql.append("--\u540c\u6b65\u5e93\u589e\u91cf\u8868\n");
        this.createSql(hiveDdlSql, reqBO, "", "_ad", 7);
        hiveDdlSql.append("--\u540c\u6b65\u5e93\u5dee\u91cf\u8868\n");
        this.createSql(hiveDdlSql, reqBO, "", "_dl", 7);
        return hiveDdlSql;
    }

    public void createSql(StringBuffer hiveDdlSql, CreateImportFileReqBO reqBO, String prefix, String suffix, int lifecycle) {
        hiveDdlSql.append("CREATE TABLE  if not exists " + prefix + reqBO.getTableName() + suffix + "(\n");
        int sortId = 0;
        for (ColumnBO colList : reqBO.getColumnBo()) {
            if (!StringUtils.isNotBlank((CharSequence)colList.getColumnName())) continue;
            if (0 < sortId++) {
                hiveDdlSql.append(",");
            }
            hiveDdlSql.append("`" + colList.getColumnName().trim() + "`");
            hiveDdlSql.append("  " + colList.getColumnType() + " ");
            hiveDdlSql.append(" comment \"" + colList.getColumnComment().replace("\r", " ").replace(";", " ") + " \" \n");
        }
        hiveDdlSql.append(")\n");
        hiveDdlSql.append(" comment \"" + reqBO.getTableNameContent() + "\"\n");
        hiveDdlSql.append(" PARTITIONED BY (" + this.swapPartitionCol + " string COMMENT \"\u5206\u533a\u5b57\u6bb5\uff0c\u65e5\u671f\") \n");
        hiveDdlSql.append(" row format delimited fields terminated by \"\u0001\"; \n");
        if (StringUtils.isEmpty((CharSequence)suffix)) {
            hiveDdlSql.append(" alter table ");
            hiveDdlSql.append(reqBO.getTableName());
            hiveDdlSql.append(" drop IF EXISTS PARTITION (" + this.swapPartitionCol + "=${bizdate});\n");
            hiveDdlSql.append(" alter table ");
            hiveDdlSql.append(reqBO.getTableName());
            hiveDdlSql.append(" add if not exists PARTITION (" + this.swapPartitionCol + "=${bizdate});\n\n");
        }
    }
}

