/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.hivedb;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.hivedb.SwapHiveIncrementTranService;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.constant.DataUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SwapHiveIncrementTranServiceImpl
implements SwapHiveIncrementTranService {
    private static final Logger log = LoggerFactory.getLogger(SwapHiveIncrementTranServiceImpl.class);
    @Value(value="${swap.partition.col}")
    private String swapPartitionCol;

    public StringBuffer hiveIncrementTran(CreateImportFileReqBO reqBO) throws ZTBusinessException {
        StringBuffer sql = new StringBuffer();
        this.getSql(sql, reqBO);
        return sql;
    }

    public void getSql(StringBuffer sql, CreateImportFileReqBO reqBO) {
        sql.append("--hive sql \n");
        sql.append("--********************************************************************--\n");
        sql.append("--author:" + reqBO.getUsername() + "\n");
        sql.append("--create time:" + DataUtil.getDate("yyyy-MM-dd HH:mm:ss") + "\n");
        sql.append("--hive\u7684\u589e\u91cf\u8f6c\u6362\u811a\u672c\uff08" + reqBO.getTableNameContent() + "\uff09\n");
        sql.append("--********************************************************************--)\n");
        sql.append("use ods;\n");
        sql.append("insert overwrite table " + reqBO.getTableName() + "_ad" + " PARTITION(" + this.swapPartitionCol + "=${bizdate})\n");
        sql.append("select \n");
        sql.append(this.getColumn(reqBO.getColumnBo(), "a", ""));
        sql.append("from \n");
        sql.append(reqBO.getTableName() + " AS a\n");
        sql.append("where a." + this.swapPartitionCol + "=${bizdate}\n");
        sql.append("and  not exists \n");
        sql.append("(select\n");
        sql.append("1\n");
        sql.append("FROM\n");
        sql.append(reqBO.getTableName() + " AS b\n");
        sql.append("where b." + this.swapPartitionCol + "=${beforebizdate} and concat_ws('~_~'," + this.getColumn(reqBO.getColumnBo(), "b", "cast"));
        sql.append(") = concat_ws('~_~'," + this.getColumn(reqBO.getColumnBo(), "a", "cast"));
        sql.append("))\n");
        sql.append(";\n");
    }

    public StringBuffer getColumn(List<ColumnBO> columnBo, String tableNameAbbr, String colType) {
        StringBuffer col = new StringBuffer();
        int sortId = 0;
        for (ColumnBO columnName : columnBo) {
            if (0 < sortId++) {
                col.append(",");
            }
            if ("string".equalsIgnoreCase(columnName.getColumnType().toLowerCase()) || !"cast".equalsIgnoreCase(colType)) {
                col.append(tableNameAbbr + "." + columnName.getColumnName() + "\n");
                continue;
            }
            col.append("cast(" + tableNameAbbr + "." + columnName.getColumnName() + " as string )\n");
        }
        return col;
    }
}

