/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.linkdb.bo.GetOdpsSqlListBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.OdpsSqlBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.SwapLinkdbReqBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapGetOdpsStringService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOracleService;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.po.TableColInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwapGetOdpsStringServiceImpl
implements SwapGetOdpsStringService {
    private static final Logger log = LoggerFactory.getLogger(SwapGetOdpsStringServiceImpl.class);
    @Autowired
    private SwapLinkOracleService swapLinkOracleService;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TableColInfoDao tableColInfoDao;

    public GetOdpsSqlListBO createOdpsTable(SwapLinkdbReqBO reqBO) throws ZTBusinessException {
        GetOdpsSqlListBO linkdbRspBo = new GetOdpsSqlListBO();
        ArrayList<OdpsSqlBO> odpsSqlList = new ArrayList<OdpsSqlBO>();
        for (String odpsTable : reqBO.getDatabaseTable()) {
            StringBuffer createTableSql = new StringBuffer();
            TableColInfoPO tableColInfoPO = new TableColInfoPO();
            tableColInfoPO.setTableName(odpsTable);
            List<TableColInfoPO> getTableColInfoPOList = this.tableColInfoDao.getList(tableColInfoPO);
            TableInfoPO tableInfoPO = new TableInfoPO();
            tableInfoPO.setDatabaseTable(odpsTable);
            tableInfoPO.setStatus("1");
            TableInfoPO queryTableInfoPO = this.tableInfoDao.getModelBy(tableInfoPO);
            for (TableColInfoPO colList : getTableColInfoPOList) {
                if (1 == colList.getSortId()) {
                    createTableSql.append("CREATE TABLE " + colList.getTableName() + "(" + colList.getColumnName());
                } else {
                    createTableSql.append("," + colList.getColumnName());
                }
                createTableSql.append("  " + colList.getDataType() + " ");
                createTableSql.append(" comment '" + colList.getColumnComment() + "' ");
            }
            createTableSql.append(")");
            createTableSql.append(" comment '" + queryTableInfoPO.getDatabaseTableName() + "'");
            if (null == queryTableInfoPO.getLifeCycle()) {
                createTableSql.append(" PARTITIONED BY (ds string COMMENT '\u5206\u533a') LIFECYCLE 90;");
            } else {
                createTableSql.append(" PARTITIONED BY (ds string COMMENT '\u5206\u533a') LIFECYCLE " + queryTableInfoPO.getLifeCycle() + ";");
            }
            createTableSql.append("\r\n");
            OdpsSqlBO odpsSqlBO = new OdpsSqlBO();
            odpsSqlBO.setOdpsCreateTableSql(createTableSql);
            odpsSqlList.add(odpsSqlBO);
        }
        linkdbRspBo.setOdpsSqlList(odpsSqlList);
        return linkdbRspBo;
    }
}

