/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.linkdb.bo.JdbcQueryBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.LinkOdpsBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOdpsService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SwapLinkOdpsServiceImpl
implements SwapLinkOdpsService {
    private static final Logger log = LoggerFactory.getLogger(SwapLinkOdpsServiceImpl.class);
    private static String driverName = "com.aliyun.odps.jdbc.OdpsDriver";
    @Value(value="${accessID}")
    private String accessID;
    @Value(value="${accessKey}")
    private String accessKey;
    @Value(value="${odpsUrl}")
    private String odpsUrl;
    @Value(value="${odps.project.name}")
    private String odpsProjectName;

    public JdbcQueryBO execSql(LinkOdpsBO linkOdpsBO) throws ZTBusinessException {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Properties config = new Properties();
        config.put("access_id", this.accessID);
        config.put("access_key", this.accessKey);
        config.put("project_name", this.odpsProjectName);
        ResultSet rs = null;
        JdbcQueryBO jdbcQueryBO = new JdbcQueryBO();
        try (Connection conn = DriverManager.getConnection(this.odpsUrl, config);
             Statement stmt = conn.createStatement();){
            try {
                if ("ddl".equalsIgnoreCase(linkOdpsBO.getExecType())) {
                    stmt.execute(linkOdpsBO.getExecSql().toString());
                } else if ("query".equalsIgnoreCase(linkOdpsBO.getExecType())) {
                    rs = stmt.executeQuery(linkOdpsBO.getExecSql().toString());
                    jdbcQueryBO.setRs(rs);
                } else if ("update".equalsIgnoreCase(linkOdpsBO.getExecType())) {
                    stmt.executeUpdate(linkOdpsBO.getExecSql().toString());
                } else if ("insert".equalsIgnoreCase(linkOdpsBO.getExecType())) {
                    stmt.execute(linkOdpsBO.getExecSql().toString());
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u5931\u8d25\uff01");
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException e) {
            throw new ZTBusinessException("\u8fde\u63a5ODPS\u5931\u8d25\uff01");
        }
        log.info("-------------" + linkOdpsBO.getExecSql().toString());
        return jdbcQueryBO;
    }
}

