/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkSqlServerService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SwapLinkSqlServerServiceImpl
implements SwapLinkSqlServerService {
    private static final Logger log = LoggerFactory.getLogger(SwapLinkSqlServerServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapLinkSqlServerServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableBO> linkSqlServer(DatabaseInfoBO queryDatabaseInfoBO) throws ZTBusinessException {
        ArrayList<TableBO> tableBOList = new ArrayList<TableBO>();
        ResultSet resultSet = null;
        String ip = queryDatabaseInfoBO.getIpAddr();
        String port = queryDatabaseInfoBO.getPortNum();
        String serverName = queryDatabaseInfoBO.getServerName();
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException e) {
            logger.error("\u672a\u627e\u5230SQLServer\u9a71\u52a8");
        }
        try {
            String connectDB = "jdbc:sqlserver://" + ip + "\\SQLEXPRESS:" + port + ";DatabaseName=" + serverName;
            String user = queryDatabaseInfoBO.getUserName();
            String password = queryDatabaseInfoBO.getUserPass();
            try (Connection connect = DriverManager.getConnection(connectDB, user, password);){
                logger.debug("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f");
                try (Statement stmt = connect.createStatement();){
                    String query;
                    logger.debug("\u5f00\u59cb\u67e5\u8be2\u8868\u7684\u5217");
                    if ("table".equalsIgnoreCase(queryDatabaseInfoBO.getQryTableFlag())) {
                        query = "select    c.name as table_name,'' as table_comment  from sysobjects c  where c.xtype='U' order by c.name";
                        logger.info("query=====" + query);
                        resultSet = stmt.executeQuery(query);
                        while (resultSet.next()) {
                            TableBO tableBO = new TableBO();
                            tableBO.setTableName(resultSet.getString("table_name"));
                            tableBO.setTableComment(resultSet.getString("table_comment"));
                            tableBOList.add(tableBO);
                        }
                    } else {
                        query = "select    c.name as table_name,'' as table_comment ,a.name as column_name,b.name as data_type,b.name as column_type,'' as column_comment,column_id as ordinal_position from sys.columns  a \njoin sys.types b on a.user_type_id=b.user_type_id\njoin sysobjects c on a.object_id=c.id\nwhere c.xtype='U'\n and c.name='" + queryDatabaseInfoBO.getSourceTable() + "'order by c.name,column_id";
                        logger.debug("\u67e5\u8be2query=====" + query);
                        resultSet = stmt.executeQuery(query);
                        String tableComment1 = null;
                        TableBO tableBO = new TableBO();
                        ArrayList<ColumnBO> columnBOList = new ArrayList<ColumnBO>();
                        while (resultSet.next()) {
                            ColumnBO columnBO = new ColumnBO();
                            columnBO.setColumnName(resultSet.getString("column_name"));
                            columnBO.setDataType(resultSet.getString("data_type"));
                            columnBO.setColumnType(resultSet.getString("column_type"));
                            columnBO.setOrdinalPosition(resultSet.getString("ordinal_position"));
                            columnBO.setColumnComment(resultSet.getString("column_comment"));
                            tableComment1 = resultSet.getString("table_comment");
                            columnBOList.add(columnBO);
                        }
                        tableBO.setTableName(queryDatabaseInfoBO.getDatabaseTable());
                        tableBO.setTableComment(tableComment1);
                        tableBO.setColumnBOList(columnBOList);
                        tableBOList.add(tableBO);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tableBOList;
    }
}

