/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.log;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.log.bo.OperLogBO;
import com.yqsmartcity.data.swap.api.log.bo.SwapQryLogsListReqBO;
import com.yqsmartcity.data.swap.api.log.bo.SwapQryLogsListRspBO;
import com.yqsmartcity.data.swap.api.log.service.SwapQryLogsListService;
import com.yqsmartcity.data.swap.dao.OperLogDao;
import com.yqsmartcity.data.swap.po.OperLogPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwapQryLogsListServiceImpl
implements SwapQryLogsListService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryLogsListServiceImpl.class);
    @Autowired
    private OperLogDao operLogDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    public SwapQryLogsListRspBO qryLogsList(SwapQryLogsListReqBO reqBO) throws ZTBusinessException {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SwapQryLogsListRspBO rspBO = new SwapQryLogsListRspBO();
        ArrayList<OperLogBO> operLogBOList = new ArrayList<OperLogBO>();
        OperLogPO operLogPO = new OperLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)operLogPO);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)reqBO.getRequestTime())) {
            String[] requestTimeList = reqBO.getRequestTime().split("~");
            String requestTimeStart = requestTimeList[0].trim() + " 00:00:00";
            String requestTimeEnd = requestTimeList[1].trim() + " 23:59:59";
            try {
                Date requestStart = sdf.parse(requestTimeStart);
                Date requestEnd = sdf.parse(requestTimeEnd);
                operLogPO.setRequestStart(requestStart);
                operLogPO.setRequestEnd(requestEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        List<OperLogPO> operLogPOList = this.operLogDao.getListPage((Page<OperLogPO>)page, operLogPO);
        for (OperLogPO operLogPO1 : operLogPOList) {
            OperLogBO operLogBO = new OperLogBO();
            BeanUtils.copyProperties((Object)operLogPO1, (Object)operLogBO);
            operLogBO.setOperModeName(this.getSysPara(operLogPO1.getOperMode(), "OPER_MODE_TYPE"));
            operLogBO.setOperTypeName(this.getSysPara(operLogPO1.getOperType(), "OPER_TYPE"));
            operLogBO.setRequestDate(operLogPO1.getResponseDate());
            operLogBOList.add(operLogBO);
        }
        rspBO.setRows(operLogBOList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

