/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.node;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.node.bo.NodeInfoBO;
import com.yqsmartcity.data.swap.api.node.bo.SwapQryNodeInfoReqBO;
import com.yqsmartcity.data.swap.api.node.bo.SwapQryNodeInfoRspBO;
import com.yqsmartcity.data.swap.api.node.service.SwapQryNodeInfoService;
import com.yqsmartcity.data.swap.dao.NodeInfoDao;
import com.yqsmartcity.data.swap.po.NodeInfoPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapQryNodeInfoServiceImpl
implements SwapQryNodeInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryNodeInfoServiceImpl.class);
    @Autowired
    private NodeInfoDao nodeInfoDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    @Transactional(rollbackFor={Exception.class})
    public SwapQryNodeInfoRspBO qryNodeInfo(SwapQryNodeInfoReqBO reqBO) throws ZTBusinessException {
        SwapQryNodeInfoRspBO rspBO = new SwapQryNodeInfoRspBO();
        this.validateParam(reqBO);
        NodeInfoPO nodeInfoPO = this.nodeInfoDao.getModelById(reqBO.getUnid());
        if (null == nodeInfoPO) {
            throw new ZTBusinessException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        NodeInfoBO nodeInfoBO = new NodeInfoBO();
        BeanUtils.copyProperties((Object)nodeInfoPO, (Object)nodeInfoBO);
        nodeInfoBO.setNodeTypeName(this.getSysPara(nodeInfoPO.getNodeType(), "NODE_TYPE"));
        nodeInfoBO.setNodeStatusName(this.getSysPara(nodeInfoPO.getNodeStatus(), "NODE_STATUS_TYPE"));
        nodeInfoBO.setNetworkLocationName(this.getSysPara(nodeInfoPO.getNetworkLocation(), "NETWORK_LOCATION_TYPE"));
        if (!StringUtils.isEmpty((String)nodeInfoPO.getAdminAgentPassword())) {
            nodeInfoBO.setAdminAgentPassword("******");
        }
        rspBO.setNodeInfoBO(nodeInfoBO);
        return rspBO;
    }

    private void validateParam(SwapQryNodeInfoReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010Unid\u3011\u4e3a\u7a7a");
        }
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

