/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.oozie;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieJobPropertiesBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateJobPropertiesService;
import com.yqsmartcity.data.swap.constant.LocalTimeToUTC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CreateJobPropertiesServiceImpl
implements CreateJobPropertiesService {
    private static final Logger log = LoggerFactory.getLogger(CreateJobPropertiesServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(CreateJobPropertiesServiceImpl.class);
    @Value(value="${oozie.url}")
    private String oozieUrl;
    @Value(value="${oozie.name.node}")
    private String oozieNameNode;
    @Value(value="${oozie.job.tracker}")
    private String oozieJobTracker;
    @Value(value="${oozie.hdfs.path}")
    private String oozieHdfsPath;

    public StringBuffer createJobPro(OozieJobPropertiesBO oozieJobPropertiesBO) throws ZTBusinessException {
        StringBuffer returnConf = new StringBuffer();
        JSONObject conf = new JSONObject();
        conf.put("oozieUrl", (Object)this.oozieUrl);
        conf.put("nameNode", (Object)this.oozieNameNode);
        conf.put("jobTracker", (Object)this.oozieJobTracker);
        conf.put("queueName", (Object)"default");
        conf.put("examplesRoot", (Object)this.oozieHdfsPath);
        conf.put("outputpath", (Object)"${nameNode}/${examplesRoot}/log/");
        conf.put("user.name", (Object)"oozie");
        conf.put("start", (Object)LocalTimeToUTC.getDate(oozieJobPropertiesBO.getWorkStartTime()));
        if (StringUtils.isEmpty((String)oozieJobPropertiesBO.getWorkEndTime())) {
            conf.put("end", (Object)"2999-12-31T23:59+0800");
        } else {
            conf.put("end", (Object)LocalTimeToUTC.getDate(oozieJobPropertiesBO.getWorkEndTime()));
        }
        if (oozieJobPropertiesBO.getRunCycle().split(" ").length == 7) {
            conf.put("runCycle", (Object)oozieJobPropertiesBO.getRunCycle().substring(oozieJobPropertiesBO.getRunCycle().indexOf(" ") + 1, oozieJobPropertiesBO.getRunCycle().lastIndexOf(" ")));
        } else if (oozieJobPropertiesBO.getRunCycle().split(" ").length == 6) {
            conf.put("runCycle", (Object)oozieJobPropertiesBO.getRunCycle().substring(oozieJobPropertiesBO.getRunCycle().indexOf(" ") + 1));
        } else {
            conf.put("runCycle", (Object)oozieJobPropertiesBO.getRunCycle());
        }
        conf.put("workflowAppUri", (Object)("${nameNode}/${examplesRoot}/" + oozieJobPropertiesBO.getSourcePorject() + "-workflow/" + oozieJobPropertiesBO.getWorkFlowName()));
        conf.put("oozie.coord.application.path", (Object)"${workflowAppUri}");
        conf.put("oozie.wf.application.path", (Object)"${workflowAppUri}");
        returnConf.append(conf);
        return returnConf;
    }
}

