/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.oozie;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.GetFileStringBufferBO;
import com.yqsmartcity.data.swap.api.azkaban.service.SwapGetAzkabanJobService;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SysParaBO;
import com.yqsmartcity.data.swap.api.base.service.SwapQrySysParaListBusiService;
import com.yqsmartcity.data.swap.api.dataX.service.SwapGetDataXJsonService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileListReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadReqBO;
import com.yqsmartcity.data.swap.api.hivedb.GoveGetHiveSumStringService;
import com.yqsmartcity.data.swap.api.hivedb.SwapGetHiveDDlStringService;
import com.yqsmartcity.data.swap.api.hivedb.SwapHiveIncrementTranService;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieJobPropertiesBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowNodeBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateCoordinatorXmlService;
import com.yqsmartcity.data.swap.api.oozie.service.CreateJobPropertiesService;
import com.yqsmartcity.data.swap.api.oozie.service.CreateOozieConfFileService;
import com.yqsmartcity.data.swap.api.oozie.service.CreateWorkFlowXmlService;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.service.busi.impl.azkaban.SwapGetAzkabanShellServiceimpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CreateOozieConfFileServiceImpl
implements CreateOozieConfFileService {
    private static final Logger log = LoggerFactory.getLogger(CreateOozieConfFileServiceImpl.class);
    @Value(value="${datax.bin.home}")
    private String dataxBinHome;
    @Value(value="${datax.json.home}")
    private String dataxJsonHome;
    @Value(value="${hive.sql.home}")
    private String hiveSqlHome;
    @Value(value="${oozie.hdfs.path}")
    private String oozieHdfsPath;
    @Autowired
    private SwapGetHiveDDlStringService swapGetHiveDDlStringService;
    @Autowired
    private SwapGetAzkabanJobService swapGetAzkabanJobService;
    @Autowired
    private SwapGetAzkabanShellServiceimpl swapGetAzkabanShellServiceimpl;
    @Autowired
    private GoveGetHiveSumStringService goveGetHiveSumStringService;
    @Autowired
    private SwapHiveIncrementTranService swapHiveIncrementTranService;
    @Autowired
    private SwapGetDataXJsonService swapGetDataXJsonService;
    @Autowired
    private CreateWorkFlowXmlService createWorkFlowXmlService;
    @Autowired
    private CreateCoordinatorXmlService createCoordinatorXmlService;
    @Autowired
    private SwapQrySysParaListBusiService swapQrySysParaListBusiService;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private DataWorksDao dataWorksDao;
    @Autowired
    private CreateJobPropertiesService createJobPropertiesService;

    @Transactional(rollbackFor={Exception.class})
    public List<CreateImportFileRspBO> createOozieConf(ScriptDownloadReqBO scriptDownloadReqBO) throws ZTBusinessException {
        ArrayList<CreateImportFileRspBO> createImportFileRspBOList = new ArrayList<CreateImportFileRspBO>();
        this.validateParam(scriptDownloadReqBO);
        scriptDownloadReqBO.setExpressionSuitDb("HIVE");
        List<CreateImportFileReqBO> listCreateImportFileReqBO = this.dataWorksDao.getListCreateImportFile(scriptDownloadReqBO.getTableNameList());
        if (CollectionUtils.isEmpty(listCreateImportFileReqBO)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8868\u548c\u5b57\u6bb5\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        CreateImportFileListReqBO createImportFileListReqBO = new CreateImportFileListReqBO();
        BeanUtils.copyProperties((Object)scriptDownloadReqBO, (Object)createImportFileListReqBO);
        createImportFileListReqBO.setListCreateImportFileReqBO(listCreateImportFileReqBO);
        SwapQrySysParaListReqBO reqBO = new SwapQrySysParaListReqBO();
        reqBO.setParaType("BIZ_TYPE");
        SwapQrySysParaListRspBO dictRspBO = this.swapQrySysParaListBusiService.qrySysParaList(reqBO);
        List sysparalist = dictRspBO.getSysParaBOList().stream().map(SysParaBO::getParaCode).collect(Collectors.toList());
        if (StringUtils.isEmpty((CharSequence)createImportFileListReqBO.getBizType())) {
            createImportFileListReqBO.setBizType(String.join((CharSequence)",", sysparalist));
        }
        CreateImportFileListReqBO createImportFileBO = new CreateImportFileListReqBO();
        for (CreateImportFileReqBO importFileBO : createImportFileListReqBO.getListCreateImportFileReqBO()) {
            CreateImportFileRspBO createImportFileRspBO = new CreateImportFileRspBO();
            ArrayList<CreateImportFileBO> reateImportFileBO = new ArrayList<CreateImportFileBO>();
            for (String bizType2 : createImportFileListReqBO.getBizType().split(",")) {
                CreateImportFileBO folderDiFileBO;
                if ("sync".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_sync.json");
                    folderDiFileBO.setFileType("json");
                    folderDiFileBO.setWorkFlowName(importFileBO.getTableName());
                    folderDiFileBO.setFileContent(this.swapGetDataXJsonService.getDataXJson(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                    CreateImportFileBO folderDiFileShellBO = new CreateImportFileBO();
                    folderDiFileShellBO.setFileName(importFileBO.getTableName() + "_sync.sh");
                    folderDiFileShellBO.setFileType("sh");
                    folderDiFileShellBO.setWorkFlowName(importFileBO.getTableName());
                    StringBuffer fileContent = new StringBuffer();
                    fileContent.append("#!/bin/sh\n#ecoding=utf-8\n\nbizdate=${1}\nbeforebizdate=${2}\n\n");
                    fileContent.append("#\u6267\u884cDataX\u811a\u672c\npython " + this.dataxBinHome + "/datax.py  -p\"-Dwhere='1=1' -Ddt=${bizdate}\" " + folderDiFileBO.getFileName());
                    folderDiFileShellBO.setFileContent(fileContent);
                    reateImportFileBO.add(folderDiFileShellBO);
                    continue;
                }
                if ("ddl".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_ddl.sql");
                    folderDiFileBO.setFileType("sql");
                    folderDiFileBO.setWorkFlowName(importFileBO.getTableName());
                    folderDiFileBO.setFileContent(this.swapGetHiveDDlStringService.getHiveDDlString(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                    continue;
                }
                if ("sum".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_sum.sql");
                    folderDiFileBO.setFileType("sql");
                    folderDiFileBO.setWorkFlowName(importFileBO.getTableName());
                    folderDiFileBO.setFileContent(this.goveGetHiveSumStringService.sumStr(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                    continue;
                }
                if (!"ad".equalsIgnoreCase(bizType2)) continue;
                folderDiFileBO = new CreateImportFileBO();
                folderDiFileBO.setFileName(importFileBO.getTableName() + "_ad.sql");
                folderDiFileBO.setFileType("sql");
                folderDiFileBO.setWorkFlowName(importFileBO.getTableName());
                folderDiFileBO.setFileContent(this.swapHiveIncrementTranService.hiveIncrementTran(importFileBO));
                reateImportFileBO.add(folderDiFileBO);
            }
            CreateImportFileBO folderDiFileBO = new CreateImportFileBO();
            folderDiFileBO.setFileName("coordinator.xml");
            folderDiFileBO.setFileType("xml");
            folderDiFileBO.setWorkFlowName(importFileBO.getTableName());
            folderDiFileBO.setFileContent(this.createCoordinatorXmlService.createCoordinatorXml(folderDiFileBO));
            reateImportFileBO.add(folderDiFileBO);
            CreateImportFileBO jobPropertiesFileBO = new CreateImportFileBO();
            jobPropertiesFileBO.setFileName("job.properties");
            jobPropertiesFileBO.setFileType("mappers/job");
            jobPropertiesFileBO.setWorkFlowName(importFileBO.getTableName());
            OozieJobPropertiesBO oozieJobPropertiesBO = new OozieJobPropertiesBO();
            oozieJobPropertiesBO.setRunCycle(importFileBO.getSwapFreq());
            oozieJobPropertiesBO.setWorkFlowName(importFileBO.getTableName());
            oozieJobPropertiesBO.setSourcePorject("TP001");
            jobPropertiesFileBO.setFileContent(this.createJobPropertiesService.createJobPro(oozieJobPropertiesBO));
            reateImportFileBO.add(jobPropertiesFileBO);
            OozieWorkFlowBO oozieWorkFlowBO = new OozieWorkFlowBO();
            ArrayList<OozieWorkFlowNodeBO> nodeList = new ArrayList<OozieWorkFlowNodeBO>();
            OozieWorkFlowNodeBO oozieWorkFlowNodeBO = new OozieWorkFlowNodeBO();
            oozieWorkFlowNodeBO.setNodeType("switch");
            oozieWorkFlowNodeBO.setNodeName(importFileBO.getTableName() + "_switch_check");
            oozieWorkFlowNodeBO.setScriptFileName(importFileBO.getTableName() + "_ddl");
            oozieWorkFlowNodeBO.setNextNodeName(importFileBO.getTableName() + "_sync");
            nodeList.add(oozieWorkFlowNodeBO);
            oozieWorkFlowNodeBO = new OozieWorkFlowNodeBO();
            oozieWorkFlowNodeBO.setNodeType("hive");
            oozieWorkFlowNodeBO.setNodeName(importFileBO.getTableName() + "_ddl");
            oozieWorkFlowNodeBO.setScriptFileName(importFileBO.getTableName() + "_ddl.sql");
            oozieWorkFlowNodeBO.setNextNodeName(importFileBO.getTableName() + "_sync");
            nodeList.add(oozieWorkFlowNodeBO);
            oozieWorkFlowNodeBO = new OozieWorkFlowNodeBO();
            oozieWorkFlowNodeBO.setNodeType("datax_shell");
            oozieWorkFlowNodeBO.setNodeName(importFileBO.getTableName() + "_sync");
            oozieWorkFlowNodeBO.setScriptFileName(importFileBO.getTableName() + "_sync.sh");
            oozieWorkFlowNodeBO.setNextNodeName(importFileBO.getTableName() + "_ad");
            nodeList.add(oozieWorkFlowNodeBO);
            oozieWorkFlowNodeBO = new OozieWorkFlowNodeBO();
            oozieWorkFlowNodeBO.setNodeType("hive");
            oozieWorkFlowNodeBO.setNodeName(importFileBO.getTableName() + "_ad");
            oozieWorkFlowNodeBO.setScriptFileName(importFileBO.getTableName() + "_ad.sql");
            oozieWorkFlowNodeBO.setNextNodeName(importFileBO.getTableName() + "_sum");
            nodeList.add(oozieWorkFlowNodeBO);
            oozieWorkFlowNodeBO = new OozieWorkFlowNodeBO();
            oozieWorkFlowNodeBO.setNodeType("hive");
            oozieWorkFlowNodeBO.setNodeName(importFileBO.getTableName() + "_sum");
            oozieWorkFlowNodeBO.setScriptFileName(importFileBO.getTableName() + "_sum.sql");
            oozieWorkFlowNodeBO.setNextNodeName("end");
            nodeList.add(oozieWorkFlowNodeBO);
            oozieWorkFlowBO.setWorkFlowName(importFileBO.getTableName());
            oozieWorkFlowBO.setNodeList(nodeList);
            CreateImportFileBO workflowBO = new CreateImportFileBO();
            workflowBO.setFileName("workflow.xml");
            workflowBO.setFileType("xml");
            workflowBO.setWorkFlowName(importFileBO.getTableName());
            workflowBO.setFileContent(this.createWorkFlowXmlService.createWorkFlow(oozieWorkFlowBO));
            reateImportFileBO.add(workflowBO);
            createImportFileRspBO.setReateImportFileBO(reateImportFileBO);
            createImportFileRspBO.setTableName(importFileBO.getTableName());
            createImportFileRspBO.setTaskId(importFileBO.getTaskId());
            createImportFileRspBOList.add(createImportFileRspBO);
        }
        return createImportFileRspBOList;
    }

    private void getJobFile(List<GetFileStringBufferBO> jobList, String bizType2, CreateImportFileBO folderDiFileBO) {
        StringBuffer fileContent = new StringBuffer();
        for (GetFileStringBufferBO jobBO : jobList) {
            if (!bizType2.equalsIgnoreCase(jobBO.getBizType())) continue;
            folderDiFileBO.setFileName(jobBO.getFileName());
            folderDiFileBO.setFileContent(jobBO.getFileContent());
        }
    }

    private void validateParam(ScriptDownloadReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTableNameList())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u540d\u5217\u8868\u3010TableNameList\u3011\u4e3a\u7a7a");
        }
    }
}

