/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.oozie;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareCancelReqBO;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareCancelRspBO;
import com.yqsmartcity.data.swap.interfaces.service.task.DataShareCancelService;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import com.yqsmartcity.data.swap.po.TaskPublishPO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DataShareCancelServiceImpl
implements DataShareCancelService {
    private static final Logger log = LoggerFactory.getLogger(DataShareCancelServiceImpl.class);
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Value(value="${oozie.url}")
    private String oozieUrl;

    @Transactional(rollbackFor={Exception.class})
    public DataShareCancelRspBO stopJob(DataShareCancelReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TaskPublishPO taskPublishPO = new TaskPublishPO();
        taskPublishPO.setUnid(reqBO.getUnid());
        taskPublishPO.setPublishName(reqBO.getTaskId());
        taskPublishPO.setStatusList("2,3".split(","));
        List<TaskPublishPO> taskPublishPOList = this.taskPublishMapper.getListByPublishName(taskPublishPO);
        if (CollectionUtils.isEmpty(taskPublishPOList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5f85\u4e0b\u7ebf\u4efb\u52a1\uff01");
        }
        for (TaskPublishPO TaskPO : taskPublishPOList) {
            OozieClient wc = new OozieClient(this.oozieUrl);
            try {
                wc.kill(TaskPO.getJobId());
            }
            catch (OozieClientException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u4efb\u52a1\u4e0b\u7ebf\u5931\u8d25\uff01\u3010" + e.getLocalizedMessage() + "\u3011");
            }
            TaskPublishPO updateTaskPublishPO = new TaskPublishPO();
            BeanUtils.copyProperties((Object)TaskPO, (Object)updateTaskPublishPO);
            updateTaskPublishPO.setUnid(TaskPO.getUnid());
            updateTaskPublishPO.setStatus("0");
            this.taskPublishMapper.updateByPrimaryKey(updateTaskPublishPO);
        }
        TaskInfoPO taskInfoPO = new TaskInfoPO();
        taskInfoPO.setTaskId(reqBO.getTaskId());
        taskInfoPO.setRelationDesc(reqBO.getOperSource());
        taskInfoPO.setStatus("1");
        taskInfoPO.setOperId(reqBO.getOperId());
        taskInfoPO.setOperName(reqBO.getOperName());
        this.taskInfoDao.updateStatusByTaskId(taskInfoPO);
        return new DataShareCancelRspBO();
    }

    private void validateParam(DataShareCancelReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1ID\u3010taskId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperSource())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u6765\u6e90\u3010operSource\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperId())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u4eba\u5458ID\u3010operId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u5458\u59d3\u540d\u3010operName\u3011\u4e3a\u7a7a");
        }
    }
}

