/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.oozie;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareStatusQryReqBO;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareStatusQryRspBO;
import com.yqsmartcity.data.swap.interfaces.bo.WorkFlowInfoBO;
import com.yqsmartcity.data.swap.interfaces.service.task.DataShareStatusQryService;
import com.yqsmartcity.data.swap.po.TaskPublishPO;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataShareStatusQryServiceImpl
implements DataShareStatusQryService {
    private static final Logger log = LoggerFactory.getLogger(DataShareStatusQryServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(DataShareStatusQryServiceImpl.class);
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Value(value="${oozie.url}")
    private String oozieUrl;

    public DataShareStatusQryRspBO queryJob(DataShareStatusQryReqBO reqBO) throws ZTBusinessException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        if (StringUtils.isEmpty((String)reqBO.getEndTime())) {
            reqBO.setEndTime(sdf.format(c.getTime()));
        }
        c.add(5, -7);
        if (StringUtils.isEmpty((String)reqBO.getStartTime())) {
            reqBO.setStartTime(sdf.format(c.getTime()));
        }
        this.validateParam(reqBO);
        DataShareStatusQryRspBO dataShareStatusQryRspBO = new DataShareStatusQryRspBO();
        ArrayList<WorkFlowInfoBO> workFlowInfoList = new ArrayList<WorkFlowInfoBO>();
        TaskPublishPO taskPublishPO = new TaskPublishPO();
        taskPublishPO.setPublishNameList(reqBO.getTaskIdList());
        List<TaskPublishPO> taskPublishPOList = this.taskPublishMapper.getListByPublishNameList(taskPublishPO);
        if (CollectionUtils.isEmpty(taskPublishPOList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4fe1\u606f\uff01");
        }
        logger.info("--------OozieClient------");
        OozieClient wc = new OozieClient(this.oozieUrl);
        logger.info("---------OozieClient end-----");
        for (TaskPublishPO TaskPO : taskPublishPOList) {
            try {
                CoordinatorJob cooJob = wc.getCoordJobInfo(TaskPO.getJobId());
                logger.info("-------wc.getCoordJobInfo-------jobid=" + TaskPO.getJobId());
                for (CoordinatorAction act : cooJob.getActions()) {
                    String starttime;
                    if (!StringUtils.isEmpty((String)reqBO.getJobStatus()) && !reqBO.getJobStatus().equalsIgnoreCase(act.getStatus().toString()) || null == act.getNominalTime() || DataShareStatusQryServiceImpl.strToDate(starttime = sdf.format(act.getNominalTime()), "yyyy-MM-dd HH:mm:ss").getTime() < DataShareStatusQryServiceImpl.strToDate(reqBO.getStartTime(), "yyyy-MM-dd HH:mm:ss").getTime() || DataShareStatusQryServiceImpl.strToDate(starttime, "yyyy-MM-dd HH:mm:ss").getTime() > DataShareStatusQryServiceImpl.strToDate(reqBO.getEndTime(), "yyyy-MM-dd HH:mm:ss").getTime()) continue;
                    Date endTime = null;
                    if (!StringUtils.isEmpty((String)act.getExternalId())) {
                        WorkflowJob ww = wc.getJobInfo(act.getExternalId());
                        endTime = ww.getEndTime();
                    } else {
                        endTime = act.getNominalTime();
                    }
                    WorkFlowInfoBO workFlowInfo = new WorkFlowInfoBO();
                    workFlowInfo.setTaskId(TaskPO.getPublishName());
                    workFlowInfo.setJobId(act.getId());
                    workFlowInfo.setJobStatus(act.getStatus().name());
                    workFlowInfo.setStartTime(DataShareStatusQryServiceImpl.dateToStr(act.getNominalTime(), "yyyy-MM-dd HH:mm:ss"));
                    workFlowInfo.setEndTime(DataShareStatusQryServiceImpl.dateToStr(endTime, "yyyy-MM-dd HH:mm:ss"));
                    workFlowInfoList.add(workFlowInfo);
                }
            }
            catch (OozieClientException e) {
                e.printStackTrace();
            }
        }
        dataShareStatusQryRspBO.setWorkFlowInfo(workFlowInfoList);
        return dataShareStatusQryRspBO;
    }

    private void validateParam(DataShareStatusQryReqBO reqBO) {
        if (reqBO.getTaskIdList() == null || reqBO.getTaskIdList().size() <= 0) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4efb\u52a1ID\u3010taskIdList\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperSource())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u6765\u6e90\u3010operSource\u3011\u4e3a\u7a7a");
        }
        if (DataShareStatusQryServiceImpl.strToDate(reqBO.getEndTime(), "yyyy-MM-dd HH:mm:ss").getTime() - DataShareStatusQryServiceImpl.strToDate(reqBO.getStartTime(), "yyyy-MM-dd HH:mm:ss").getTime() < 0L) {
            throw new ZTBusinessException("\u7ed3\u675f\u65f6\u95f4\u3010endTime\u3011\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if (DataShareStatusQryServiceImpl.strToDate(reqBO.getEndTime(), "yyyy-MM-dd HH:mm:ss").getTime() - DataShareStatusQryServiceImpl.strToDate(reqBO.getStartTime(), "yyyy-MM-dd HH:mm:ss").getTime() > 604800000L) {
            throw new ZTBusinessException("\u53ea\u80fd\u67e57\u5929\u5185\u7684\u72b6\u6001");
        }
    }

    public static Date strToDate(String strDate, String pattern) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static String dateToStr(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }
}

