/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.oozie;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieJobPropertiesBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowNodeBO;
import com.yqsmartcity.data.swap.api.oozie.service.GetOozieWorkFlowFileService;
import com.yqsmartcity.data.swap.constant.LocalTimeToUTC;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GetOozieWorkFlowFileServiceImpl
implements GetOozieWorkFlowFileService {
    private static final Logger log = LoggerFactory.getLogger(GetOozieWorkFlowFileServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(GetOozieWorkFlowFileServiceImpl.class);
    @Value(value="${oozie.url}")
    private String oozieUrl;
    @Value(value="${oozie.name.node}")
    private String oozieNameNode;
    @Value(value="${oozie.job.tracker}")
    private String oozieJobTracker;
    @Value(value="${oozie.hdfs.path}")
    private String oozieHdfsPath;
    @Value(value="${hdfs.hive.path}")
    private String hdfsHivePath;
    @Value(value="${swap.table.prefix}")
    private String swapTablePrefix;

    public List<CreateImportFileBO> getOozieFile(OozieWorkFlowBO oozieWorkFlowBO) throws ZTBusinessException {
        ArrayList<CreateImportFileBO> reateImportFileBO = new ArrayList<CreateImportFileBO>();
        reateImportFileBO.add(this.getCoordinatorXml(oozieWorkFlowBO));
        OozieJobPropertiesBO oozieJobPropertiesBO = new OozieJobPropertiesBO();
        BeanUtils.copyProperties((Object)oozieWorkFlowBO, (Object)oozieJobPropertiesBO);
        oozieJobPropertiesBO.setOozieUrl(this.oozieUrl);
        oozieJobPropertiesBO.setOozieNameNode(this.oozieNameNode);
        oozieJobPropertiesBO.setOozieJobTracker(this.oozieJobTracker);
        oozieJobPropertiesBO.setOozieHdfsPath(this.oozieHdfsPath + "/" + oozieWorkFlowBO.getWorkFlowType() + "-workflow");
        reateImportFileBO.add(this.getJobPro(oozieJobPropertiesBO));
        reateImportFileBO.add(this.getWorkFlowFile(oozieWorkFlowBO));
        return reateImportFileBO;
    }

    private CreateImportFileBO getWorkFlowFile(OozieWorkFlowBO oozieWorkFlowBO) throws ZTBusinessException {
        StringBuffer returnString = new StringBuffer();
        returnString.append("<workflow-app xmlns=\"uri:oozie:workflow:0.5\" name=\"" + oozieWorkFlowBO.getWorkFlowName() + "\">\n    <start to=\"" + ((OozieWorkFlowNodeBO)oozieWorkFlowBO.getNodeList().get(0)).getNodeName() + "\"/>\n    \n    \n");
        for (OozieWorkFlowNodeBO oozieWorkFlowNodeBO : oozieWorkFlowBO.getNodeList()) {
            if ("hive".equalsIgnoreCase(oozieWorkFlowNodeBO.getNodeType())) {
                returnString.append(this.hiveNode(oozieWorkFlowNodeBO, oozieWorkFlowBO.getWorkFlowName()));
                continue;
            }
            if ("datax_shell".equalsIgnoreCase(oozieWorkFlowNodeBO.getNodeType())) {
                returnString.append(this.dataxShellNode(oozieWorkFlowNodeBO, oozieWorkFlowBO.getWorkFlowName(), oozieWorkFlowBO.getWorkFlowType()));
                continue;
            }
            if (!"switch".equalsIgnoreCase(oozieWorkFlowNodeBO.getNodeType())) continue;
            returnString.append(this.switchNode(oozieWorkFlowNodeBO, this.swapTablePrefix + oozieWorkFlowBO.getWorkFlowName()));
        }
        returnString.append("\n    <kill name=\"fail\">\n        <message>Hive failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message>\n    </kill>\n    <end name=\"end\"/>\n</workflow-app>");
        CreateImportFileBO workflowBO = new CreateImportFileBO();
        workflowBO.setFileName("workflow.xml");
        workflowBO.setFileType("xml");
        workflowBO.setWorkFlowName(oozieWorkFlowBO.getWorkFlowName());
        workflowBO.setFileContent(returnString);
        return workflowBO;
    }

    private StringBuffer dataxShellNode(OozieWorkFlowNodeBO oozieWorkFlowNodeBO, String workFlowName, String workType) throws ZTBusinessException {
        StringBuffer shellNodeString = new StringBuffer();
        shellNodeString.append("    <action name=\"" + oozieWorkFlowNodeBO.getNodeName() + "\">\n        <shell xmlns=\"uri:oozie:shell-action:0.2\">\n            <job-tracker>${jobTracker}</job-tracker>\n            <name-node>${nameNode}</name-node>\n            <configuration>\n                <property>\n                    <name>mapred.job.queue.name</name>\n                    <value>${queueName}</value>\n                </property>\n            </configuration>\n            <exec>" + oozieWorkFlowNodeBO.getScriptFileName() + "</exec>\n            <argument>${yesterday}</argument>\n            <argument>${beforeyesterday}</argument>\n            <file>" + oozieWorkFlowNodeBO.getScriptFileName() + "</file>\n            <file>" + oozieWorkFlowNodeBO.getNodeName() + ".json</file>\n");
        if ("TP001".equalsIgnoreCase(workType)) {
            shellNodeString.append("            <file>" + workFlowName + "_ddl.sql</file>\n");
        }
        shellNodeString.append("            <capture-output/> \n        </shell>\n        <ok to=\"" + oozieWorkFlowNodeBO.getNextNodeName() + "\"/>\n        <error to=\"fail\"/>\n    </action>\n");
        return shellNodeString;
    }

    private StringBuffer hiveNode(OozieWorkFlowNodeBO oozieWorkFlowNodeBO, String workFlowName) throws ZTBusinessException {
        StringBuffer hiveNodeString = new StringBuffer();
        hiveNodeString.append("    <action name=\"" + oozieWorkFlowNodeBO.getNodeName() + "\">\n        <hive xmlns=\"uri:oozie:hive-action:0.2\">\n            <job-tracker>${jobTracker}</job-tracker>\n            <name-node>${nameNode}</name-node>\n            <job-xml>${nameNode}/user/oozie/hive-site.xml</job-xml>\n            <configuration>\n                <property>\n                    <name>mapred.job.queue.name</name>\n                    <value>${queueName}</value>\n                </property>\n            </configuration>\n            <script>" + oozieWorkFlowNodeBO.getScriptFileName() + "</script>\n            <param>p_start_time=${rundatetime}</param>\n            <param>bizdate=${yesterday}</param>\n            <param>beforebizdate=${beforeyesterday}</param>\n            <param>taskid=${wf:id()}</param>\n        </hive>\n        <ok to=\"" + oozieWorkFlowNodeBO.getNextNodeName() + "\"/>\n        <error to=\"fail\"/>\n    </action>\n");
        return hiveNodeString;
    }

    private StringBuffer switchNode(OozieWorkFlowNodeBO oozieWorkFlowNodeBO, String workFlowName) throws ZTBusinessException {
        StringBuffer hiveNodeString = new StringBuffer();
        hiveNodeString.append("    <decision name=\"" + oozieWorkFlowNodeBO.getNodeName() + "\">\n        <switch>\n            <case to=\"" + oozieWorkFlowNodeBO.getScriptFileName() + "\">${!fs:exists(\"" + this.hdfsHivePath + "/" + workFlowName + "_sync\")}\n            </case> \n            <case to=\"" + oozieWorkFlowNodeBO.getScriptFileName() + "\">${!fs:exists(\"" + this.hdfsHivePath + "/" + workFlowName + "_ad\")}\n            </case> \n            <case to=\"" + oozieWorkFlowNodeBO.getScriptFileName() + "\">${!fs:exists(\"" + this.hdfsHivePath + "/" + workFlowName + "_dl\")}\n            </case> \n            <default to=\"" + oozieWorkFlowNodeBO.getNextNodeName() + "\"/>  \n        </switch>\n    </decision>\n");
        return hiveNodeString;
    }

    public CreateImportFileBO getJobPro(OozieJobPropertiesBO oozieJobPropertiesBO) throws ZTBusinessException {
        JSONObject conf = new JSONObject();
        conf.put("oozieUrl", (Object)oozieJobPropertiesBO.getOozieUrl());
        conf.put("nameNode", (Object)oozieJobPropertiesBO.getOozieNameNode());
        conf.put("jobTracker", (Object)oozieJobPropertiesBO.getOozieJobTracker());
        conf.put("queueName", (Object)"default");
        conf.put("examplesRoot", (Object)oozieJobPropertiesBO.getOozieHdfsPath());
        conf.put("outputpath", (Object)"${nameNode}/${examplesRoot}/log/");
        conf.put("user.name", (Object)"oozie");
        conf.put("start", (Object)LocalTimeToUTC.getDate(oozieJobPropertiesBO.getWorkStartTime()));
        if (StringUtils.isEmpty((String)oozieJobPropertiesBO.getWorkEndTime())) {
            conf.put("end", (Object)"2999-12-31T59:59+0800");
        } else {
            conf.put("end", (Object)LocalTimeToUTC.getDate(oozieJobPropertiesBO.getWorkEndTime()));
        }
        conf.put("runCycle", (Object)oozieJobPropertiesBO.getRunCycle());
        conf.put("workflowAppUri", (Object)("${nameNode}/${examplesRoot}/" + oozieJobPropertiesBO.getWorkFlowName()));
        conf.put("oozie.coord.application.path", (Object)"${workflowAppUri}");
        conf.put("oozie.wf.application.path", (Object)"${workflowAppUri}");
        CreateImportFileBO jobPropertiesFileBO = new CreateImportFileBO();
        jobPropertiesFileBO.setFileName("job.properties");
        jobPropertiesFileBO.setFileType("mappers/job");
        jobPropertiesFileBO.setWorkFlowName(oozieJobPropertiesBO.getWorkFlowName());
        jobPropertiesFileBO.setFileContent(new StringBuffer(conf.toString()));
        return jobPropertiesFileBO;
    }

    public CreateImportFileBO getCoordinatorXml(OozieWorkFlowBO oozieWorkFlowBO) throws ZTBusinessException {
        StringBuffer returnString = new StringBuffer();
        returnString.append("<coordinator-app name=\"" + oozieWorkFlowBO.getWorkFlowName() + "\" frequency=\"${runCycle}\" start=\"${start}\" end=\"${end}\" timezone=\"GMT+0800\" xmlns=\"uri:oozie:coordinator:0.2\">\n    <action>\n        <workflow>\n            <app-path>${workflowAppUri}</app-path>\n            <configuration>\n                <property>\n                    <name>jobTracker</name>\n                    <value>${jobTracker}</value>\n                </property>\n                <property>\n                    <name>nameNode</name>\n                    <value>${nameNode}</value>\n                </property>\n                <property>\n                    <name>queueName</name>\n                    <value>${queueName}</value>\n                </property>\n                <property>\n                    <name>rundatetime</name>\n                    <value>${coord:formatTime(coord:nominalTime(),'yyyy-MM-dd HH:mm:ss')}</value>\n                </property> \n                <property>\n                    <name>yesterday</name>\n                    <value>${coord:formatTime(coord:dateOffset(coord:nominalTime(),-1,'DAY'),'yyyyMMdd')}</value>\n                </property>\n                <property>\n                    <name>beforeyesterday</name>\n                    <value>${coord:formatTime(coord:dateOffset(coord:nominalTime(),-2,'DAY'),'yyyyMMdd')}</value>\n                </property>\n                <property>\n                    <name>yestermonth</name>\n                    <value>${coord:formatTime(coord:dateOffset(coord:nominalTime(),-1,'MONTH'),'yyyyMM')}</value>\n                </property>\n            </configuration>\n        </workflow>\n    </action>\n</coordinator-app>");
        CreateImportFileBO coordinatorXmlBO = new CreateImportFileBO();
        coordinatorXmlBO.setFileName("coordinator.xml");
        coordinatorXmlBO.setFileType("xml");
        coordinatorXmlBO.setWorkFlowName(oozieWorkFlowBO.getWorkFlowName());
        coordinatorXmlBO.setFileContent(returnString);
        return coordinatorXmlBO;
    }
}

