/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.bo.SwapQryTaskInfoReqBO;
import com.yqsmartcity.data.swap.api.bo.SwapQryTaskInfoRspBO;
import com.yqsmartcity.data.swap.api.bo.TaskInfoBO;
import com.yqsmartcity.data.swap.api.service.SwapQryTaskInfoService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.SysParaDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.SysParaPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapQryTaskInfoServiceImpl
implements SwapQryTaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryTaskInfoServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private SysParaDao sysParaDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public SwapQryTaskInfoRspBO qryTaskInfo(SwapQryTaskInfoReqBO reqBO) throws ZTBusinessException {
        SwapQryTaskInfoRspBO rspBO = new SwapQryTaskInfoRspBO();
        this.validateParam(reqBO);
        TaskInfoBO taskInfoBO = this.tableInfoDao.getTaskInfo(reqBO.getUnid());
        if (!StringUtils.isEmpty((String)taskInfoBO.getSwapMode())) {
            taskInfoBO.setSwapModeName(this.qryDatabase(taskInfoBO.getSwapMode(), "SWAP_MODE_TYPE"));
        }
        if (!StringUtils.isEmpty((String)taskInfoBO.getPartionMode())) {
            taskInfoBO.setPartionModeName(this.qryDatabase(taskInfoBO.getPartionMode(), "PARTION_MODE_TYPE"));
        }
        if (!StringUtils.isEmpty((String)taskInfoBO.getSwapCycle())) {
            taskInfoBO.setSwapCycleName(this.qryDatabase(taskInfoBO.getSwapCycle(), "SWAP_CYCLE_TYPE"));
        }
        if (!StringUtils.isEmpty((String)taskInfoBO.getLifeCycleName())) {
            taskInfoBO.setLifeCycle(this.qryParaCode(taskInfoBO.getLifeCycleName(), "TABLE_LIFE_CYCLE_TYPE"));
        }
        if (!StringUtils.isEmpty((String)taskInfoBO.getTargetDatabaseCode())) {
            DatabaseInfoPO qryPO = new DatabaseInfoPO();
            qryPO.setDatabaseCode(taskInfoBO.getTargetDatabaseCode());
            qryPO.setStatus("1");
            DatabaseInfoPO databaseInfoPO = this.databaseInfoDao.getModelBy(qryPO);
            taskInfoBO.setTargetDatabaseName(databaseInfoPO.getDatabaseName());
        }
        rspBO.setTaskInfoBO(taskInfoBO);
        return rspBO;
    }

    private void validateParam(SwapQryTaskInfoReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010unid\u3011\u4e3a\u7a7a");
        }
    }

    private String qryDatabase(String paraCode, String paraType) {
        SysParaPO reqPO = new SysParaPO();
        reqPO.setParaCode(paraCode);
        reqPO.setParaType(paraType);
        reqPO.setStatus("1");
        SysParaPO sysParaPO = this.sysParaDao.getModelBy(reqPO);
        if (null != sysParaPO) {
            return sysParaPO.getParaName();
        }
        return "";
    }

    private String qryParaCode(String paraName, String paraType) {
        SysParaPO reqPO = new SysParaPO();
        reqPO.setParaName(paraName);
        reqPO.setParaType(paraType);
        reqPO.setStatus("1");
        SysParaPO sysParaPO = this.sysParaDao.getModelBy(reqPO);
        if (null != sysParaPO) {
            return sysParaPO.getParaCode();
        }
        return "";
    }
}

