/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.task;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.bo.SwapQryTaskNameAndDatabaseTableReqBO;
import com.yqsmartcity.data.swap.api.bo.SwapQryTaskNameAndDatabaseTableRspBO;
import com.yqsmartcity.data.swap.api.service.SwapQryTaskNameAndDatabaseTableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SwapQryTaskNameAndDatabaseTableServiceImpl
implements SwapQryTaskNameAndDatabaseTableService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryTaskNameAndDatabaseTableServiceImpl.class);
    @Value(value="${swap.table.prefix}")
    private String swapTablePrefix;

    public SwapQryTaskNameAndDatabaseTableRspBO qryTaskNameAndDatabaseTable(SwapQryTaskNameAndDatabaseTableReqBO reqBO) throws ZTBusinessException {
        String sourceTable;
        SwapQryTaskNameAndDatabaseTableRspBO rspBO = new SwapQryTaskNameAndDatabaseTableRspBO();
        this.validateParam(reqBO);
        String tableName = sourceTable = reqBO.getSourceTable().toLowerCase();
        String isTrue = "y";
        if (tableName.length() > 110) {
            tableName = tableName.substring(0, 109);
            isTrue = "n";
        }
        String databaseTable = this.swapTablePrefix + "_" + reqBO.getDatabaseCode() + "_" + isTrue + "_" + tableName;
        String taskName = reqBO.getDatabaseCode() + "_" + isTrue + "_" + tableName + "\u4e1a\u52a1";
        rspBO.setDatabaseTable(databaseTable);
        rspBO.setTaskName(taskName);
        return rspBO;
    }

    private void validateParam(SwapQryTaskNameAndDatabaseTableReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getSourceTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u8868\u3010SourceTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u3010DatabaseCode\u3011\u4e3a\u7a7a");
        }
    }
}

