/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.ability.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.yqsmartcity.data.ref.ability.RfBatchTaskService;
import com.yqsmartcity.data.ref.ability.RfCollectDataTaskService;
import com.yqsmartcity.data.ref.ability.RfCollectFieldService;
import com.yqsmartcity.data.ref.ability.RfDataSourceService;
import com.yqsmartcity.data.ref.ability.RfGenerateFormTaskService;
import com.yqsmartcity.data.ref.ability.RfStatisticsDataTaskService;
import com.yqsmartcity.data.ref.ability.bo.RefRspBaseAbilityBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchItemBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchListReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchTaskBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchTaskListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchTaskRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfGenerateFormTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfGenerateFormTaskRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfStatisticsDataTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfStatisticsDataTaskRspBO;
import com.yqsmartcity.data.ref.db.CommDruidTemplate;
import com.yqsmartcity.data.ref.db.HiveDruidTemplate;
import com.yqsmartcity.data.ref.db.dao.RfBatchTaskMapper;
import com.yqsmartcity.data.ref.db.po.RfBatchTaskPO;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RfBatchTaskServiceImpl
implements RfBatchTaskService {
    private static final Logger log = LoggerFactory.getLogger(RfBatchTaskServiceImpl.class);
    @Value(value="${target.database.code:bk_ot0}")
    private String targetDatabaseCode;
    @Autowired
    RfBatchTaskMapper rfBatchTaskMapper;
    @Autowired
    HiveDruidTemplate hiveDruidTemplate;
    @Autowired
    CommDruidTemplate commDruidTemplate;
    @Autowired
    RfCollectDataTaskService rfCollectDataTaskService;
    @Autowired
    RfStatisticsDataTaskService rfStatisticsDataTaskService;
    @Autowired
    RfGenerateFormTaskService rfGenerateFormTaskService;
    @Autowired
    RfCollectFieldService rfCollectFieldService;
    @Autowired
    private RfDataSourceService rfDataSourceService;

    public RfBatchTaskRspBO queryRfBatchTaskSingle(RfBatchTaskReqBO rfBatchTaskReqBO) {
        RfBatchTaskRspBO rspBO = new RfBatchTaskRspBO();
        RfBatchTaskPO selectRfBatchTaskPO = new RfBatchTaskPO();
        BeanUtils.copyProperties((Object)rfBatchTaskReqBO, (Object)selectRfBatchTaskPO);
        List<RfBatchTaskPO> rfBatchTaskList = this.rfBatchTaskMapper.selectByCondition(selectRfBatchTaskPO);
        if (rfBatchTaskList.size() != 1) {
            if (rfBatchTaskList.size() > 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u6279\u5904\u7406\u4efb\u52a1\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6279\u5904\u7406\u4efb\u52a1");
            }
            throw new ZTBusinessException("\u67e5\u8be2\u6279\u5904\u7406\u4efb\u52a1\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6279\u5904\u7406\u4efb\u52a1");
        }
        RfBatchTaskBO rfBatchTaskBO = new RfBatchTaskBO();
        BeanUtils.copyProperties((Object)rfBatchTaskList.get(0), (Object)rfBatchTaskBO);
        rspBO.setData(rfBatchTaskBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RfBatchTaskListRspBO queryRfBatchTaskList(RfBatchTaskReqBO rfBatchTaskReqBO) {
        RfBatchTaskListRspBO rspBO = new RfBatchTaskListRspBO();
        RfBatchTaskPO selectRfBatchTaskPO = new RfBatchTaskPO();
        BeanUtils.copyProperties((Object)rfBatchTaskReqBO, (Object)selectRfBatchTaskPO);
        List<RfBatchTaskPO> rfBatchTaskPOList = this.rfBatchTaskMapper.selectByCondition(selectRfBatchTaskPO);
        ArrayList<RfBatchTaskBO> rfBatchTaskBOList = new ArrayList<RfBatchTaskBO>();
        for (RfBatchTaskPO rfBatchTaskPO : rfBatchTaskPOList) {
            RfBatchTaskBO rfBatchTaskBO = new RfBatchTaskBO();
            BeanUtils.copyProperties((Object)rfBatchTaskPO, (Object)rfBatchTaskBO);
            rfBatchTaskBOList.add(rfBatchTaskBO);
        }
        rspBO.setData(rfBatchTaskBOList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    public RfBatchListRspBO executeRfBatchTaskList(final RfBatchListReqBO rfBatchListReqBO) {
        if (StringUtils.isBlank((CharSequence)rfBatchListReqBO.getBatchName())) {
            throw new ZTBusinessException("\u6267\u884c\u6279\u5904\u7406\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff1a\u6279\u6b21\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rfBatchListReqBO.getRfBatchItemList() == null || rfBatchListReqBO.getRfBatchItemList().size() < 1) {
            throw new ZTBusinessException("\u6267\u884c\u6279\u5904\u7406\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff1a\u6279\u5904\u7406\u4efb\u52a1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RfBatchListRspBO rspBO = new RfBatchListRspBO();
        final String batchId = "B" + Sequence.getInstance().nextId();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                RfDataSourceReqBO rfDataSourceReqBO = new RfDataSourceReqBO();
                rfDataSourceReqBO.setDataSourceCode(RfBatchTaskServiceImpl.this.targetDatabaseCode);
                RfDataSourceRspBO rfDataSourceRspBO = RfBatchTaskServiceImpl.this.rfDataSourceService.queryRfDataSourceSingle(rfDataSourceReqBO);
                Long orderNo = 1L;
                for (RfBatchItemBO rfBatchItemBO : rfBatchListReqBO.getRfBatchItemList()) {
                    RfBatchTaskReqBO insertRfBatchTaskReqBO = new RfBatchTaskReqBO();
                    insertRfBatchTaskReqBO.setSysCode(rfBatchItemBO.getSysCode());
                    insertRfBatchTaskReqBO.setBatchId(batchId);
                    insertRfBatchTaskReqBO.setBatchName(rfBatchListReqBO.getBatchName());
                    insertRfBatchTaskReqBO.setOrderNo(orderNo);
                    insertRfBatchTaskReqBO.setTaskCode(rfBatchItemBO.getTaskCode());
                    insertRfBatchTaskReqBO.setTaskType(rfBatchItemBO.getTaskType());
                    insertRfBatchTaskReqBO.setExcuteStatus("running");
                    insertRfBatchTaskReqBO.setExcuteStatusDesc("\u8fd0\u884c");
                    RfBatchTaskRspBO insertRfBatchTaskRspBO = new RfBatchTaskRspBO();
                    RfBatchTaskReqBO updateRfBatchTaskReqBO = new RfBatchTaskReqBO();
                    try {
                        RefRspBaseAbilityBO refRspBaseAbilityBO;
                        if ("COLLECT".equals(rfBatchItemBO.getTaskType())) {
                            RfCollectDataTaskReqBO rfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
                            rfCollectDataTaskReqBO.setSysCode(rfBatchItemBO.getSysCode());
                            rfCollectDataTaskReqBO.setCollectTaskCode(rfBatchItemBO.getTaskCode());
                            insertRfBatchTaskRspBO = RfBatchTaskServiceImpl.this.addRfBatchTask(insertRfBatchTaskReqBO);
                            updateRfBatchTaskReqBO.setId(insertRfBatchTaskRspBO.getData().getId());
                            RfCollectDataTaskRspBO rfCollectDataTaskRspBO = RfBatchTaskServiceImpl.this.rfCollectDataTaskService.executeRfCollectDataTask(rfCollectDataTaskReqBO);
                            updateRfBatchTaskReqBO.setExcuteRule(rfCollectDataTaskRspBO.getJobContent());
                            if ("0000".equals(rfCollectDataTaskRspBO.getRespCode())) {
                                updateRfBatchTaskReqBO.setExcuteStatus("finish");
                                updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5b8c\u6210");
                            } else {
                                updateRfBatchTaskReqBO.setExcuteStatus("fail");
                                updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5931\u8d25");
                                updateRfBatchTaskReqBO.setFailReason(rfCollectDataTaskRspBO.getRespDesc());
                            }
                        } else if ("STATISTICS".equals(rfBatchItemBO.getTaskType())) {
                            RfStatisticsDataTaskReqBO rfStatisticsDataTaskReqBO = new RfStatisticsDataTaskReqBO();
                            rfStatisticsDataTaskReqBO.setSysCode(rfBatchItemBO.getSysCode());
                            rfStatisticsDataTaskReqBO.setStatisticsTastCode(rfBatchItemBO.getTaskCode());
                            insertRfBatchTaskRspBO = RfBatchTaskServiceImpl.this.addRfBatchTask(insertRfBatchTaskReqBO);
                            updateRfBatchTaskReqBO.setId(insertRfBatchTaskRspBO.getData().getId());
                            RfStatisticsDataTaskRspBO rfStatisticsDataTaskRspBO = RfBatchTaskServiceImpl.this.rfStatisticsDataTaskService.queryRfStatisticsDataTaskSingle(rfStatisticsDataTaskReqBO);
                            updateRfBatchTaskReqBO.setExcuteRule(rfStatisticsDataTaskRspBO.getData().getStatisticsRule());
                            RfBatchTaskServiceImpl.this.updateRfBatchTask(updateRfBatchTaskReqBO);
                            refRspBaseAbilityBO = null;
                            if ("HDFS".equals(rfDataSourceRspBO.getData().getDataSourceType())) {
                                refRspBaseAbilityBO = RfBatchTaskServiceImpl.this.hiveDruidTemplate.executeSqlWithoutThread(rfStatisticsDataTaskRspBO.getData().getStatisticsRule());
                            } else if ("MYSQL".equals(rfDataSourceRspBO.getData().getDataSourceType())) {
                                refRspBaseAbilityBO = RfBatchTaskServiceImpl.this.commDruidTemplate.executeSqlWithoutThread(rfDataSourceRspBO.getData(), rfStatisticsDataTaskRspBO.getData().getStatisticsRule());
                            } else {
                                throw new ZTBusinessException("\u6267\u884c\u4efb\u52a1\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                            }
                            if ("0000".equals(refRspBaseAbilityBO.getRespCode())) {
                                updateRfBatchTaskReqBO.setExcuteStatus("finish");
                                updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5b8c\u6210");
                            } else {
                                updateRfBatchTaskReqBO.setExcuteStatus("fail");
                                updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5931\u8d25");
                                updateRfBatchTaskReqBO.setFailReason(refRspBaseAbilityBO.getRespDesc());
                            }
                        } else if ("GENERATE".equals(rfBatchItemBO.getTaskType())) {
                            RfGenerateFormTaskReqBO rfGenerateFormTaskReqBO = new RfGenerateFormTaskReqBO();
                            rfGenerateFormTaskReqBO.setGenerateFormTastCode(rfBatchItemBO.getTaskCode());
                            insertRfBatchTaskRspBO = RfBatchTaskServiceImpl.this.addRfBatchTask(insertRfBatchTaskReqBO);
                            updateRfBatchTaskReqBO.setId(insertRfBatchTaskRspBO.getData().getId());
                            RfGenerateFormTaskRspBO rfGenerateFormTaskRspBO = RfBatchTaskServiceImpl.this.rfGenerateFormTaskService.queryRfGenerateFormTaskSingle(rfGenerateFormTaskReqBO);
                            updateRfBatchTaskReqBO.setExcuteRule(rfGenerateFormTaskRspBO.getData().getGenerateFormRule());
                            RfBatchTaskServiceImpl.this.updateRfBatchTask(updateRfBatchTaskReqBO);
                            refRspBaseAbilityBO = null;
                            if ("HDFS".equals(rfDataSourceRspBO.getData().getDataSourceType())) {
                                refRspBaseAbilityBO = RfBatchTaskServiceImpl.this.hiveDruidTemplate.executeSqlWithoutThread(rfGenerateFormTaskRspBO.getData().getGenerateFormRule());
                            } else if ("MYSQL".equals(rfDataSourceRspBO.getData().getDataSourceType())) {
                                refRspBaseAbilityBO = RfBatchTaskServiceImpl.this.commDruidTemplate.executeSqlWithoutThread(rfDataSourceRspBO.getData(), rfGenerateFormTaskRspBO.getData().getGenerateFormRule());
                            } else {
                                throw new ZTBusinessException("\u6267\u884c\u4efb\u52a1\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                            }
                            if ("0000".equals(refRspBaseAbilityBO.getRespCode())) {
                                updateRfBatchTaskReqBO.setExcuteStatus("finish");
                                updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5b8c\u6210");
                            } else {
                                updateRfBatchTaskReqBO.setExcuteStatus("fail");
                                updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5931\u8d25");
                                updateRfBatchTaskReqBO.setFailReason(refRspBaseAbilityBO.getRespDesc());
                            }
                        } else {
                            updateRfBatchTaskReqBO.setExcuteStatus("fail");
                            updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5931\u8d25");
                            updateRfBatchTaskReqBO.setFailReason("\u4e0d\u652f\u6301\u7684\u4efb\u52a1\u7c7b\u578b");
                        }
                    }
                    catch (Throwable e) {
                        String str = RfBatchTaskServiceImpl.this.getThrowableStrRep(e);
                        updateRfBatchTaskReqBO.setExcuteStatus("fail");
                        updateRfBatchTaskReqBO.setExcuteStatusDesc("\u5931\u8d25");
                        updateRfBatchTaskReqBO.setFailReason(str);
                    }
                    Date nowDate = new Date();
                    Long nowTime = nowDate.getTime();
                    Long createTime = insertRfBatchTaskRspBO.getData().getCreateTime().getTime();
                    Long duringTime = nowTime - createTime;
                    updateRfBatchTaskReqBO.setExcuteDuringTime(String.valueOf(duringTime));
                    updateRfBatchTaskReqBO.setFinishTime(nowDate);
                    RfBatchTaskServiceImpl.this.updateRfBatchTask(updateRfBatchTaskReqBO);
                    Long l = orderNo;
                    Long l2 = orderNo = Long.valueOf(orderNo + 1L);
                }
            }
        });
        t.start();
        rspBO.setBatchId(batchId);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspPage<RfBatchTaskBO> queryRfBatchTaskListPage(RfBatchTaskReqBO rfBatchTaskReqBO) {
        return null;
    }

    @Transactional
    public RfBatchTaskRspBO addRfBatchTask(RfBatchTaskReqBO rfBatchTaskReqBO) {
        if (StringUtils.isBlank((CharSequence)rfBatchTaskReqBO.getSysCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfBatchTaskReqBO.getBatchId())) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rfBatchTaskReqBO.getOrderNo() == null) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfBatchTaskReqBO.getTaskCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfBatchTaskReqBO.getTaskType())) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfBatchTaskReqBO.getExcuteStatus())) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)rfBatchTaskReqBO.getFailReason()) && rfBatchTaskReqBO.getFailReason().length() > 1000) {
            rfBatchTaskReqBO.setFailReason(rfBatchTaskReqBO.getFailReason().substring(0, 1000) + "...");
        }
        if (StringUtils.isNotBlank((CharSequence)rfBatchTaskReqBO.getExcuteRule()) && rfBatchTaskReqBO.getExcuteRule().length() > 4000) {
            rfBatchTaskReqBO.setExcuteRule(rfBatchTaskReqBO.getExcuteRule().substring(0, 4000) + "...");
        }
        RfBatchTaskRspBO rspBO = new RfBatchTaskRspBO();
        RfBatchTaskPO insertRfBatchTaskPO = new RfBatchTaskPO();
        BeanUtils.copyProperties((Object)rfBatchTaskReqBO, (Object)insertRfBatchTaskPO);
        long id = Sequence.getInstance().nextId();
        insertRfBatchTaskPO.setId(id);
        insertRfBatchTaskPO.setCreateTime(new Date());
        int num = this.rfBatchTaskMapper.insert(insertRfBatchTaskPO);
        if (num != 1) {
            throw new ZTBusinessException("\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u65b0\u589e\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25");
        }
        RfBatchTaskBO RfBatchTaskBO2 = new RfBatchTaskBO();
        BeanUtils.copyProperties((Object)insertRfBatchTaskPO, (Object)RfBatchTaskBO2);
        rspBO.setData(RfBatchTaskBO2);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    public RfBatchTaskRspBO updateRfBatchTask(RfBatchTaskReqBO rfBatchTaskReqBO) {
        RfBatchTaskPO updateRfBatchTaskPO;
        RfBatchTaskRspBO rspBO = new RfBatchTaskRspBO();
        RfBatchTaskPO selectRfBatchTaskPO = new RfBatchTaskPO();
        selectRfBatchTaskPO.setId(rfBatchTaskReqBO.getId());
        List<RfBatchTaskPO> rfBatchTaskList = this.rfBatchTaskMapper.selectByCondition(selectRfBatchTaskPO);
        if (rfBatchTaskList.size() == 1) {
            updateRfBatchTaskPO = new RfBatchTaskPO();
            BeanUtils.copyProperties((Object)rfBatchTaskReqBO, (Object)updateRfBatchTaskPO);
            int num = this.rfBatchTaskMapper.update(updateRfBatchTaskPO);
            if (num != 1) {
                throw new ZTBusinessException("\u4fee\u6539\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u4fee\u6539\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25");
            }
        } else {
            if (rfBatchTaskList.size() > 1) {
                throw new ZTBusinessException("\u4fee\u6539\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6279\u5904\u7406\u4efb\u52a1");
            }
            throw new ZTBusinessException("\u4fee\u6539\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6279\u5904\u7406\u4efb\u52a1");
        }
        RfBatchTaskBO rfBatchTaskBO = new RfBatchTaskBO();
        BeanUtils.copyProperties((Object)updateRfBatchTaskPO, (Object)rfBatchTaskBO);
        rspBO.setData(rfBatchTaskBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    public RfBatchTaskRspBO saveRfBatchTask(RfBatchTaskReqBO rfBatchTaskReqBO) {
        if (rfBatchTaskReqBO.getId() == null) {
            return this.addRfBatchTask(rfBatchTaskReqBO);
        }
        return this.updateRfBatchTask(rfBatchTaskReqBO);
    }

    @Transactional
    public RfBatchTaskRspBO deleteRfBatchTask(RfBatchTaskReqBO rfBatchTaskReqBO) {
        RfBatchTaskRspBO rspBO = new RfBatchTaskRspBO();
        RfBatchTaskPO selectRfBatchTaskPO = new RfBatchTaskPO();
        selectRfBatchTaskPO.setId(rfBatchTaskReqBO.getId());
        List<RfBatchTaskPO> rfBatchTaskList = this.rfBatchTaskMapper.selectByCondition(selectRfBatchTaskPO);
        if (rfBatchTaskList.size() == 1) {
            RfBatchTaskPO deleteRfBatchTaskPO = new RfBatchTaskPO();
            BeanUtils.copyProperties((Object)rfBatchTaskReqBO, (Object)deleteRfBatchTaskPO);
            int num = this.rfBatchTaskMapper.delete(deleteRfBatchTaskPO);
            if (num != 1) {
                throw new ZTBusinessException("\u5220\u9664\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u5220\u9664\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25");
            }
        } else {
            if (rfBatchTaskList.size() > 1) {
                throw new ZTBusinessException("\u5220\u9664\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6279\u5904\u7406\u4efb\u52a1");
            }
            throw new ZTBusinessException("\u5220\u9664\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6279\u5904\u7406\u4efb\u52a1");
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuffer sb = new StringBuffer();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line + "\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }
}

