/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.ref.ability.RfBatchTaskService;
import com.yqsmartcity.data.ref.ability.RfCollectDataTaskService;
import com.yqsmartcity.data.ref.ability.RfCollectFieldService;
import com.yqsmartcity.data.ref.ability.RfCommDruidTemplateService;
import com.yqsmartcity.data.ref.ability.RfDataSourceService;
import com.yqsmartcity.data.ref.ability.RfGenerateFormTaskService;
import com.yqsmartcity.data.ref.ability.RfTaskService;
import com.yqsmartcity.data.ref.ability.bo.RfBatchItemBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchListReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfBatchListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectFieldReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCopyTableReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfFieldBO;
import com.yqsmartcity.data.ref.ability.bo.RfGenerateFormTaskBO;
import com.yqsmartcity.data.ref.ability.bo.RfGenerateFormTaskListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfGenerateFormTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfTableColumnRspBO;
import com.yqsmartcity.data.ref.ability.bo.Rsp;
import com.yqsmartcity.data.ref.ability.bo.TaskRspBo;
import com.yqsmartcity.data.ref.db.CommDruidTemplate;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="rfTaskService")
public class RfTaskServiceImpl
implements RfTaskService {
    private static final Logger log = LoggerFactory.getLogger(RfTaskServiceImpl.class);
    @Autowired
    private RfBatchTaskService rfBatchTaskService;
    @Autowired
    private RfCollectDataTaskService rfCollectDataTaskService;
    @Autowired
    private RfGenerateFormTaskService rfGenerateFormTaskService;
    @Autowired
    private RfCommDruidTemplateService rfCommDruidTemplateService;
    @Autowired
    RfDataSourceService rfDataSourceService;
    @Autowired
    CommDruidTemplate commDruidTemplate;
    @Autowired
    RfCollectFieldService rfCollectFieldService;
    @Value(value="${rf.fieldBlackList:desc}")
    private String fieldBlackList;

    public TaskRspBo executeAllActiveTask(RfCollectDataTaskReqBO collectTaskReqBO) {
        TaskRspBo rspBo = new TaskRspBo();
        RfBatchListReqBO rfBatchListReqBO = new RfBatchListReqBO();
        rfBatchListReqBO.setBatchName("\u62a5\u8868\u7edf\u8ba1\u6279\u5904\u7406\u4efb\u52a1");
        ArrayList<RfBatchItemBO> rfBatchItemList = new ArrayList<RfBatchItemBO>();
        collectTaskReqBO.setSysCode("data-center");
        collectTaskReqBO.setStatus("COLLECT");
        RfCollectDataTaskListRspBO collectDataTaskListRspBO = this.rfCollectDataTaskService.queryRfCollectDataTaskList(collectTaskReqBO);
        if (collectDataTaskListRspBO.getData() != null) {
            for (RfCollectDataTaskBO collectDataTaskBO : collectDataTaskListRspBO.getData()) {
                RfBatchItemBO rfBatchItemBO = new RfBatchItemBO(collectDataTaskBO.getCollectTaskCode(), "COLLECT");
                rfBatchItemList.add(rfBatchItemBO);
            }
        }
        RfGenerateFormTaskReqBO generateTaskReqBO = new RfGenerateFormTaskReqBO();
        generateTaskReqBO.setSysCode("data-center");
        generateTaskReqBO.setStatus("GENERATE");
        RfGenerateFormTaskListRspBO generateFormTaskListRspBO = this.rfGenerateFormTaskService.queryRfGenerateFormTaskList(generateTaskReqBO);
        if (generateFormTaskListRspBO.getData() != null) {
            for (RfGenerateFormTaskBO generateFormTaskBO : generateFormTaskListRspBO.getData()) {
                RfBatchItemBO rfBatchItemBO = new RfBatchItemBO(generateFormTaskBO.getGenerateFormTastCode(), "GENERATE");
                rfBatchItemList.add(rfBatchItemBO);
            }
        }
        RfCollectDataTaskReqBO mergeTaskReqBO = new RfCollectDataTaskReqBO();
        mergeTaskReqBO.setSysCode("data-center");
        mergeTaskReqBO.setStatus("MERGE");
        RfCollectDataTaskListRspBO mergeDataTaskListRspBO = this.rfCollectDataTaskService.queryRfCollectDataTaskList(mergeTaskReqBO);
        if (mergeDataTaskListRspBO.getData() != null) {
            for (RfCollectDataTaskBO mergeDataTaskBO : mergeDataTaskListRspBO.getData()) {
                RfBatchItemBO rfBatchItemBO = new RfBatchItemBO(mergeDataTaskBO.getCollectTaskCode(), "COLLECT");
                rfBatchItemList.add(rfBatchItemBO);
            }
        }
        rfBatchListReqBO.setRfBatchItemList(rfBatchItemList);
        RfBatchListRspBO rfBatchListRspBO = this.rfBatchTaskService.executeRfBatchTaskList(rfBatchListReqBO);
        if ("0000".equals(rfBatchListRspBO.getRespCode())) {
            rspBo.setRsp(new Rsp("0"));
        } else {
            rspBo.setRsp(new Rsp("1"));
        }
        return rspBo;
    }

    public TaskRspBo executeAutoCopyTable(RfCollectDataTaskReqBO collectTaskReqBO) {
        TaskRspBo rspBo = new TaskRspBo();
        RfBatchListReqBO rfBatchListReqBO = new RfBatchListReqBO();
        rfBatchListReqBO.setBatchName("\u6267\u884c\u81ea\u52a8\u62bd\u53d6\u4efb\u52a1");
        collectTaskReqBO.setSysCode("data-center");
        collectTaskReqBO.setStatus("COLLECT");
        RfCollectDataTaskListRspBO collectDataTaskListRspBO = this.rfCollectDataTaskService.queryRfCollectDataTaskList(collectTaskReqBO);
        if (collectDataTaskListRspBO.getData() != null) {
            RfDataSourceReqBO selectRfDataSourceReqBO = new RfDataSourceReqBO();
            RfDataSourceListRspBO rfDataSourceListRspBO = this.rfDataSourceService.queryRfDataSourceList(selectRfDataSourceReqBO);
            for (RfCollectDataTaskBO collectDataTaskBO : collectDataTaskListRspBO.getData()) {
                String str;
                RfCopyTableReqBO rfCopyTableReqBO = new RfCopyTableReqBO();
                rfCopyTableReqBO.setSysCode(collectDataTaskBO.getSysCode());
                rfCopyTableReqBO.setCollectTable(collectDataTaskBO.getCollectTable());
                rfCopyTableReqBO.setTargetTable(collectDataTaskBO.getTargetTable());
                rfCopyTableReqBO.setCollectDataSourceCode(collectDataTaskBO.getCollectDataSourceCode());
                rfCopyTableReqBO.setTargetDataSourceCode(collectDataTaskBO.getTargetDataSourceCode());
                try {
                    this.rfCommDruidTemplateService.copyTable(rfCopyTableReqBO);
                    selectRfDataSourceReqBO.setDataSourceCode(collectDataTaskBO.getTargetDataSourceCode());
                    RfDataSourceBO currentDataSourceBO = null;
                    if (rfDataSourceListRspBO != null) {
                        for (RfDataSourceBO rfDataSourceBO : rfDataSourceListRspBO.getData()) {
                            if (!rfDataSourceBO.getDataSourceCode().equals(collectDataTaskBO.getTargetDataSourceCode())) continue;
                            currentDataSourceBO = rfDataSourceBO;
                        }
                    }
                    if (currentDataSourceBO == null) {
                        throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\uff08\u7cfb\u7edf\u7f16\u7801=" + collectDataTaskBO.getTargetDataSourceCode() + "\uff09\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728");
                    }
                    ArrayList<RfCollectFieldReqBO> rfCollectFieldList = new ArrayList<RfCollectFieldReqBO>();
                    ArrayList<String> fieldList = new ArrayList<String>();
                    if (!"MYSQL".equals(currentDataSourceBO.getDataSourceType())) continue;
                    RfTableColumnRspBO rfTableColumnRspBO = this.commDruidTemplate.getTableColumns(currentDataSourceBO, collectDataTaskBO.getTargetTable());
                    rfCollectFieldList = new ArrayList();
                    for (RfFieldBO rfFieldBO : rfTableColumnRspBO.getData()) {
                        if (this.fieldBlackList.contains(rfFieldBO.getFieldName())) continue;
                        RfCollectFieldReqBO rfCollectFieldReqBO = new RfCollectFieldReqBO();
                        rfCollectFieldReqBO.setCollectFieldName(rfFieldBO.getFieldName());
                        rfCollectFieldReqBO.setCollectFieldType("VARCHAR");
                        rfCollectFieldReqBO.setCollectFieldDesc("\u65e0");
                        rfCollectFieldList.add(rfCollectFieldReqBO);
                        fieldList.add(rfCollectFieldReqBO.getCollectFieldName());
                    }
                    if (rfCollectFieldList == null || rfCollectFieldList.size() <= 0) continue;
                    RfCollectFieldReqBO deleteRfCollectFieldReqBO = new RfCollectFieldReqBO();
                    deleteRfCollectFieldReqBO.setCollectTaskCode(collectDataTaskBO.getCollectTaskCode());
                    this.rfCollectFieldService.deleteRfCollectField(deleteRfCollectFieldReqBO);
                    for (RfCollectFieldReqBO rfCollectFieldReqBO : rfCollectFieldList) {
                        rfCollectFieldReqBO.setSysCode(collectDataTaskBO.getSysCode());
                        rfCollectFieldReqBO.setCollectTaskCode(collectDataTaskBO.getCollectTaskCode());
                        this.rfCollectFieldService.addRfCollectField(rfCollectFieldReqBO);
                    }
                }
                catch (ZTBusinessException e) {
                    str = this.getThrowableStrRep(e);
                    if (str.contains("\u5df2\u7ecf\u5b58\u5728")) {
                        log.warn("[" + collectDataTaskBO.getCollectTable() + "]\u8868\u5df2\u7ecf\u5b58\u5728,\u8df3\u8fc7\u521b\u5efa");
                        continue;
                    }
                    log.error(str);
                }
                catch (Throwable e) {
                    str = this.getThrowableStrRep(e);
                    if (str.contains("\u5df2\u7ecf\u5b58\u5728")) {
                        log.warn("[" + collectDataTaskBO.getCollectTable() + "]\u8868\u5df2\u7ecf\u5b58\u5728,\u8df3\u8fc7\u521b\u5efa");
                        continue;
                    }
                    log.error(str);
                }
            }
        }
        rspBo.setRsp(new Rsp("0"));
        return rspBo;
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuffer sb = new StringBuffer();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line + "\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }
}

