/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.datax.job;

import com.alibaba.fastjson.annotation.JSONField;
import com.yqsmartcity.data.ref.datax.job.DataxJobWriterBuilder;
import com.yqsmartcity.data.ref.datax.job.HdfsReader;
import com.yqsmartcity.data.ref.datax.job.IndexColumn;
import com.yqsmartcity.data.ref.datax.job.MysqlWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class Hdfs2MysqlBO {
    @JSONField(serialize=false)
    private HdfsReader hdfsReader;
    @JSONField(serialize=false)
    private MysqlWriter mysqlWriter;
    private Job job = new Job();

    public void init(HdfsReader hdfsReader, MysqlWriter mysqlWriter) {
        this.hdfsReader = hdfsReader;
        this.mysqlWriter = mysqlWriter;
        this.job = new Job();
        this.job.init();
    }

    public void init() {
        this.hdfsReader = new HdfsReader();
        this.mysqlWriter = new MysqlWriter();
        this.job = new Job();
        this.job.init();
    }

    @Test
    public void test() {
        Hdfs2MysqlBO hdfs2MysqlBO = new Hdfs2MysqlBO();
        HdfsReader hdfsReader = new HdfsReader();
        hdfsReader.setHaveKerberos(true);
        hdfsReader.setKerberosKeytabFilePath("path");
        hdfsReader.setKerberosPrincipal("acount");
        HashMap<String, String> hadoopConfig = new HashMap<String, String>();
        hadoopConfig.put("dfs.data.transfer.protection", "integrity");
        hdfsReader.setHadoopConfig(hadoopConfig);
        MysqlWriter mysqlWriter = new MysqlWriter();
        mysqlWriter.setWriterJdbcUrl("mysql:jdbc2");
        hdfs2MysqlBO.init(hdfsReader, mysqlWriter);
        System.out.println(new DataxJobWriterBuilder().parseContent(hdfs2MysqlBO));
    }

    public HdfsReader getHdfsReader() {
        return this.hdfsReader;
    }

    public MysqlWriter getMysqlWriter() {
        return this.mysqlWriter;
    }

    public Job getJob() {
        return this.job;
    }

    public void setHdfsReader(HdfsReader hdfsReader) {
        this.hdfsReader = hdfsReader;
    }

    public void setMysqlWriter(MysqlWriter mysqlWriter) {
        this.mysqlWriter = mysqlWriter;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hdfs2MysqlBO)) {
            return false;
        }
        Hdfs2MysqlBO other = (Hdfs2MysqlBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HdfsReader this$hdfsReader = this.getHdfsReader();
        HdfsReader other$hdfsReader = other.getHdfsReader();
        if (this$hdfsReader == null ? other$hdfsReader != null : !((Object)this$hdfsReader).equals(other$hdfsReader)) {
            return false;
        }
        MysqlWriter this$mysqlWriter = this.getMysqlWriter();
        MysqlWriter other$mysqlWriter = other.getMysqlWriter();
        if (this$mysqlWriter == null ? other$mysqlWriter != null : !((Object)this$mysqlWriter).equals(other$mysqlWriter)) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        return !(this$job == null ? other$job != null : !((Object)this$job).equals(other$job));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Hdfs2MysqlBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HdfsReader $hdfsReader = this.getHdfsReader();
        result = result * 59 + ($hdfsReader == null ? 43 : ((Object)$hdfsReader).hashCode());
        MysqlWriter $mysqlWriter = this.getMysqlWriter();
        result = result * 59 + ($mysqlWriter == null ? 43 : ((Object)$mysqlWriter).hashCode());
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        return result;
    }

    public String toString() {
        return "Hdfs2MysqlBO(hdfsReader=" + this.getHdfsReader() + ", mysqlWriter=" + this.getMysqlWriter() + ", job=" + this.getJob() + ")";
    }

    public class Job {
        private Setting setting;
        private List<Content> content;

        public void init() {
            this.setting = new Setting();
            this.setting.init();
            this.content = new ArrayList<Content>();
            Content contentBO = new Content();
            contentBO.init();
            this.content.add(contentBO);
        }

        public Setting getSetting() {
            return this.setting;
        }

        public List<Content> getContent() {
            return this.content;
        }

        public void setSetting(Setting setting) {
            this.setting = setting;
        }

        public void setContent(List<Content> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Job)) {
                return false;
            }
            Job other = (Job)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Setting this$setting = this.getSetting();
            Setting other$setting = other.getSetting();
            if (this$setting == null ? other$setting != null : !((Object)this$setting).equals(other$setting)) {
                return false;
            }
            List<Content> this$content = this.getContent();
            List<Content> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Job;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Setting $setting = this.getSetting();
            result = result * 59 + ($setting == null ? 43 : ((Object)$setting).hashCode());
            List<Content> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "Hdfs2MysqlBO.Job(setting=" + this.getSetting() + ", content=" + this.getContent() + ")";
        }

        public class Content {
            private Reader reader;
            private Writer writer;

            public void init() {
                this.reader = new Reader();
                this.reader.init();
                this.writer = new Writer();
                this.writer.init();
            }

            public Reader getReader() {
                return this.reader;
            }

            public Writer getWriter() {
                return this.writer;
            }

            public void setReader(Reader reader) {
                this.reader = reader;
            }

            public void setWriter(Writer writer) {
                this.writer = writer;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Content)) {
                    return false;
                }
                Content other = (Content)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Reader this$reader = this.getReader();
                Reader other$reader = other.getReader();
                if (this$reader == null ? other$reader != null : !((Object)this$reader).equals(other$reader)) {
                    return false;
                }
                Writer this$writer = this.getWriter();
                Writer other$writer = other.getWriter();
                return !(this$writer == null ? other$writer != null : !((Object)this$writer).equals(other$writer));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Content;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Reader $reader = this.getReader();
                result = result * 59 + ($reader == null ? 43 : ((Object)$reader).hashCode());
                Writer $writer = this.getWriter();
                result = result * 59 + ($writer == null ? 43 : ((Object)$writer).hashCode());
                return result;
            }

            public String toString() {
                return "Hdfs2MysqlBO.Job.Content(reader=" + this.getReader() + ", writer=" + this.getWriter() + ")";
            }

            public class Writer {
                private String name;
                private Parameter parameter;

                public void init() {
                    this.name = Hdfs2MysqlBO.this.mysqlWriter.getWriterName();
                    this.parameter = new Parameter();
                    this.parameter.init();
                }

                public String getName() {
                    return this.name;
                }

                public Parameter getParameter() {
                    return this.parameter;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setParameter(Parameter parameter) {
                    this.parameter = parameter;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Writer)) {
                        return false;
                    }
                    Writer other = (Writer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Parameter this$parameter = this.getParameter();
                    Parameter other$parameter = other.getParameter();
                    return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Writer;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Parameter $parameter = this.getParameter();
                    result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
                    return result;
                }

                public String toString() {
                    return "Hdfs2MysqlBO.Job.Content.Writer(name=" + this.getName() + ", parameter=" + this.getParameter() + ")";
                }

                public class Parameter {
                    private String writeMode;
                    private String username;
                    private String password;
                    private List<String> column;
                    private List<String> session;
                    private List<String> preSql;
                    private List<Connection> connection;

                    public void init() {
                        this.writeMode = Hdfs2MysqlBO.this.mysqlWriter.getWriterWriteMode();
                        this.username = Hdfs2MysqlBO.this.mysqlWriter.getWriterUsername();
                        this.password = Hdfs2MysqlBO.this.mysqlWriter.getWriterPassword();
                        this.column = Hdfs2MysqlBO.this.mysqlWriter.getWriterColumn() == null || Hdfs2MysqlBO.this.mysqlWriter.getWriterColumn().size() == 0 ? new ArrayList<String>() : Hdfs2MysqlBO.this.mysqlWriter.getWriterColumnStr();
                        this.connection = new ArrayList<Connection>();
                        Connection connectionBO = new Connection();
                        connectionBO.init();
                        this.connection.add(connectionBO);
                        this.session = new ArrayList<String>();
                        this.session.add(Hdfs2MysqlBO.this.mysqlWriter.getWriterSession());
                        this.preSql = new ArrayList<String>();
                        this.preSql.add(Hdfs2MysqlBO.this.mysqlWriter.getWriterPreSql());
                    }

                    public String getWriteMode() {
                        return this.writeMode;
                    }

                    public String getUsername() {
                        return this.username;
                    }

                    public String getPassword() {
                        return this.password;
                    }

                    public List<String> getColumn() {
                        return this.column;
                    }

                    public List<String> getSession() {
                        return this.session;
                    }

                    public List<String> getPreSql() {
                        return this.preSql;
                    }

                    public List<Connection> getConnection() {
                        return this.connection;
                    }

                    public void setWriteMode(String writeMode) {
                        this.writeMode = writeMode;
                    }

                    public void setUsername(String username) {
                        this.username = username;
                    }

                    public void setPassword(String password) {
                        this.password = password;
                    }

                    public void setColumn(List<String> column) {
                        this.column = column;
                    }

                    public void setSession(List<String> session) {
                        this.session = session;
                    }

                    public void setPreSql(List<String> preSql) {
                        this.preSql = preSql;
                    }

                    public void setConnection(List<Connection> connection) {
                        this.connection = connection;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Parameter)) {
                            return false;
                        }
                        Parameter other = (Parameter)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$writeMode = this.getWriteMode();
                        String other$writeMode = other.getWriteMode();
                        if (this$writeMode == null ? other$writeMode != null : !this$writeMode.equals(other$writeMode)) {
                            return false;
                        }
                        String this$username = this.getUsername();
                        String other$username = other.getUsername();
                        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                            return false;
                        }
                        String this$password = this.getPassword();
                        String other$password = other.getPassword();
                        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                            return false;
                        }
                        List<String> this$column = this.getColumn();
                        List<String> other$column = other.getColumn();
                        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                            return false;
                        }
                        List<String> this$session = this.getSession();
                        List<String> other$session = other.getSession();
                        if (this$session == null ? other$session != null : !((Object)this$session).equals(other$session)) {
                            return false;
                        }
                        List<String> this$preSql = this.getPreSql();
                        List<String> other$preSql = other.getPreSql();
                        if (this$preSql == null ? other$preSql != null : !((Object)this$preSql).equals(other$preSql)) {
                            return false;
                        }
                        List<Connection> this$connection = this.getConnection();
                        List<Connection> other$connection = other.getConnection();
                        return !(this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Parameter;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $writeMode = this.getWriteMode();
                        result = result * 59 + ($writeMode == null ? 43 : $writeMode.hashCode());
                        String $username = this.getUsername();
                        result = result * 59 + ($username == null ? 43 : $username.hashCode());
                        String $password = this.getPassword();
                        result = result * 59 + ($password == null ? 43 : $password.hashCode());
                        List<String> $column = this.getColumn();
                        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
                        List<String> $session = this.getSession();
                        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
                        List<String> $preSql = this.getPreSql();
                        result = result * 59 + ($preSql == null ? 43 : ((Object)$preSql).hashCode());
                        List<Connection> $connection = this.getConnection();
                        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
                        return result;
                    }

                    public String toString() {
                        return "Hdfs2MysqlBO.Job.Content.Writer.Parameter(writeMode=" + this.getWriteMode() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", column=" + this.getColumn() + ", session=" + this.getSession() + ", preSql=" + this.getPreSql() + ", connection=" + this.getConnection() + ")";
                    }

                    public class Connection {
                        private String jdbcUrl;
                        private List<String> table = new ArrayList<String>();

                        public void init() {
                            this.jdbcUrl = Hdfs2MysqlBO.this.mysqlWriter.getWriterJdbcUrl();
                            this.table = new ArrayList<String>();
                            this.table.add(Hdfs2MysqlBO.this.mysqlWriter.getWriterTable());
                        }

                        public String getJdbcUrl() {
                            return this.jdbcUrl;
                        }

                        public List<String> getTable() {
                            return this.table;
                        }

                        public void setJdbcUrl(String jdbcUrl) {
                            this.jdbcUrl = jdbcUrl;
                        }

                        public void setTable(List<String> table) {
                            this.table = table;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Connection)) {
                                return false;
                            }
                            Connection other = (Connection)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$jdbcUrl = this.getJdbcUrl();
                            String other$jdbcUrl = other.getJdbcUrl();
                            if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
                                return false;
                            }
                            List<String> this$table = this.getTable();
                            List<String> other$table = other.getTable();
                            return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Connection;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $jdbcUrl = this.getJdbcUrl();
                            result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
                            List<String> $table = this.getTable();
                            result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "Hdfs2MysqlBO.Job.Content.Writer.Parameter.Connection(jdbcUrl=" + this.getJdbcUrl() + ", table=" + this.getTable() + ")";
                        }
                    }
                }
            }

            public class Reader {
                private String name;
                private Parameter parameter;

                public void init() {
                    this.name = Hdfs2MysqlBO.this.hdfsReader.getReaderName();
                    this.parameter = new Parameter();
                    this.parameter.init();
                }

                public String getName() {
                    return this.name;
                }

                public Parameter getParameter() {
                    return this.parameter;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setParameter(Parameter parameter) {
                    this.parameter = parameter;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Reader)) {
                        return false;
                    }
                    Reader other = (Reader)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Parameter this$parameter = this.getParameter();
                    Parameter other$parameter = other.getParameter();
                    return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Reader;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Parameter $parameter = this.getParameter();
                    result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
                    return result;
                }

                public String toString() {
                    return "Hdfs2MysqlBO.Job.Content.Reader(name=" + this.getName() + ", parameter=" + this.getParameter() + ")";
                }

                public class Parameter {
                    private String defaultFS;
                    private String fieldDelimiter;
                    private String fileType;
                    private String path;
                    private String encoding;
                    private List<IndexColumn> column;
                    private Boolean haveKerberos;
                    private String kerberosKeytabFilePath;
                    private String kerberosPrincipal;
                    private Map<String, String> hadoopConfig;

                    public void init() {
                        this.defaultFS = Hdfs2MysqlBO.this.hdfsReader.getDefaultFS();
                        this.fieldDelimiter = Hdfs2MysqlBO.this.hdfsReader.getFieldDelimiter();
                        this.fileType = Hdfs2MysqlBO.this.hdfsReader.getFileType();
                        this.path = Hdfs2MysqlBO.this.hdfsReader.getPath();
                        this.encoding = Hdfs2MysqlBO.this.hdfsReader.getEncoding();
                        this.haveKerberos = Hdfs2MysqlBO.this.hdfsReader.getHaveKerberos();
                        this.kerberosKeytabFilePath = Hdfs2MysqlBO.this.hdfsReader.getKerberosKeytabFilePath();
                        this.kerberosPrincipal = Hdfs2MysqlBO.this.hdfsReader.getKerberosPrincipal();
                        this.hadoopConfig = Hdfs2MysqlBO.this.hdfsReader.getHadoopConfig();
                        this.column = Hdfs2MysqlBO.this.hdfsReader.getReaderColumn() == null || Hdfs2MysqlBO.this.hdfsReader.getReaderColumn().size() == 0 ? new ArrayList<IndexColumn>() : Hdfs2MysqlBO.this.hdfsReader.getReaderColumn();
                    }

                    public String getDefaultFS() {
                        return this.defaultFS;
                    }

                    public String getFieldDelimiter() {
                        return this.fieldDelimiter;
                    }

                    public String getFileType() {
                        return this.fileType;
                    }

                    public String getPath() {
                        return this.path;
                    }

                    public String getEncoding() {
                        return this.encoding;
                    }

                    public List<IndexColumn> getColumn() {
                        return this.column;
                    }

                    public Boolean getHaveKerberos() {
                        return this.haveKerberos;
                    }

                    public String getKerberosKeytabFilePath() {
                        return this.kerberosKeytabFilePath;
                    }

                    public String getKerberosPrincipal() {
                        return this.kerberosPrincipal;
                    }

                    public Map<String, String> getHadoopConfig() {
                        return this.hadoopConfig;
                    }

                    public void setDefaultFS(String defaultFS) {
                        this.defaultFS = defaultFS;
                    }

                    public void setFieldDelimiter(String fieldDelimiter) {
                        this.fieldDelimiter = fieldDelimiter;
                    }

                    public void setFileType(String fileType) {
                        this.fileType = fileType;
                    }

                    public void setPath(String path) {
                        this.path = path;
                    }

                    public void setEncoding(String encoding) {
                        this.encoding = encoding;
                    }

                    public void setColumn(List<IndexColumn> column) {
                        this.column = column;
                    }

                    public void setHaveKerberos(Boolean haveKerberos) {
                        this.haveKerberos = haveKerberos;
                    }

                    public void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
                        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
                    }

                    public void setKerberosPrincipal(String kerberosPrincipal) {
                        this.kerberosPrincipal = kerberosPrincipal;
                    }

                    public void setHadoopConfig(Map<String, String> hadoopConfig) {
                        this.hadoopConfig = hadoopConfig;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Parameter)) {
                            return false;
                        }
                        Parameter other = (Parameter)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$defaultFS = this.getDefaultFS();
                        String other$defaultFS = other.getDefaultFS();
                        if (this$defaultFS == null ? other$defaultFS != null : !this$defaultFS.equals(other$defaultFS)) {
                            return false;
                        }
                        String this$fieldDelimiter = this.getFieldDelimiter();
                        String other$fieldDelimiter = other.getFieldDelimiter();
                        if (this$fieldDelimiter == null ? other$fieldDelimiter != null : !this$fieldDelimiter.equals(other$fieldDelimiter)) {
                            return false;
                        }
                        String this$fileType = this.getFileType();
                        String other$fileType = other.getFileType();
                        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
                            return false;
                        }
                        String this$path = this.getPath();
                        String other$path = other.getPath();
                        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                            return false;
                        }
                        String this$encoding = this.getEncoding();
                        String other$encoding = other.getEncoding();
                        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
                            return false;
                        }
                        List<IndexColumn> this$column = this.getColumn();
                        List<IndexColumn> other$column = other.getColumn();
                        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                            return false;
                        }
                        Boolean this$haveKerberos = this.getHaveKerberos();
                        Boolean other$haveKerberos = other.getHaveKerberos();
                        if (this$haveKerberos == null ? other$haveKerberos != null : !((Object)this$haveKerberos).equals(other$haveKerberos)) {
                            return false;
                        }
                        String this$kerberosKeytabFilePath = this.getKerberosKeytabFilePath();
                        String other$kerberosKeytabFilePath = other.getKerberosKeytabFilePath();
                        if (this$kerberosKeytabFilePath == null ? other$kerberosKeytabFilePath != null : !this$kerberosKeytabFilePath.equals(other$kerberosKeytabFilePath)) {
                            return false;
                        }
                        String this$kerberosPrincipal = this.getKerberosPrincipal();
                        String other$kerberosPrincipal = other.getKerberosPrincipal();
                        if (this$kerberosPrincipal == null ? other$kerberosPrincipal != null : !this$kerberosPrincipal.equals(other$kerberosPrincipal)) {
                            return false;
                        }
                        Map<String, String> this$hadoopConfig = this.getHadoopConfig();
                        Map<String, String> other$hadoopConfig = other.getHadoopConfig();
                        return !(this$hadoopConfig == null ? other$hadoopConfig != null : !((Object)this$hadoopConfig).equals(other$hadoopConfig));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Parameter;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $defaultFS = this.getDefaultFS();
                        result = result * 59 + ($defaultFS == null ? 43 : $defaultFS.hashCode());
                        String $fieldDelimiter = this.getFieldDelimiter();
                        result = result * 59 + ($fieldDelimiter == null ? 43 : $fieldDelimiter.hashCode());
                        String $fileType = this.getFileType();
                        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
                        String $path = this.getPath();
                        result = result * 59 + ($path == null ? 43 : $path.hashCode());
                        String $encoding = this.getEncoding();
                        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
                        List<IndexColumn> $column = this.getColumn();
                        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
                        Boolean $haveKerberos = this.getHaveKerberos();
                        result = result * 59 + ($haveKerberos == null ? 43 : ((Object)$haveKerberos).hashCode());
                        String $kerberosKeytabFilePath = this.getKerberosKeytabFilePath();
                        result = result * 59 + ($kerberosKeytabFilePath == null ? 43 : $kerberosKeytabFilePath.hashCode());
                        String $kerberosPrincipal = this.getKerberosPrincipal();
                        result = result * 59 + ($kerberosPrincipal == null ? 43 : $kerberosPrincipal.hashCode());
                        Map<String, String> $hadoopConfig = this.getHadoopConfig();
                        result = result * 59 + ($hadoopConfig == null ? 43 : ((Object)$hadoopConfig).hashCode());
                        return result;
                    }

                    public String toString() {
                        return "Hdfs2MysqlBO.Job.Content.Reader.Parameter(defaultFS=" + this.getDefaultFS() + ", fieldDelimiter=" + this.getFieldDelimiter() + ", fileType=" + this.getFileType() + ", path=" + this.getPath() + ", encoding=" + this.getEncoding() + ", column=" + this.getColumn() + ", haveKerberos=" + this.getHaveKerberos() + ", kerberosKeytabFilePath=" + this.getKerberosKeytabFilePath() + ", kerberosPrincipal=" + this.getKerberosPrincipal() + ", hadoopConfig=" + this.getHadoopConfig() + ")";
                    }
                }
            }
        }

        public class Setting {
            private Speed speed;

            public void init() {
                this.speed = new Speed();
                this.speed.init();
            }

            public Speed getSpeed() {
                return this.speed;
            }

            public void setSpeed(Speed speed) {
                this.speed = speed;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Setting)) {
                    return false;
                }
                Setting other = (Setting)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Speed this$speed = this.getSpeed();
                Speed other$speed = other.getSpeed();
                return !(this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Setting;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Speed $speed = this.getSpeed();
                result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
                return result;
            }

            public String toString() {
                return "Hdfs2MysqlBO.Job.Setting(speed=" + this.getSpeed() + ")";
            }

            public class Speed {
                private Integer channel;

                public void init() {
                    this.channel = 1;
                }

                public Integer getChannel() {
                    return this.channel;
                }

                public void setChannel(Integer channel) {
                    this.channel = channel;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Speed)) {
                        return false;
                    }
                    Speed other = (Speed)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Integer this$channel = this.getChannel();
                    Integer other$channel = other.getChannel();
                    return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Speed;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Integer $channel = this.getChannel();
                    result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
                    return result;
                }

                public String toString() {
                    return "Hdfs2MysqlBO.Job.Setting.Speed(channel=" + this.getChannel() + ")";
                }
            }
        }
    }
}

