/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.ref.ability.bo.RefRspBaseAbilityBO;
import com.yqsmartcity.data.ref.ability.bo.RfFieldBO;
import com.yqsmartcity.data.ref.ability.bo.RfTableColumnRspBO;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;
import org.springframework.stereotype.Component;

@Component
public class HiveDruidTemplate {
    private static final Logger log = LoggerFactory.getLogger(HiveDruidTemplate.class);
    private static JdbcTemplate hiveJdbcTemplate;
    @Value(value="${hive.url:#}")
    private String url;
    @Value(value="${hive.user:#}")
    private String user;
    @Value(value="${hive.password:#}")
    private String password;
    @Value(value="${hive.driver-class-name:org.apache.hive.jdbc.HiveDriver}")
    private String driverClassName;
    @Value(value="${hive.initialSize:1}")
    private Integer initialSize;
    @Value(value="${hive.minIdle:3}")
    private Integer minIdle;
    @Value(value="${hive.maxActive:20}")
    private Integer maxActive;
    @Value(value="${hive.maxWait:60000}")
    private Integer maxWait;
    @Value(value="${hive.timeBetweenEvictionRunsMillis:60000}")
    private Integer timeBetweenEvictionRunsMillis;
    @Value(value="${hive.minEvictableIdleTimeMillis:30000}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${hive.validationQuery:select 1}")
    private String validationQuery;
    @Value(value="${hive.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${hive.testOnBorrow:false}")
    private boolean testOnBorrow;
    @Value(value="${hive.testOnReturn:false}")
    private boolean testOnReturn;
    @Value(value="${hive.poolPreparedStatements:true}")
    private boolean poolPreparedStatements;
    @Value(value="${hive.maxPoolPreparedStatementPerConnectionSize:20}")
    private Integer maxPoolPreparedStatementPerConnectionSize;

    public JdbcTemplate createNewJdbcTemplate() {
        if (hiveJdbcTemplate == null) {
            DruidDataSource datasource = new DruidDataSource();
            datasource.setUrl(this.url);
            datasource.setUsername(this.user);
            datasource.setPassword(this.password);
            datasource.setDriverClassName(this.driverClassName);
            datasource.setInitialSize(this.initialSize.intValue());
            datasource.setMinIdle(this.minIdle.intValue());
            datasource.setMaxActive(this.maxActive.intValue());
            datasource.setMaxWait((long)this.maxWait.intValue());
            datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis.intValue());
            datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis.intValue());
            datasource.setValidationQuery(this.validationQuery);
            datasource.setTestWhileIdle(this.testWhileIdle);
            datasource.setTestOnBorrow(this.testOnBorrow);
            datasource.setTestOnReturn(this.testOnReturn);
            datasource.setPoolPreparedStatements(this.poolPreparedStatements);
            datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize.intValue());
            hiveJdbcTemplate = new JdbcTemplate((DataSource)datasource);
            return hiveJdbcTemplate;
        }
        return hiveJdbcTemplate;
    }

    public void executeSql(final String sql) {
        log.info("Running: " + sql);
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            final JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            String[] sqls = sql.split(";");
                            for (int i = 0; i < sqls.length; ++i) {
                                if (!StringUtils.isNotBlank((CharSequence)sqls[i])) continue;
                                jdbcTemplate.execute(sqls[i]);
                            }
                        }
                        catch (DataAccessException dae) {
                            if (dae.getMessage().contains("code 2")) break block3;
                            String result = "executeSql encounter an error: " + dae.getMessage();
                            log.error(result);
                            dae.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        } else {
            log.error("Running failed: sql\u4e3a\u7a7a");
        }
    }

    public RefRspBaseAbilityBO executeSqlWithoutThread(String sql) {
        RefRspBaseAbilityBO rspBO = new RefRspBaseAbilityBO();
        log.info("Running: " + sql);
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate();
            try {
                String[] sqls = sql.split(";");
                for (int i = 0; i < sqls.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)sqls[i])) continue;
                    jdbcTemplate.execute(sqls[i]);
                }
            }
            catch (DataAccessException dae) {
                if (dae.getMessage().contains("code 2")) {
                    rspBO.setRespDesc("\u6210\u529f");
                    rspBO.setRespCode("0000");
                    return rspBO;
                }
                String result = "executeSql encounter an error: " + dae.getMessage();
                log.error(result);
                rspBO.setRespDesc(dae.getMessage());
                rspBO.setRespCode("8888");
                return rspBO;
            }
        } else {
            log.error("Running failed: sql\u4e3a\u7a7a");
            rspBO.setRespDesc("Running failed: sql\u4e3a\u7a7a");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RfTableColumnRspBO getTableColumns(String tableName) {
        RfTableColumnRspBO rspBO = new RfTableColumnRspBO();
        ArrayList<RfFieldBO> list = new ArrayList<RfFieldBO>();
        JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate();
        String sql = "select * from " + tableName + " limit 1";
        RowCountCallbackHandler rcch = new RowCountCallbackHandler();
        try {
            jdbcTemplate.query(sql, (RowCallbackHandler)rcch);
            String[] coloumn = rcch.getColumnNames();
            if (coloumn == null || coloumn.length == 0) {
                throw new ZTBusinessException("\u67e5\u8be2\u8868\u5217\u4fe1\u606f\u5931\u8d25\uff1ahive\u6570\u636e\u4e3a\u7a7a\u65e0\u6cd5\u83b7\u53d6\u8868\u5217\u4fe1\u606f");
            }
            for (int i = 0; i < coloumn.length; ++i) {
                RfFieldBO rfFieldBO = new RfFieldBO();
                int index = coloumn[i].indexOf(".") + 1;
                rfFieldBO.setFieldName(coloumn[i].substring(index));
                rfFieldBO.setFieldType("VARCHAR");
                list.add(rfFieldBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Running failed: \u83b7\u53d6\u8868\u5217\u5931\u8d25");
            rspBO.setRespDesc("Running failed: \u83b7\u53d6\u8868\u5217\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        rspBO.setData(list);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

