/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.junit.Test;

public class AesUtil {
    public static final String DEFAULT_AES_KEY = "12345678901234561234567890123456";
    private static String iv = "0123456789ABCDEF";
    private static String Algorithm = "AES";
    private static String AlgorithmProvider = "AES/ECB/PKCS5Padding";

    public static byte[] generatorKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(Algorithm);
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static IvParameterSpec getIv() throws UnsupportedEncodingException {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes("utf-8"));
        System.out.println("\u504f\u79fb\u91cf\uff1a" + AesUtil.byteToHexString(ivParameterSpec.getIV()));
        return ivParameterSpec;
    }

    public static byte[] encrypt(String src, byte[] key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        SecretKeySpec secretKey = new SecretKeySpec(key, Algorithm);
        Cipher cipher = Cipher.getInstance(AlgorithmProvider);
        cipher.init(1, secretKey);
        byte[] cipherBytes = cipher.doFinal(src.getBytes(Charset.forName("utf-8")));
        return cipherBytes;
    }

    public static byte[] decrypt(String src, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, Algorithm);
        Cipher cipher = Cipher.getInstance(AlgorithmProvider);
        cipher.init(2, secretKey);
        byte[] hexBytes = AesUtil.hexStringToBytes(src);
        byte[] plainBytes = cipher.doFinal(hexBytes);
        return plainBytes;
    }

    public static String byteToHexString(byte[] src) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                sb.append("0");
            }
            sb.append(hv);
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            b[i] = (byte)(AesUtil.charToByte(hexChars[pos]) << 4 | AesUtil.charToByte(hexChars[pos + 1]));
        }
        return b;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String encryptStr(String strCode, String key) {
        try {
            byte[] keyByte = key.getBytes("utf-8");
            return AesUtil.byteToHexString(AesUtil.encrypt(strCode, keyByte));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String decryptStr(String strCode, String key) throws Exception {
        byte[] keyByte = key.getBytes("utf-8");
        return new String(AesUtil.decrypt(strCode, keyByte), "utf-8");
    }

    @Test
    public void test() {
        String strCode = "truncate table dm_dzsc.purchase_payment_report;\ninsert into dm_dzsc.purchase_payment_report\nselect \npd.PURCHASE_NO,\npayable.payable_num,\npaid.paid_num ,\n(payable.payable_num-paid.paid_num) as wait_num,\noverp.over_num,\npayable.payable_amt,\npayable.paid_amt,\n(payable.payable_amt-payable.paid_amt) as wait_amt,\noverp.over_amt,\npd4.AVG_APPLY_TIME,\npd4.MAX_APPLY_TIME,\npd4.MIN_APPLY_TIME,\nueo.ORG_NAME\nfrom \n(\nselect PURCHASE_NO from d_payable_detail  where PURCHASE_NO is not null group by PURCHASE_NO \n) pd\nleft join\n(\nselect PURCHASE_NO,sum(1) as payable_num,sum(PAYABLE_AMT) payable_amt,sum(PAID_AMT) paid_amt from d_payable_detail \nwhere PURCHASE_NO is not null and PAYABLE_STATUS in ('01','02','03') \ngroup by PURCHASE_NO \n) payable\non pd.PURCHASE_NO=payable.PURCHASE_NO\nleft join\n(\nselect PURCHASE_NO,sum(1) as paid_num from d_payable_detail \nwhere PURCHASE_NO is not null and PAYABLE_STATUS in ('03') \ngroup by PURCHASE_NO \n) paid\non pd.PURCHASE_NO=paid.PURCHASE_NO\nleft join\n(\nselect PURCHASE_NO,sum(1) as over_num,sum(PAYABLE_AMT-PAID_AMT) as over_amt from d_payable_detail \nwhere PURCHASE_NO is not null and PAYABLE_STATUS in ('01','02') and from_unixtime(unix_timestamp(), 'yyyy-MM-dd HH:mm:ss')>PAID_DATE\ngroup by PURCHASE_NO \n) overp\non pd.PURCHASE_NO=overp.PURCHASE_NO\nleft join\n(\nselect \npd3.PURCHASE_NO,\navg(pd3.APPLY_TIME) as AVG_APPLY_TIME,\nmax(pd3.APPLY_TIME) as MAX_APPLY_TIME,\nmin(pd3.APPLY_TIME) as MIN_APPLY_TIME\nfrom\n(\nselect\npd2.PURCHASE_NO,\npd2.CREATE_DATE,\n(CAST((unix_timestamp(api.APPLY_DATE) - unix_timestamp(pd2.CREATE_DATE)) / (60 * 60) AS int) % 24 ) as APPLY_TIME\nfrom \n(\nselect PAYABLE_NO,APPLY_NO from d_apply_detail\n) pd1\nleft join \n(\nselect PURCHASE_NO,PAYABLE_NO,CREATE_DATE from d_payable_detail  \nwhere PURCHASE_NO is not null and PAYABLE_STATUS in ('02','03') \n) pd2\non  pd1.PAYABLE_NO=pd2.PAYABLE_NO\nleft join\n(\nselect payno,APPLY_DATE,pay_amt from d_apply_pay_info\n) api\n on api.payno = pd1.APPLY_NO\n where PURCHASE_NO is not null\n ) pd3\nGROUP BY pd3.PURCHASE_NO \n) pd4\non pd.PURCHASE_NO=pd4.PURCHASE_NO\nleft join\numc_enterprise_org ueo\non pd.PURCHASE_NO=ueo.ORG_ID";
        String key = DEFAULT_AES_KEY;
        try {
            String ec = AesUtil.encryptStr(strCode, key);
            System.out.println("\u52a0\u5bc6\uff1a" + ec);
            System.out.println("\u89e3\u5bc6\uff1a" + AesUtil.decryptStr(ec, key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

