/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.controller.azkaban;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanFlowScheduleBO;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanMetadataBO;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanUploadZipReqBO;
import com.yqsmartcity.data.swap.api.azkaban.service.CreateAzkabanConfFileService;
import com.yqsmartcity.data.swap.api.azkaban.service.ScheduleExecByCronService;
import com.yqsmartcity.data.swap.api.azkaban.service.UploadZipToAzkabanService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadReqBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateOozieConfFileService;
import com.yqsmartcity.data.swap.constant.FileZipUtilTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/swap-api/data/cleanrule"})
public class CreateLocalFileAndUploadController {
    private static final Logger logger = LoggerFactory.getLogger(CreateLocalFileAndUploadController.class);
    @Autowired
    private CreateAzkabanConfFileService createAzkabanConfFileService;
    @Autowired
    private CreateOozieConfFileService createOozieConfFileService;
    @Autowired
    UploadZipToAzkabanService uploadZipToAzkabanService;
    @Autowired
    private ScheduleExecByCronService scheduleExecByCronService;
    @Value(value="${zip.file.path}")
    private String zipFilePath;

    @RequestMapping(value={"/localFileAndUpload"}, method={RequestMethod.GET})
    @BusiResponseBody
    public void localFileAndUpload(@Valid ScriptDownloadReqBO reqBO, BindingResult result, HttpServletResponse response) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        List scriptDownloadRspBO = this.createOozieConfFileService.createOozieConf(reqBO);
        Date sysDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String dateString = format.format(sysDate);
        String zipFileName = "";
        ArrayList<CreateImportFileBO> fileInfo = new ArrayList<CreateImportFileBO>();
        ArrayList<AzkabanMetadataBO> ListInfo = new ArrayList<AzkabanMetadataBO>();
        for (CreateImportFileRspBO createImportFileRspBO : scriptDownloadRspBO) {
            for (CreateImportFileBO createImportFileBO : createImportFileRspBO.getReateImportFileBO()) {
                logger.info("-----=azkaban_conf_file/" + dateString + "/" + reqBO.getUsername() + "/" + createImportFileBO.getFileType() + "/");
                CreateImportFileBO createImportFileBOTemp = new CreateImportFileBO();
                createImportFileBOTemp.setFileType(createImportFileBO.getFileType());
                createImportFileBOTemp.setFilePath("azkaban_conf_file/user_file/" + dateString + "/" + reqBO.getUsername() + "/" + createImportFileBO.getFileType());
                createImportFileBOTemp.setFileName(createImportFileBO.getFileName());
                fileInfo.add(createImportFileBOTemp);
                if (!"mappers/job".equalsIgnoreCase(createImportFileBO.getFileType()) || !"_sum.job".equalsIgnoreCase(createImportFileBO.getFileName().substring(createImportFileBO.getFileName().length() - 8))) continue;
                AzkabanMetadataBO azkabanMetadataBO = new AzkabanMetadataBO();
                azkabanMetadataBO.setFlow(createImportFileBO.getFileName().substring(0, createImportFileBO.getFileName().length() - 4));
                ListInfo.add(azkabanMetadataBO);
            }
        }
        AzkabanUploadZipReqBO azkabanUploadZipReqBO = new AzkabanUploadZipReqBO();
        azkabanUploadZipReqBO.setFileInfo(fileInfo);
        this.uploadZipToAzkabanService.uploadZipToAzkaban(azkabanUploadZipReqBO);
        AzkabanFlowScheduleBO listInfo = new AzkabanFlowScheduleBO();
        listInfo.setListInfo(ListInfo);
        this.scheduleExecByCronService.scheduleByCron(listInfo);
    }

    private static void zipFile(String filePath) throws ZTBusinessException {
        try {
            FileOutputStream fos1 = new FileOutputStream(new File(filePath + ".zip"));
            FileZipUtilTools.toZip(new File(filePath), fos1, true);
        }
        catch (FileNotFoundException e) {
            throw new ZTBusinessException(e.getLocalizedMessage());
        }
    }
}

