/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban;

import com.alibaba.druid.filter.config.ConfigTools;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanMetadataBO;
import com.yqsmartcity.data.swap.api.azkaban.service.AzkabanLoginService;
import com.yqsmartcity.data.swap.service.busi.impl.azkaban.util.AzkabanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AzkabanLoginServiceImpl
implements AzkabanLoginService {
    private static final Logger log = LoggerFactory.getLogger(AzkabanLoginServiceImpl.class);
    @Value(value="${azkaban.url}")
    private String azkabanUrl;
    @Value(value="${azkaban.username}")
    private String azkabanUserName;
    @Value(value="${azkaban.password}")
    private String azkabanPassword;

    public AzkabanMetadataBO login(AzkabanMetadataBO azkabanMetadataBO) {
        ObjectMapper mapper = new ObjectMapper();
        azkabanMetadataBO.setUrl(this.azkabanUrl);
        azkabanMetadataBO.setUserName(this.azkabanUserName);
        String password = "";
        try {
            password = ConfigTools.decrypt((String)this.azkabanPassword);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u767b\u9646azkaban\u754c\u9762\u7684\u5bc6\u7801\u9519\u8bef\uff01");
        }
        azkabanMetadataBO.setPassword(password);
        try {
            String login = AzkabanUtil.login(azkabanMetadataBO.getUrl(), azkabanMetadataBO.getUserName(), azkabanMetadataBO.getPassword());
            JsonNode jsonNode = mapper.readTree(login);
            if (jsonNode.path("status").asText().equals("success")) {
                log.info("azkaban:\u767b\u5f55\u6210\u529f");
                azkabanMetadataBO.setSessionID(jsonNode.path("session.id").asText());
            } else if (jsonNode.has("error")) {
                log.error("zkaban\u767b\u5f55\u5931\u8d25:{}", (Object)jsonNode.path("error").asText());
            }
        }
        catch (Exception e) {
            log.error("azkaban:\u767b\u5f55\u5931\u8d25");
            e.printStackTrace();
        }
        return azkabanMetadataBO;
    }
}

