/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanFlowScheduleBO;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanMetadataBO;
import com.yqsmartcity.data.swap.api.azkaban.service.AzkabanLoginService;
import com.yqsmartcity.data.swap.api.azkaban.service.ScheduleExecByCronService;
import com.yqsmartcity.data.swap.service.busi.impl.azkaban.util.AzkabanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScheduleExecByCronServiceImpl
implements ScheduleExecByCronService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleExecByCronServiceImpl.class);
    @Value(value="${azkaban.project}")
    private String azkabanProject;
    @Value(value="${azkaban.cron}")
    private String azkabanCron;
    @Autowired
    AzkabanLoginService azkabanLoginService;

    public AzkabanMetadataBO scheduleByCron(AzkabanFlowScheduleBO listInfo) throws ZTBusinessException {
        ObjectMapper mapper = new ObjectMapper();
        AzkabanMetadataBO azkabanMetadataBO = new AzkabanMetadataBO();
        this.azkabanLoginService.login(azkabanMetadataBO);
        azkabanMetadataBO.setProject(this.azkabanProject);
        azkabanMetadataBO.setCron(this.azkabanCron);
        try {
            for (AzkabanMetadataBO azkabanMetadataBOFor : listInfo.getListInfo()) {
                azkabanMetadataBO.setFlow(azkabanMetadataBOFor.getFlow());
                String scheduleByCronEXEaFlow = AzkabanUtil.scheduleByCronEXEaFlow(azkabanMetadataBO.getUrl(), azkabanMetadataBO.getSessionID(), azkabanMetadataBO.getProject(), azkabanMetadataBO.getCron(), azkabanMetadataBO.getFlow());
                JsonNode scheduleNode = mapper.readTree(scheduleByCronEXEaFlow);
                if (scheduleNode.path("status").asText().equals("success")) {
                    azkabanMetadataBO.setScheduleID(scheduleNode.path("scheduleId").asText());
                    log.info("azkaban\u914d\u7f6e\u8c03\u5ea6\u5468\u671f\u6210\u529f");
                    continue;
                }
                if (!scheduleNode.has("error")) continue;
                log.error("azkaban\u914d\u7f6e\u8c03\u5ea6\u5468\u671f\u5931\u8d25:{}", (Object)scheduleNode.path("error").asText());
            }
        }
        catch (Exception e) {
            log.error("azkaban\u914d\u7f6e\u8c03\u5ea6\u5468\u671f\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        return azkabanMetadataBO;
    }
}

