/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban;

import com.yqsmartcity.data.swap.api.azkaban.bo.GetFileStringBufferBO;
import com.yqsmartcity.data.swap.api.azkaban.service.SwapGetAzkabanShellService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SwapGetAzkabanShellServiceimpl
implements SwapGetAzkabanShellService {
    private static final Logger log = LoggerFactory.getLogger(SwapGetAzkabanShellServiceimpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapGetAzkabanShellServiceimpl.class);
    @Value(value="${azkaban.shell.home}")
    private String azkabanShellHome;
    @Value(value="${datax.bin.home}")
    private String dataxBinHome;
    @Value(value="${datax.json.home}")
    private String dataxJsonHome;
    @Value(value="${hive.sql.home}")
    private String hiveSqlHome;

    public List<GetFileStringBufferBO> getShellList(CreateImportFileReqBO importFileReqBO) {
        ArrayList<GetFileStringBufferBO> shellList = new ArrayList<GetFileStringBufferBO>();
        StringBuffer shareStr = new StringBuffer();
        shareStr.append("#!/bin/sh\n");
        shareStr.append("#ecoding=utf-8\n\n");
        shareStr.append("set -x\n\n");
        shareStr.append("if [ $1 ]\n");
        shareStr.append("then\n");
        shareStr.append("  bizdate=$1\n");
        shareStr.append("else\n");
        shareStr.append("  bizdate=`date -d last-day +%Y%m%d`\n");
        shareStr.append("fi\n");
        shareStr.append("\n");
        StringBuffer writeJobParaStr = new StringBuffer();
        writeJobParaStr.append("if [ ! -f \"" + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE\" ];\n");
        writeJobParaStr.append("then\n");
        writeJobParaStr.append("echo $parameter_key:$parameter_value > " + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE\n");
        writeJobParaStr.append("else\n");
        writeJobParaStr.append("##\u5224\u65ad\u6587\u4ef6\u4e2d\u662f\u5426\u5b58\u5728key\n");
        writeJobParaStr.append("result=`grep \"\\<$parameter_key\\>:\" " + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE`\n");
        writeJobParaStr.append("if [ -z \"$result\" ];\n");
        writeJobParaStr.append("then\n");
        writeJobParaStr.append("sed -i \"\\$a $parameter_key:$parameter_value\" " + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE\n");
        writeJobParaStr.append("else\n");
        writeJobParaStr.append("value=${result#*:}\n");
        writeJobParaStr.append("sed -i \"s/^$parameter_key:$value/$parameter_key:$parameter_value/g\" " + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE\n");
        writeJobParaStr.append("fi\n");
        writeJobParaStr.append("fi\n");
        StringBuffer readJobParaStr = new StringBuffer();
        readJobParaStr.append("if [ -f \"" + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE\" ];\n");
        readJobParaStr.append("then\n");
        readJobParaStr.append("result=`grep \"\\<$parameter_key\\>:\" " + this.azkabanShellHome + "/../JOB_OUTPUT_PROP_FILE`\n");
        readJobParaStr.append("value=${result#*:}\n");
        readJobParaStr.append("if [ -n \"$value\" ];then\n");
        readJobParaStr.append("echo \"$parameter_key:$value\"\n");
        readJobParaStr.append("else\n");
        readJobParaStr.append("echo '\u6ca1\u6709\u5f53\u524d\u53c2\u6570\uff0c\u6216\u8005\u5f53\u524d\u53c2\u6570\u65e0\u6548'\n");
        readJobParaStr.append("fi\n");
        readJobParaStr.append("else\n");
        readJobParaStr.append("echo \"\u76ee\u6807\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\"\n");
        readJobParaStr.append("fi\n");
        StringBuffer shellStr = new StringBuffer();
        shellStr.append(shareStr);
        shellStr.append("hive -hivevar  bizdate=$bizdate   -f " + this.hiveSqlHome + "/" + importFileReqBO.getTableName() + "_DDL.sql\n");
        GetFileStringBufferBO fileStringBufferBO = new GetFileStringBufferBO();
        fileStringBufferBO.setBizType("ddl");
        fileStringBufferBO.setFileName(importFileReqBO.getTableName() + "_DDL.sh");
        fileStringBufferBO.setFileContent(shellStr);
        shellList.add(fileStringBufferBO);
        shellStr = new StringBuffer();
        shellStr.append(shareStr);
        shellStr.append("#\u5199\u5f00\u59cb\u65f6\u95f4\n");
        shellStr.append("parameter_key=" + importFileReqBO.getTableName() + ".p_start_time\n");
        shellStr.append("parameter_value=`date \"+%Y-%m-%d %H:%M:%S\"`\n");
        shellStr.append(writeJobParaStr);
        shellStr.append("#\u6267\u884cDataX\u811a\u672c\n");
        shellStr.append("python " + this.dataxBinHome + "/datax.py  -p\"-Ddt=$bizdate -Dwhere='1=1'\" " + this.dataxJsonHome + "/" + importFileReqBO.getTableName() + "_sync.json \n");
        shellStr.append("#\u5199\u7ed3\u675f\u65f6\u95f4\n");
        shellStr.append("parameter_key=" + importFileReqBO.getTableName() + ".p_end_time\n");
        shellStr.append("parameter_value=`date \"+%Y-%m-%d %H:%M:%S\"`\n");
        shellStr.append(writeJobParaStr);
        fileStringBufferBO = new GetFileStringBufferBO();
        fileStringBufferBO.setBizType("sync");
        fileStringBufferBO.setFileName(importFileReqBO.getTableName() + "_sync.sh");
        fileStringBufferBO.setFileContent(shellStr);
        shellList.add(fileStringBufferBO);
        shellStr = new StringBuffer();
        shellStr.append(shareStr);
        shellStr.append("if [ $2 ]\n");
        shellStr.append("then\n");
        shellStr.append("  beforebizdate=$2\n");
        shellStr.append("else\n");
        shellStr.append("  beforebizdate=`date -d \"2 days ago\" +%Y%m%d`\n");
        shellStr.append("fi\n");
        shellStr.append("hive -hivevar  bizdate=$bizdate -hivevar  beforebizdate=$beforebizdate -f " + this.hiveSqlHome + "/" + importFileReqBO.getTableName() + "_ad.sql \n");
        fileStringBufferBO = new GetFileStringBufferBO();
        fileStringBufferBO.setBizType("ad");
        fileStringBufferBO.setFileName(importFileReqBO.getTableName() + "_ad.sh");
        fileStringBufferBO.setFileContent(shellStr);
        shellList.add(fileStringBufferBO);
        shellStr = new StringBuffer();
        shellStr.append(shareStr);
        shellStr.append("##\u8bfb\u53d6\u6587\u4ef6\u914d\u7f6e\u7684\u53c2\u6570\n");
        shellStr.append("parameter_key=" + importFileReqBO.getTableName() + ".p_start_time\n");
        shellStr.append(readJobParaStr);
        shellStr.append("p_start_time=$value\n");
        shellStr.append("parameter_key=" + importFileReqBO.getTableName() + ".p_end_time\n");
        shellStr.append(readJobParaStr);
        shellStr.append("p_end_time=$value\n");
        shellStr.append("hive -hivevar  p_start_time=$p_start_time -hivevar  p_end_time=$p_end_time -hivevar bdp.system.bizdate=$bizdate -f " + this.hiveSqlHome + "/" + importFileReqBO.getTableName() + "_sum.sql \n");
        fileStringBufferBO = new GetFileStringBufferBO();
        fileStringBufferBO.setBizType("sum");
        fileStringBufferBO.setFileName(importFileReqBO.getTableName() + "_sum.sh");
        fileStringBufferBO.setFileContent(shellStr);
        shellList.add(fileStringBufferBO);
        return shellList;
    }
}

