/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanUploadZipReqBO;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanUploadZipRspBO;
import com.yqsmartcity.data.swap.api.azkaban.service.AzkabanLoginService;
import com.yqsmartcity.data.swap.api.azkaban.service.UploadJobZipService;
import com.yqsmartcity.data.swap.api.azkaban.service.UploadZipToAzkabanService;
import com.yqsmartcity.data.swap.api.bo.RemoteConnectBO;
import com.yqsmartcity.data.swap.constant.ConnectLinuxCommand;
import com.yqsmartcity.data.swap.dao.TaskPublishFileMapper;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.service.busi.impl.dataworks.FileZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UploadZipToAzkabanServiceImpl
implements UploadZipToAzkabanService {
    private static final Logger log = LoggerFactory.getLogger(UploadZipToAzkabanServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(UploadZipToAzkabanServiceImpl.class);
    @Autowired
    AzkabanLoginService azkabanLogin;
    @Autowired
    UploadJobZipService uploadJobZipService;
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskPublishFileMapper taskPublishFileMapper;

    public AzkabanUploadZipRspBO uploadZipToAzkaban(AzkabanUploadZipReqBO reqBO) throws ZTBusinessException {
        AzkabanUploadZipRspBO rspBO = new AzkabanUploadZipRspBO();
        return rspBO;
    }

    private static String zipFile(String filePath) throws ZTBusinessException {
        File zipFile = new File(filePath + ".zip");
        try {
            FileOutputStream fos1 = new FileOutputStream(zipFile);
            FileZipUtil.toZip(new File(filePath), fos1, false);
        }
        catch (FileNotFoundException e) {
            throw new ZTBusinessException(e.getLocalizedMessage());
        }
        return zipFile.getName();
    }

    private static void scpPutJson(String ip, int port, String userName, String password, String fileType, List<String> listFile, String remoteDir, String loginType, String loginRsaPath) throws ZTBusinessException {
        RemoteConnectBO remoteConnect = new RemoteConnectBO();
        remoteConnect.setIp(ip);
        remoteConnect.setPort(port);
        remoteConnect.setUserName(userName);
        remoteConnect.setPassword(password);
        try {
            Object keyFile;
            if ("key".equals(loginType) ? ConnectLinuxCommand.loginByFileKey(remoteConnect, (File)(keyFile = new File(loginRsaPath)), null) == false : "password".equals(loginType) && ConnectLinuxCommand.login(remoteConnect) == false) {
                throw new ZTBusinessException("\u767b\u9646\u4e3b\u673a" + ip + "\u5931\u8d25");
            }
            for (String fileName : listFile) {
                ConnectLinuxCommand.scpPut("azkaban_conf_file/" + fileType + "_file/" + fileName, remoteDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u81f3\u670d\u52a1\u5668\u5931\u8d25\uff01");
        }
        finally {
            ConnectLinuxCommand.logOut();
        }
    }

    private void validateParam(AzkabanUploadZipReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getUnidList())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u540d\u5217\u8868\u3010unidList\u3011\u4e3a\u7a7a");
        }
    }
}

