/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.base;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.dao.OperLogDao;
import com.yqsmartcity.data.swap.dao.SysParaDao;
import com.yqsmartcity.data.swap.po.OperLogPO;
import com.yqsmartcity.data.swap.po.SysParaPO;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SwapInsertOperLogServiceImpl
implements SwapInsertOperLogService {
    private static final Logger log = LoggerFactory.getLogger(SwapInsertOperLogServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapInsertOperLogServiceImpl.class);
    @Autowired
    private OperLogDao operLogDao;
    @Autowired
    private SysParaDao sysParaDao;

    public SwapInsertOperLogRspBO insertOperLog(SwapInsertOperLogReqBO reqBO) throws ZTBusinessException {
        int insert;
        logger.info("\u65e5\u5fd7\u5165\u53c2\u4fe1\u606f" + reqBO.toString());
        this.validateArg(reqBO);
        SwapInsertOperLogRspBO rspBO = new SwapInsertOperLogRspBO();
        OperLogPO operLogPO = new OperLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)operLogPO);
        if (null != reqBO.getUserId()) {
            operLogPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        if (null != reqBO.getOrgId()) {
            operLogPO.setOperDeptNo(String.valueOf(reqBO.getOrgId()));
        }
        operLogPO.setOperName(reqBO.getName());
        operLogPO.setOperDeptName(reqBO.getOrgName());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getRequestDate())) {
            operLogPO.setRequestDate(SwapInsertOperLogServiceImpl.strToDate(reqBO.getRequestDate(), "yyyy-MM-dd HH:mm:ss"));
        }
        operLogPO.setResponseDate(new Date());
        SysParaPO qrySysParaPO = new SysParaPO();
        qrySysParaPO.setParaType("OPER_MODE_TYPE");
        qrySysParaPO.setParaName(reqBO.getOperMode());
        SysParaPO sysParaPO = this.sysParaDao.getModelBy(qrySysParaPO);
        if (null != sysParaPO) {
            operLogPO.setOperMode(sysParaPO.getParaCode());
        }
        if ((insert = this.operLogDao.insert(operLogPO)) < 1) {
            rspBO.setCode("1");
            rspBO.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setCode("0");
        rspBO.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u6210\u529f\uff01");
        return rspBO;
    }

    private void validateArg(SwapInsertOperLogReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperMode())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u6a21\u5757[OperMode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static Date strToDateyyyyMMddHHmmss(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date strToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }
}

