/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.pflm.modules.job.dao.ScheduleJobMapper;
import com.pflm.modules.job.entity.ScheduleJobEntity;
import com.pflm.modules.job.service.ScheduleJobService;
import com.yqsmartcity.data.ref.ability.bo.RefRspBaseAbilityBO;
import com.yqsmartcity.data.swap.api.collect.bo.BatchEditCollectionTaskReqBO;
import com.yqsmartcity.data.swap.api.collect.service.BatchEditCollectionTaskService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadReqBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OoziePublishReqBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateOozieConfFileService;
import com.yqsmartcity.data.swap.api.oozie.service.PublishToOozieService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.dao.TaskPublishFileMapper;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import com.yqsmartcity.data.swap.po.TaskPublishFilePO;
import com.yqsmartcity.data.swap.po.TaskPublishPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BatchEditCollectionTaskServiceImpl
extends ServiceImpl<ScheduleJobMapper, ScheduleJobEntity>
implements BatchEditCollectionTaskService {
    private static final Logger log = LoggerFactory.getLogger(BatchEditCollectionTaskServiceImpl.class);
    @Value(value="${oozie.hdfs.path}")
    private String oozieHdfsPath;
    @Value(value="${oozie.url}")
    private String oozieUrl;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskPublishFileMapper taskPublishFileMapper;
    @Autowired
    private ScheduleJobMapper scheduleJobMapper;
    @Autowired
    private ScheduleJobService scheduleJobService;
    @Autowired
    private CreateOozieConfFileService createOozieConfFileService;
    @Autowired
    private PublishToOozieService publishToOozieService;

    public void batchEditCollectionTaskTest(BatchEditCollectionTaskReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        List<TaskInfoPO> taskInfoPOList = this.taskInfoDao.getListByUnids(reqBO.getUnidList());
        for (TaskInfoPO taskInfoPO : taskInfoPOList) {
            if ("1".equalsIgnoreCase(reqBO.getOperation())) {
                if ("2".equalsIgnoreCase(taskInfoPO.getStatus()) || "4".equalsIgnoreCase(taskInfoPO.getStatus())) continue;
                throw new ZTBusinessException("\u53ea\u6709\u672a\u53d1\u5e03\u6216\u8005\u53d1\u5e03\u5931\u8d25\u7684\u4efb\u52a1\u53ef\u4ee5\u53d1\u5e03\uff01");
            }
            if ("3".equalsIgnoreCase(taskInfoPO.getStatus()) || "4".equalsIgnoreCase(taskInfoPO.getStatus())) continue;
            throw new ZTBusinessException("\u53ea\u6709\u5df2\u53d1\u5e03\u6216\u8005\u53d1\u5e03\u5931\u8d25\u7684\u4efb\u52a1\u53ef\u4ee5\u53d6\u6d88\u53d1\u5e03\uff01");
        }
        long[] array = reqBO.getUnidList().stream().mapToLong(t -> t).toArray();
        ArrayList<String> tableNameList = new ArrayList<String>();
        if ("1".equalsIgnoreCase(reqBO.getOperation())) {
            for (TaskInfoPO taskInfoPO : taskInfoPOList) {
                TableInfoPO tableInfoPO = new TableInfoPO();
                tableInfoPO.setTaskId(taskInfoPO.getTaskId());
                TableInfoPO tableInfoPOQry = this.tableInfoDao.getModelBy(tableInfoPO);
                tableNameList.add(tableInfoPOQry.getDatabaseTable());
            }
            ScriptDownloadReqBO scriptDownloadReqBO = new ScriptDownloadReqBO();
            scriptDownloadReqBO.setTableNameList(tableNameList);
            List createImportFileRspBOList = this.createOozieConfFileService.createOozieConf(scriptDownloadReqBO);
            Date sysDate = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            String dateString = format.format(sysDate);
            ArrayList<TaskPublishFilePO> record = new ArrayList<TaskPublishFilePO>();
            ArrayList<Long> unidList = new ArrayList<Long>();
            for (CreateImportFileRspBO createImportFileRspBOFor : createImportFileRspBOList) {
                TaskPublishPO taskPublishPO = new TaskPublishPO();
                taskPublishPO.setTaskId(createImportFileRspBOFor.getTaskId());
                taskPublishPO.setPublishName(createImportFileRspBOFor.getTableName());
                taskPublishPO.setNodeType(scriptDownloadReqBO.getExpressionSuitDb());
                taskPublishPO.setStatus("1");
                taskPublishPO.setOperName(scriptDownloadReqBO.getName());
                taskPublishPO.setCreateTime(new Date());
                if (null != scriptDownloadReqBO.getUserId()) {
                    taskPublishPO.setOperId(String.valueOf(scriptDownloadReqBO.getUserId()));
                }
                this.taskPublishMapper.insert(taskPublishPO);
                unidList.add(taskPublishPO.getUnid());
                TableInfoPO tableInfoPO = new TableInfoPO();
                tableInfoPO.setDatabaseTable(createImportFileRspBOFor.getTableName());
                tableInfoPO.setStatus("2");
                TableInfoPO result = this.tableInfoDao.getModelBy(tableInfoPO);
                for (CreateImportFileBO createImportFileBOFor : createImportFileRspBOFor.getReateImportFileBO()) {
                    TaskPublishFilePO taskPublishFilePO = new TaskPublishFilePO();
                    taskPublishFilePO.setPublishId(taskPublishPO.getUnid().toString());
                    taskPublishFilePO.setDatabaseTableId(result.getDatabaseTableId());
                    taskPublishFilePO.setFileType(createImportFileBOFor.getFileType());
                    taskPublishFilePO.setFilePath(this.oozieHdfsPath + "/" + "TP001" + "-workflow/" + createImportFileBOFor.getWorkFlowName());
                    taskPublishFilePO.setFileName(createImportFileBOFor.getFileName());
                    taskPublishFilePO.setFileContent(createImportFileBOFor.getFileContent().toString());
                    taskPublishFilePO.setCreateTime(new Date());
                    if (null != scriptDownloadReqBO.getUserId()) {
                        taskPublishFilePO.setOperId(String.valueOf(scriptDownloadReqBO.getUserId()));
                    }
                    taskPublishFilePO.setOperName(scriptDownloadReqBO.getName());
                    record.add(taskPublishFilePO);
                }
                this.taskPublishFileMapper.insertBatch(record);
            }
            OoziePublishReqBO ooziePublishReqBO = new OoziePublishReqBO();
            ooziePublishReqBO.setUnidList(unidList);
            this.publishToOozieService.publishOozie(ooziePublishReqBO);
            this.taskInfoDao.batchUpdateState3(array);
        } else {
            for (TaskInfoPO taskInfoPO : taskInfoPOList) {
                TaskPublishPO taskPublishPO = new TaskPublishPO();
                taskPublishPO.setTaskId(taskInfoPO.getTaskId());
                taskPublishPO.setStatusList("2,3".split(","));
                List<TaskPublishPO> taskPublishPOList = this.taskPublishMapper.getCheckByTaskId(taskPublishPO);
                for (TaskPublishPO taskPublishPOFor : taskPublishPOList) {
                    if (StringUtils.isEmpty((CharSequence)taskPublishPOFor.getJobId())) continue;
                    OozieClient wc = new OozieClient(this.oozieUrl);
                    try {
                        wc.kill(taskPublishPOFor.getJobId());
                    }
                    catch (OozieClientException e) {
                        e.printStackTrace();
                        throw new ZTBusinessException("\u4efb\u52a1\u4e0b\u7ebf\u5931\u8d25\uff01\u3010" + e.getLocalizedMessage() + "\u3011");
                    }
                    TaskPublishPO taskPublishPO1 = new TaskPublishPO();
                    taskPublishPO1.setUnid(taskPublishPOFor.getUnid());
                    taskPublishPO1.setStatus("0");
                    if (null != reqBO.getUserId()) {
                        taskPublishPO1.setPublishOperId(String.valueOf(reqBO.getUserId()));
                    }
                    taskPublishPO1.setPublishOperName(reqBO.getName());
                    this.taskPublishMapper.updateByPrimaryKeySelective(taskPublishPO1);
                }
            }
            this.taskInfoDao.batchUpdateState2(array);
        }
    }

    public RefRspBaseAbilityBO batchEditCollectionTask(BatchEditCollectionTaskReqBO reqBO) {
        RefRspBaseAbilityBO rspBO = new RefRspBaseAbilityBO();
        if (reqBO.getUnidList().size() > 0) {
            for (Long aLong : reqBO.getUnidList()) {
                TaskInfoPO taskInfoPO = this.taskInfoDao.getModelById(aLong);
                if (taskInfoPO != null) {
                    ScheduleJobEntity scheduleJobEntity = this.scheduleJobMapper.queryByParams(taskInfoPO.getTaskId());
                    if (scheduleJobEntity != null) {
                        if (!"2".equals(taskInfoPO.getStatus()) && !"3".equals(taskInfoPO.getStatus())) continue;
                        if ("2".equals(reqBO.getOperation())) {
                            if (scheduleJobEntity.getStatus() == 0) {
                                scheduleJobEntity.setStatus(Integer.valueOf(1));
                                this.scheduleJobService.saveScheduleJob(scheduleJobEntity);
                                taskInfoPO.setStatus("2");
                                taskInfoPO.setUpdateTime(new Date());
                                this.taskInfoDao.updateById(taskInfoPO);
                                continue;
                            }
                            throw new ZTBusinessException("unid\u4e3a:" + aLong + "*****\u6b64\u4efb\u52a1\u5df2\u7ecf\u88ab\u6682\u505c\u6216\u72b6\u6001\u5f02\u5e38");
                        }
                        if ("1".equals(reqBO.getOperation())) {
                            if (scheduleJobEntity.getStatus() == 1) {
                                scheduleJobEntity.setStatus(Integer.valueOf(0));
                                this.scheduleJobService.saveScheduleJob(scheduleJobEntity);
                                taskInfoPO.setStatus("3");
                                taskInfoPO.setUpdateTime(new Date());
                                this.taskInfoDao.updateById(taskInfoPO);
                                continue;
                            }
                            throw new ZTBusinessException("unid\u4e3a:" + aLong + "*****\u6b64\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d1\u5e03\u6216\u72b6\u6001\u5f02\u5e38");
                        }
                        throw new ZTBusinessException("unid\u4e3a:" + aLong + "*****\u64cd\u4f5c\u5f02\u5e38");
                    }
                    throw new ZTBusinessException("unid\u4e3a:" + aLong + "*****\u8be5\u4efb\u52a1\u672a\u914d\u7f6e\u6216\u5f02\u5e38");
                }
                throw new ZTBusinessException("unid\u4e3a:" + aLong + "*****\u8be5\u4efb\u52a1\u672a\u914d\u7f6e\u6216\u5f02\u5e38");
            }
        } else {
            throw new ZTBusinessException("\u64cd\u4f5c\u5f02\u5e38");
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void validateParam(BatchEditCollectionTaskReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getUnidList())) {
            throw new ZTBusinessException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperation())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

