/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.ref.ability.RfCollectDataTaskService;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskRspBO;
import com.yqsmartcity.data.swap.api.collect.bo.EditCollectionRuleConfigReqBO;
import com.yqsmartcity.data.swap.api.collect.service.EditCollectionRuleConfigService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EditCollectionRuleConfigServiceImpl
implements EditCollectionRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(EditCollectionRuleConfigServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private RfCollectDataTaskService rfCollectDataTaskService;

    @Transactional(rollbackFor={Exception.class})
    public void editCollectionRuleConfig(EditCollectionRuleConfigReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TableInfoPO tableInfoPO = this.tableInfoDao.getModelById(reqBO.getUnid());
        if (null == tableInfoPO) {
            throw new ZTBusinessException("\u672a\u67e5\u5230\u8be5\u6761\u5f52\u96c6\u89c4\u5219\u914d\u7f6e\u6570\u636e");
        }
        TaskInfoPO qryTaskInfoPO = new TaskInfoPO();
        qryTaskInfoPO.setTaskId(tableInfoPO.getTaskId());
        TaskInfoPO taskInfoPO = this.taskInfoDao.getModelBy(qryTaskInfoPO);
        TaskInfoPO updateTaskInfoPO = new TaskInfoPO();
        updateTaskInfoPO.setUnid(taskInfoPO.getUnid());
        updateTaskInfoPO.setNeedDesc(reqBO.getNeedDesc());
        updateTaskInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            updateTaskInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        updateTaskInfoPO.setOperName(reqBO.getName());
        int resultUpdateTaskInfo = this.taskInfoDao.updateById(updateTaskInfoPO);
        if (resultUpdateTaskInfo < 1) {
            throw new ZTBusinessException("\u7f16\u8f91\u5931\u8d25");
        }
        TableInfoPO updateTableInfoPO = new TableInfoPO();
        updateTableInfoPO.setUnid(reqBO.getUnid());
        updateTableInfoPO.setSwapMode("");
        updateTableInfoPO.setQueryWhere("");
        updateTableInfoPO.setPartionMode("");
        updateTableInfoPO.setPartionWhere("");
        this.tableInfoDao.updateById(updateTableInfoPO);
        updateTableInfoPO.setSwapMode(reqBO.getSwapMode());
        updateTableInfoPO.setQueryWhere(reqBO.getQueryWhere());
        updateTableInfoPO.setPartionMode(reqBO.getPartionMode());
        updateTableInfoPO.setPartionWhere(reqBO.getPartionWhere());
        updateTableInfoPO.setStatus(reqBO.getOperation());
        updateTableInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            updateTableInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        updateTableInfoPO.setOperName(reqBO.getName());
        int reslt = this.tableInfoDao.updateById(updateTableInfoPO);
        if (reslt < 1) {
            throw new ZTBusinessException("\u7f16\u8f91\u5931\u8d25");
        }
        try {
            RfCollectDataTaskReqBO selectRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
            selectRfCollectDataTaskReqBO.setCollectTaskCode(taskInfoPO.getTaskId());
            RfCollectDataTaskRspBO rfCollectDataTaskRspBO = this.rfCollectDataTaskService.queryRfCollectDataTaskSingle(selectRfCollectDataTaskReqBO);
            RfCollectDataTaskReqBO insertRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
            insertRfCollectDataTaskReqBO.setId(rfCollectDataTaskRspBO.getData().getId());
            if ("1".equals(reqBO.getOperation())) {
                insertRfCollectDataTaskReqBO.setStatus("SUSPEND");
            } else if ("2".equals(reqBO.getOperation())) {
                insertRfCollectDataTaskReqBO.setStatus("COLLECT");
            }
            this.rfCollectDataTaskService.saveRfCollectDataTask(insertRfCollectDataTaskReqBO);
        }
        catch (Exception e) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u62a5\u8868\u62bd\u53d6\u4efb\u52a1\u89c4\u5219");
        }
    }

    private void validateParam(EditCollectionRuleConfigReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010unid\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSwapMode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5f52\u96c6\u65b9\u5f0f\u3010swapMode\u3011\u4e3a\u7a7a");
        }
        if ("add".equals(reqBO.getSwapMode()) && StringUtils.isEmpty((String)reqBO.getQueryWhere())) {
            throw new ZTBusinessException("\u5f52\u96c6\u65b9\u5f0f\u4e3a\u589e\u91cf\u65f6\u589e\u91cf\u6761\u4ef6\u3010queryWhere\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getPartionMode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5206\u533a\u65b9\u5f0f\u3010partionMode\u3011\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getPartionMode()) && StringUtils.isEmpty((String)reqBO.getPartionWhere())) {
            throw new ZTBusinessException("\u5206\u533a\u65b9\u5f0f\u4e3a\u5206\u533a\u8868\u65f6\u5206\u533a\u6761\u4ef6\u3010paartionWhere\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getOperation())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u7c7b\u578b\u3010operation\u3011\u4e3a\u7a7a");
        }
    }
}

