/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.pflm.modules.job.dao.ScheduleJobMapper;
import com.pflm.modules.job.entity.ScheduleJobEntity;
import com.pflm.modules.job.service.ScheduleJobService;
import com.yqsmartcity.data.ref.ability.bo.RefRspBaseAbilityBO;
import com.yqsmartcity.data.swap.api.collect.bo.EditCollectionTaskReqBO;
import com.yqsmartcity.data.swap.api.collect.service.EditCollectionTaskService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadReqBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OoziePublishReqBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateOozieConfFileService;
import com.yqsmartcity.data.swap.api.oozie.service.PublishToOozieService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.dao.TaskPublishFileMapper;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import com.yqsmartcity.data.swap.po.TaskPublishFilePO;
import com.yqsmartcity.data.swap.po.TaskPublishPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EditCollectionTaskServiceImpl
extends ServiceImpl<ScheduleJobMapper, ScheduleJobEntity>
implements EditCollectionTaskService {
    private static final Logger log = LoggerFactory.getLogger(EditCollectionTaskServiceImpl.class);
    @Value(value="${oozie.hdfs.path}")
    private String oozieHdfsPath;
    @Value(value="${oozie.url}")
    private String oozieUrl;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskPublishFileMapper taskPublishFileMapper;
    @Autowired
    private ScheduleJobService scheduleJobService;
    @Autowired
    private CreateOozieConfFileService createOozieConfFileService;
    @Autowired
    private PublishToOozieService publishToOozieService;

    public void editCollectionTaskTest(EditCollectionTaskReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TaskInfoPO taskInfoPO = new TaskInfoPO();
        taskInfoPO.setUnid(reqBO.getUnid());
        taskInfoPO.setSwapCycle(reqBO.getSwapCycle());
        taskInfoPO.setSwapFreq(reqBO.getCrontabExpression());
        taskInfoPO.setOverTime(reqBO.getOverTime());
        taskInfoPO.setStatus("1".equalsIgnoreCase(reqBO.getOperation()) ? "2" : "3");
        taskInfoPO.setRemark(reqBO.getRemark());
        taskInfoPO.setCreateTime(new Date());
        taskInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            taskInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        taskInfoPO.setOperName(reqBO.getName());
        this.taskInfoDao.updateById(taskInfoPO);
        TaskInfoPO TaskInfoPOQry = this.taskInfoDao.getModelById(reqBO.getUnid());
        ArrayList<String> tableNameList = new ArrayList<String>();
        if ("2".equalsIgnoreCase(reqBO.getOperation())) {
            TableInfoPO tableInfoPO = new TableInfoPO();
            tableInfoPO.setTaskId(TaskInfoPOQry.getTaskId());
            TableInfoPO tableInfoPOQry = this.tableInfoDao.getModelBy(tableInfoPO);
            tableNameList.add(tableInfoPOQry.getDatabaseTable());
            ScriptDownloadReqBO scriptDownloadReqBO = new ScriptDownloadReqBO();
            scriptDownloadReqBO.setTableNameList(tableNameList);
            List createImportFileRspBOList = this.createOozieConfFileService.createOozieConf(scriptDownloadReqBO);
            Date sysDate = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            String dateString = format.format(sysDate);
            ArrayList<TaskPublishFilePO> record = new ArrayList<TaskPublishFilePO>();
            ArrayList<Long> unidList = new ArrayList<Long>();
            for (CreateImportFileRspBO createImportFileRspBOFor : createImportFileRspBOList) {
                TaskPublishPO taskPublishPO = new TaskPublishPO();
                taskPublishPO.setTaskId(createImportFileRspBOFor.getTaskId());
                taskPublishPO.setPublishName(createImportFileRspBOFor.getTableName());
                taskPublishPO.setNodeType(scriptDownloadReqBO.getExpressionSuitDb());
                taskPublishPO.setStatus("1");
                taskPublishPO.setOperName(scriptDownloadReqBO.getName());
                taskPublishPO.setCreateTime(new Date());
                if (null != scriptDownloadReqBO.getUserId()) {
                    taskPublishPO.setOperId(String.valueOf(scriptDownloadReqBO.getUserId()));
                }
                this.taskPublishMapper.insert(taskPublishPO);
                unidList.add(taskPublishPO.getUnid());
                for (CreateImportFileBO createImportFileBOFor : createImportFileRspBOFor.getReateImportFileBO()) {
                    TaskPublishFilePO taskPublishFilePO = new TaskPublishFilePO();
                    taskPublishFilePO.setPublishId(taskPublishPO.getUnid().toString());
                    taskPublishFilePO.setDatabaseTableId(tableInfoPOQry.getDatabaseTableId());
                    taskPublishFilePO.setFileType(createImportFileBOFor.getFileType());
                    taskPublishFilePO.setFilePath(this.oozieHdfsPath + "/" + "TP001" + "-workflow/" + createImportFileBOFor.getWorkFlowName());
                    taskPublishFilePO.setFileName(createImportFileBOFor.getFileName());
                    taskPublishFilePO.setFileContent(createImportFileBOFor.getFileContent().toString());
                    taskPublishFilePO.setCreateTime(new Date());
                    if (null != scriptDownloadReqBO.getUserId()) {
                        taskPublishFilePO.setOperId(String.valueOf(scriptDownloadReqBO.getUserId()));
                    }
                    taskPublishFilePO.setOperName(scriptDownloadReqBO.getName());
                    record.add(taskPublishFilePO);
                }
                this.taskPublishFileMapper.insertBatch(record);
            }
            OoziePublishReqBO ooziePublishReqBO = new OoziePublishReqBO();
            ooziePublishReqBO.setUnidList(unidList);
            this.publishToOozieService.publishOozie(ooziePublishReqBO);
        } else {
            TaskPublishPO updateTaskPublishPO = new TaskPublishPO();
            updateTaskPublishPO.setTaskId(TaskInfoPOQry.getTaskId());
            updateTaskPublishPO.setStatus("4");
            this.taskPublishMapper.updateByTaskIdSelective(updateTaskPublishPO);
        }
    }

    public RefRspBaseAbilityBO editCollectionTask(EditCollectionTaskReqBO reqBO) {
        RefRspBaseAbilityBO rspBO = new RefRspBaseAbilityBO();
        ScheduleJobEntity scheduleJobEntity = new ScheduleJobEntity();
        TaskInfoPO taskInfoPO = this.taskInfoDao.getModelById(reqBO.getUnid());
        taskInfoPO.setSwapCycle(reqBO.getSwapCycle());
        taskInfoPO.setSwapFreq(reqBO.getCrontabExpression());
        taskInfoPO.setOverTime(reqBO.getOverTime());
        taskInfoPO.setRemark(reqBO.getRemark());
        taskInfoPO.setUpdateTime(new Date());
        if ("2".equals(reqBO.getOperation())) {
            taskInfoPO.setStatus("3");
            scheduleJobEntity.setStatus(Integer.valueOf(0));
        } else if ("1".equals(reqBO.getOperation())) {
            taskInfoPO.setStatus("2");
            scheduleJobEntity.setStatus(Integer.valueOf(1));
        }
        scheduleJobEntity.setBeanName("scheduleCollect");
        scheduleJobEntity.setMethodName("execute");
        scheduleJobEntity.setParams(taskInfoPO.getTaskId());
        scheduleJobEntity.setCronExpression(taskInfoPO.getSwapFreq());
        scheduleJobEntity.setRemark(taskInfoPO.getRemark());
        scheduleJobEntity.setCreateTime(new Date());
        this.scheduleJobService.saveScheduleJob(scheduleJobEntity);
        this.taskInfoDao.updateById(taskInfoPO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void validateParam(EditCollectionTaskReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperation())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSwapCycle())) {
            throw new ZTBusinessException("\u8c03\u5ea6\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCrontabExpression())) {
            throw new ZTBusinessException("crontab\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOverTime()) {
            throw new ZTBusinessException("\u8d85\u65f6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

