/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.dataX;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataX.bo.DataXRWHDFSBO;
import com.yqsmartcity.data.swap.api.dataX.bo.DataXRWMysqlBO;
import com.yqsmartcity.data.swap.api.dataX.service.SwapGetDataXJsonConfService;
import com.yqsmartcity.data.swap.dao.SysParaDao;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareSubscribeReqBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.ExternalColumnBO;
import com.yqsmartcity.data.swap.po.SysParaPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SwapGetDataXJsonConfServiceImpl
implements SwapGetDataXJsonConfService {
    private static final Logger log = LoggerFactory.getLogger(SwapGetDataXJsonConfServiceImpl.class);
    @Value(value="${share.db.public-key}")
    private String publicKeyText;
    @Autowired
    private SysParaDao sysParaDao;

    public StringBuffer getDataXJson(DataShareSubscribeReqBO reqBO) throws ZTBusinessException {
        SysParaPO sysParaPO = new SysParaPO();
        sysParaPO.setParaType("DATAX_DATA_TYPE_HIVE");
        sysParaPO.setStatus("1");
        sysParaPO.setOrderBy("sort");
        List<SysParaPO> sysParaPOList = this.sysParaDao.getList(sysParaPO);
        Map<String, String> dataXDataType = sysParaPOList.stream().collect(Collectors.toMap(SysParaPO::getParaCode, SysParaPO::getParaName));
        DataXRWMysqlBO dataXRWMysqlBO = new DataXRWMysqlBO();
        dataXRWMysqlBO.setReaderUserName(reqBO.getSourceDataSourceInfo().getDbUserName());
        try {
            dataXRWMysqlBO.setReaderPassword(reqBO.getSourceDataSourceInfo().getDbPasswd());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u6e90\u6570\u636e\u5e93\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        dataXRWMysqlBO.setReaderTableName(reqBO.getSourceDbTableName());
        dataXRWMysqlBO.setReaderColumn(SwapGetDataXJsonConfServiceImpl.getTableCol(reqBO.getSourceDbColumnBo(), reqBO.getSourceDataSourceInfo().getDbType(), dataXDataType, "reader"));
        dataXRWMysqlBO.setReaderQuerySql(reqBO.getSourceDbQuerySql());
        JSONObject readerJSON = null;
        if ("MS".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("" + reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            dataXRWMysqlBO.setName("mysqlreader");
            dataXRWMysqlBO.setReaderQuerySql(reqBO.getSourceDbQuerySql());
            readerJSON = SwapGetDataXJsonConfServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("OR".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("" + reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            dataXRWMysqlBO.setName("oraclereader");
            readerJSON = SwapGetDataXJsonConfServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("SS".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("" + reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            dataXRWMysqlBO.setName("sqlserverreader");
            readerJSON = SwapGetDataXJsonConfServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("HIVE".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("hdfsreader");
            DataXRWHDFSBO dataXRWHDFSBO = new DataXRWHDFSBO();
            BeanUtils.copyProperties((Object)dataXRWMysqlBO, (Object)dataXRWHDFSBO);
            dataXRWHDFSBO.setDefaultFS("" + reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            dataXRWHDFSBO.setPath(reqBO.getSourceDbPath());
            readerJSON = SwapGetDataXJsonConfServiceImpl.hdfsReader(dataXRWHDFSBO);
        } else if ("DM".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("" + reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            dataXRWMysqlBO.setName("rdbmsreader");
            readerJSON = SwapGetDataXJsonConfServiceImpl.rdbmsReader(dataXRWMysqlBO);
        } else {
            throw new ZTBusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u7684\u8bfb\u53d6\uff01");
        }
        JSONObject writerJSON = null;
        dataXRWMysqlBO.setWriterUserName(reqBO.getTargetDataSourceInfo().getDbUserName());
        try {
            dataXRWMysqlBO.setWriterPassword(reqBO.getTargetDataSourceInfo().getDbPasswd());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u76ee\u6807\u6570\u636e\u5e93\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        dataXRWMysqlBO.setWriterTableName(reqBO.getTargetDbTableName());
        dataXRWMysqlBO.setWriterColumn(SwapGetDataXJsonConfServiceImpl.getTableCol(reqBO.getTargetDbColumnBO(), reqBO.getTargetDataSourceInfo().getDbType(), dataXDataType, "writer"));
        if ("MS".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setWriterJdbcUrl("" + reqBO.getTargetDataSourceInfo().getDbJDBCUrl());
            dataXRWMysqlBO.setName("mysqlwriter");
            writerJSON = SwapGetDataXJsonConfServiceImpl.mysqlWriter(dataXRWMysqlBO);
        } else if ("HIVE".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("hdfswriter");
            DataXRWHDFSBO dataXRWHDFSBO = new DataXRWHDFSBO();
            BeanUtils.copyProperties((Object)dataXRWMysqlBO, (Object)dataXRWHDFSBO);
            dataXRWHDFSBO.setDefaultFS("" + reqBO.getTargetDataSourceInfo().getDbJDBCUrl());
            dataXRWHDFSBO.setFileName(reqBO.getTargetDbTableName());
            dataXRWHDFSBO.setPath(reqBO.getTargetDbPath());
            writerJSON = SwapGetDataXJsonConfServiceImpl.hdfsWriter(dataXRWHDFSBO);
        } else if ("CK".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setWriterJdbcUrl("" + reqBO.getTargetDataSourceInfo().getDbJDBCUrl());
            dataXRWMysqlBO.setName("clickhousewriter");
            writerJSON = SwapGetDataXJsonConfServiceImpl.clickhouseWriter(dataXRWMysqlBO);
        } else if ("DM".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setWriterJdbcUrl("" + reqBO.getTargetDataSourceInfo().getDbJDBCUrl());
            writerJSON = SwapGetDataXJsonConfServiceImpl.rdbmsWriter(dataXRWMysqlBO);
        } else {
            throw new ZTBusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u7684\u5199\u5165\uff01");
        }
        HashMap<String, JSONObject> content = new HashMap<String, JSONObject>();
        ArrayList<HashMap<String, JSONObject>> contentList = new ArrayList<HashMap<String, JSONObject>>();
        content.put("reader", readerJSON);
        content.put("writer", writerJSON);
        contentList.add(content);
        HashMap setting = new HashMap();
        HashMap<String, String> speed = new HashMap<String, String>();
        speed.put("channel", "3");
        setting.put("speed", speed);
        HashMap<String, Cloneable> jobVal = new HashMap<String, Cloneable>();
        jobVal.put("content", contentList);
        jobVal.put("setting", setting);
        HashMap<String, HashMap<String, Cloneable>> job = new HashMap<String, HashMap<String, Cloneable>>();
        job.put("job", jobVal);
        String str = JSON.toJSONString(job);
        JSONObject object = JSONObject.parseObject((String)str);
        str = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        StringBuffer buffer = new StringBuffer(str);
        return buffer;
    }

    static JSONObject getTableCol(List<ExternalColumnBO> columnBOList, String DBType, Map<String, String> dataXDataType, String rwFlag) {
        StringBuffer sql = new StringBuffer();
        int sortId = -1;
        for (ExternalColumnBO columm : columnBOList) {
            ++sortId;
            if ("sync_time".equals(columm.getColumnName())) continue;
            if (0 < sortId) {
                sql.append(",");
            }
            if ("HIVE".equalsIgnoreCase(DBType)) {
                String colType = dataXDataType.get(columm.getDataType());
                String colType1 = StringUtils.isEmpty((Object)colType) ? columm.getDataType() : colType;
                HashMap<String, Object> hiveMap = new HashMap<String, Object>();
                if ("reader".equalsIgnoreCase(rwFlag)) {
                    hiveMap.put("index", sortId);
                } else {
                    hiveMap.put("name", columm.getColumnName());
                }
                if ("reader".equals(rwFlag)) {
                    hiveMap.put("type", "string");
                } else {
                    hiveMap.put("type", colType1);
                }
                sql.append(JSON.parseObject((String)JSON.toJSONString(hiveMap)));
                continue;
            }
            sql.append("\"" + columm.getColumnName() + "\"");
        }
        return JSON.parseObject((String)("{\"column\":[" + sql.toString() + "]}"));
    }

    static JSONObject mysqlReader(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> readerMap = new HashMap<String, Object>();
        readerMap.put("name", dataXRWMysqlBO.getName());
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("username", dataXRWMysqlBO.getReaderUserName());
        parameter.put("password", dataXRWMysqlBO.getReaderPassword());
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderWhere())) {
            parameter.put("where", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderWhere());
                }
            });
        }
        parameter.put("splitPk", dataXRWMysqlBO.getReaderSplitPk());
        final HashMap<String, ArrayList> connectionMap = new HashMap<String, ArrayList>();
        connectionMap.put("jdbcUrl", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getReaderJdbcUrl());
            }
        });
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderQuerySql())) {
            connectionMap.put("querySql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderQuerySql());
                }
            });
        } else {
            connectionMap.put("table", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderTableName());
                }
            });
            parameter.put("column", dataXRWMysqlBO.getReaderColumn().get((Object)"column"));
        }
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        readerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(readerMap));
    }

    static JSONObject rdbmsReader(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> readerMap = new HashMap<String, Object>();
        readerMap.put("name", dataXRWMysqlBO.getName());
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("username", dataXRWMysqlBO.getReaderUserName());
        parameter.put("password", dataXRWMysqlBO.getReaderPassword());
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderWhere())) {
            parameter.put("where", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderWhere());
                }
            });
        }
        parameter.put("splitPk", dataXRWMysqlBO.getReaderSplitPk());
        final HashMap<String, ArrayList> connectionMap = new HashMap<String, ArrayList>();
        connectionMap.put("jdbcUrl", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getReaderJdbcUrl());
            }
        });
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderQuerySql())) {
            connectionMap.put("querySql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderQuerySql());
                }
            });
        } else {
            connectionMap.put("table", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderTableName());
                }
            });
            parameter.put("column", dataXRWMysqlBO.getReaderColumn().get((Object)"column"));
        }
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        readerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(readerMap));
    }

    static JSONObject mysqlWriter(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        writerMap.put("name", "mysqlwriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("writeMode", "insert");
        parameter.put("username", dataXRWMysqlBO.getWriterUserName());
        parameter.put("password", dataXRWMysqlBO.getWriterPassword());
        parameter.put("column", dataXRWMysqlBO.getWriterColumn().get((Object)"column"));
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePreSql())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePreSql());
                }
            });
        } else if ("20".equalsIgnoreCase(dataXRWMysqlBO.getWriteMode())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add("truncate table " + dataXRWMysqlBO.getWriterTableName());
                }
            });
        }
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePostSql())) {
            parameter.put("postSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePostSql());
                }
            });
        }
        final HashMap<String, Object> connectionMap = new HashMap<String, Object>();
        connectionMap.put("jdbcUrl", dataXRWMysqlBO.getWriterJdbcUrl());
        connectionMap.put("table", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getWriterTableName());
            }
        });
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        writerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(writerMap));
    }

    static JSONObject rdbmsWriter(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        writerMap.put("name", "rdbmswriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("writeMode", "insert");
        parameter.put("username", dataXRWMysqlBO.getWriterUserName());
        parameter.put("password", dataXRWMysqlBO.getWriterPassword());
        parameter.put("column", dataXRWMysqlBO.getWriterColumn().get((Object)"column"));
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePreSql())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePreSql());
                }
            });
        } else if ("20".equalsIgnoreCase(dataXRWMysqlBO.getWriteMode())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add("truncate table " + dataXRWMysqlBO.getWriterTableName());
                }
            });
        }
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePostSql())) {
            parameter.put("postSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePostSql());
                }
            });
        }
        final HashMap<String, Object> connectionMap = new HashMap<String, Object>();
        connectionMap.put("jdbcUrl", dataXRWMysqlBO.getWriterJdbcUrl());
        connectionMap.put("table", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getWriterTableName());
            }
        });
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        writerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(writerMap));
    }

    static JSONObject clickhouseWriter(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        writerMap.put("name", dataXRWMysqlBO.getName());
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("writeMode", "insert");
        parameter.put("username", dataXRWMysqlBO.getWriterUserName());
        parameter.put("password", dataXRWMysqlBO.getWriterPassword());
        parameter.put("column", dataXRWMysqlBO.getWriterColumn().get((Object)"column"));
        parameter.put("batchSize", 65536);
        parameter.put("batchByteSize", 0x8000000);
        parameter.put("dryRun", false);
        final HashMap<String, Object> connectionMap = new HashMap<String, Object>();
        connectionMap.put("jdbcUrl", dataXRWMysqlBO.getWriterJdbcUrl());
        connectionMap.put("table", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getWriterTableName());
            }
        });
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        writerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(writerMap));
    }

    static JSONObject hdfsReader(DataXRWHDFSBO dataXRWHDFSBO) {
        HashMap<String, Object> hdfsMap = new HashMap<String, Object>();
        hdfsMap.put("name", "hdfsreader");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("path", dataXRWHDFSBO.getPath());
        parameter.put("defaultFS", dataXRWHDFSBO.getDefaultFS());
        parameter.put("column", dataXRWHDFSBO.getReaderColumn().get((Object)"column"));
        parameter.put("fileType", "text");
        parameter.put("encoding", "UTF-8");
        parameter.put("nullFormat", "\\N");
        parameter.put("fieldDelimiter", "\u0001");
        hdfsMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(hdfsMap));
    }

    static JSONObject hdfsWriter(DataXRWHDFSBO dataXRWHDFSBO) {
        HashMap<String, Object> hdfsWriterMap = new HashMap<String, Object>();
        hdfsWriterMap.put("name", "hdfswriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("path", dataXRWHDFSBO.getPath());
        parameter.put("defaultFS", dataXRWHDFSBO.getDefaultFS());
        parameter.put("fileName", dataXRWHDFSBO.getFileName());
        parameter.put("column", dataXRWHDFSBO.getWriterColumn().get((Object)"column"));
        parameter.put("fileType", "text");
        parameter.put("writeMode", StringUtils.isEmpty((Object)dataXRWHDFSBO.getWriteMode()) ? "append" : dataXRWHDFSBO.getWriteMode());
        parameter.put("encoding", "UTF-8");
        parameter.put("fieldDelimiter", "\u0001");
        hdfsWriterMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(hdfsWriterMap));
    }
}

