/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.dataX;

import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataX.bo.DataXRWHDFSBO;
import com.yqsmartcity.data.swap.api.dataX.bo.DataXRWMysqlBO;
import com.yqsmartcity.data.swap.api.dataX.service.SwapGetDataXJsonService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.SysParaDao;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.SysParaPO;
import com.yqsmartcity.data.swap.po.TableColInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SwapGetDataXJsonServiceImpl
implements SwapGetDataXJsonService {
    private static final Logger log = LoggerFactory.getLogger(SwapGetDataXJsonServiceImpl.class);
    @Value(value="${swap.partition.col}")
    private String swapPartitionCol;
    @Value(value="${hdfs.defalutFS}")
    private String hdfsDefalutFS;
    @Value(value="${hdfs.hive.path}")
    private String hdfsHivePath;
    @Value(value="${hdfs.updata.database}")
    private String hdfsUpdataDatabase;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private TableColInfoDao tableColInfoDao;
    @Autowired
    private SysParaDao sysParaDao;

    public StringBuffer getDataXJson(CreateImportFileReqBO reqBO) throws ZTBusinessException {
        TableInfoPO tableInfoPO = new TableInfoPO();
        tableInfoPO.setDatabaseTable(reqBO.getTableName());
        TableInfoPO queryTableInfoPO = this.tableInfoDao.getModelBy(tableInfoPO);
        if (null == queryTableInfoPO) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5f52\u96c6\u5e93\u7684\u8868\u914d\u7f6e\uff01");
        }
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        databaseInfoPO.setDatabaseCode(queryTableInfoPO.getDatabaseCode());
        databaseInfoPO.setStatus("1");
        DatabaseInfoPO queryDatabaseInfoPO = this.databaseInfoDao.getModelBy(databaseInfoPO);
        if (null == queryDatabaseInfoPO) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6e90\u8868\u7684\u6570\u636e\u5e93\u914d\u7f6e\uff01");
        }
        DatabaseInfoPO targetDatabaseInfoPO = new DatabaseInfoPO();
        targetDatabaseInfoPO.setDatabaseCode(queryTableInfoPO.getTargetDatabaseCode());
        targetDatabaseInfoPO.setStatus("1");
        DatabaseInfoPO targetQueryDatabaseInfoPO = this.databaseInfoDao.getModelBy(targetDatabaseInfoPO);
        if (null == queryDatabaseInfoPO) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u76ee\u6807\u8868\u7684\u6570\u636e\u5e93\u914d\u7f6e\uff01");
        }
        SysParaPO sysParaPO = new SysParaPO();
        sysParaPO.setParaType("DATAX_DATA_TYPE_HIVE");
        sysParaPO.setStatus("1");
        sysParaPO.setOrderBy("sort");
        List<SysParaPO> sysParaPOList = this.sysParaDao.getList(sysParaPO);
        Map<String, String> dataXDataType = sysParaPOList.stream().collect(Collectors.toMap(SysParaPO::getParaCode, SysParaPO::getParaName));
        ArrayList rquerySqlList = new ArrayList();
        TableColInfoPO tableColInfoPO = new TableColInfoPO();
        tableColInfoPO.setTableName(reqBO.getTableName());
        List<TableColInfoPO> tableColInfoPOList = this.tableColInfoDao.getList(tableColInfoPO);
        DataXRWMysqlBO dataXRWMysqlBO = new DataXRWMysqlBO();
        dataXRWMysqlBO.setReaderUserName(queryDatabaseInfoPO.getUserName());
        try {
            dataXRWMysqlBO.setReaderPassword(ConfigTools.decrypt((String)queryDatabaseInfoPO.getUserPass()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u6e90\u6570\u636e\u5e93\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        dataXRWMysqlBO.setReaderTableName(queryTableInfoPO.getSourceTable());
        dataXRWMysqlBO.setReaderColumn(SwapGetDataXJsonServiceImpl.getTableCol(tableColInfoPOList, queryDatabaseInfoPO.getDatabaseType(), dataXDataType, "reader"));
        dataXRWMysqlBO.setReaderQuerySql(queryTableInfoPO.getQueryWhere());
        JSONObject readerJSON = null;
        if ("MS".equals(queryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("jdbc:mysql://" + queryDatabaseInfoPO.getIpAddr() + ":" + queryDatabaseInfoPO.getPortNum() + "/" + queryDatabaseInfoPO.getServerName());
            dataXRWMysqlBO.setName("mysqlreader");
            readerJSON = SwapGetDataXJsonServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("OR".equals(queryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("jdbc:oracle:thin:@" + queryDatabaseInfoPO.getIpAddr() + ":" + queryDatabaseInfoPO.getPortNum() + ":" + queryDatabaseInfoPO.getServerName());
            dataXRWMysqlBO.setName("oraclereader");
            readerJSON = SwapGetDataXJsonServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("SS".equals(queryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("jdbc:sqlserver://" + queryDatabaseInfoPO.getIpAddr() + ":" + queryDatabaseInfoPO.getPortNum() + ";DatabaseName=" + queryDatabaseInfoPO.getServerName());
            dataXRWMysqlBO.setName("sqlserverreader");
            readerJSON = SwapGetDataXJsonServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("HIVE".equals(queryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("jdbc:hive2://" + queryDatabaseInfoPO.getIpAddr() + ":" + queryDatabaseInfoPO.getPortNum() + "/" + queryDatabaseInfoPO.getServerName());
            dataXRWMysqlBO.setName("rdbmsreader");
            readerJSON = SwapGetDataXJsonServiceImpl.rdbmsReader(dataXRWMysqlBO);
        } else if ("DM".equals(queryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setReaderJdbcUrl("jdbc:dm://" + queryDatabaseInfoPO.getIpAddr() + ":" + queryDatabaseInfoPO.getPortNum() + "/" + queryDatabaseInfoPO.getServerName());
            dataXRWMysqlBO.setName("rdbmsreader");
            readerJSON = SwapGetDataXJsonServiceImpl.rdbmsReader(dataXRWMysqlBO);
        } else {
            throw new ZTBusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u7684\u8bfb\u53d6\uff01");
        }
        JSONObject writerJSON = null;
        dataXRWMysqlBO.setWriterUserName(targetQueryDatabaseInfoPO.getUserName());
        try {
            dataXRWMysqlBO.setWriterPassword(ConfigTools.decrypt((String)targetQueryDatabaseInfoPO.getUserPass()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u76ee\u6807\u6570\u636e\u5e93\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        dataXRWMysqlBO.setWriterTableName(queryTableInfoPO.getDatabaseTable());
        dataXRWMysqlBO.setWriterColumn(SwapGetDataXJsonServiceImpl.getTableCol(tableColInfoPOList, targetQueryDatabaseInfoPO.getDatabaseType(), dataXDataType, "writer"));
        if ("MS".equals(targetQueryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setWriterJdbcUrl("jdbc:mysql://" + targetQueryDatabaseInfoPO.getIpAddr() + ":" + targetQueryDatabaseInfoPO.getPortNum() + "/" + targetQueryDatabaseInfoPO.getServerName());
            dataXRWMysqlBO.setName("mysqlwriter");
            writerJSON = SwapGetDataXJsonServiceImpl.mysqlWriter(dataXRWMysqlBO);
        } else if ("HIVE".equals(targetQueryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setName("hdfswriter");
            DataXRWHDFSBO dataXRWHDFSBO = new DataXRWHDFSBO();
            BeanUtils.copyProperties((Object)dataXRWMysqlBO, (Object)dataXRWHDFSBO);
            dataXRWHDFSBO.setDefaultFS(this.hdfsDefalutFS);
            dataXRWHDFSBO.setFileName(reqBO.getTableName());
            dataXRWHDFSBO.setPath(this.hdfsHivePath + "/" + targetQueryDatabaseInfoPO.getServerName() + ".db/" + reqBO.getTableName());
            writerJSON = SwapGetDataXJsonServiceImpl.hdfsWriter(dataXRWHDFSBO);
        } else if ("DM".equals(targetQueryDatabaseInfoPO.getDatabaseType())) {
            dataXRWMysqlBO.setWriterJdbcUrl("jdbc:dm://" + queryDatabaseInfoPO.getIpAddr() + ":" + queryDatabaseInfoPO.getPortNum() + "/" + queryDatabaseInfoPO.getServerName());
            writerJSON = SwapGetDataXJsonServiceImpl.rdbmsWriter(dataXRWMysqlBO);
        } else {
            throw new ZTBusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u7684\u5199\u5165\uff01");
        }
        HashMap<String, JSONObject> content = new HashMap<String, JSONObject>();
        ArrayList<HashMap<String, JSONObject>> contentList = new ArrayList<HashMap<String, JSONObject>>();
        content.put("reader", readerJSON);
        content.put("writer", writerJSON);
        contentList.add(content);
        HashMap setting = new HashMap();
        HashMap<String, String> speed = new HashMap<String, String>();
        speed.put("channel", "3");
        setting.put("speed", speed);
        HashMap<String, Cloneable> jobVal = new HashMap<String, Cloneable>();
        jobVal.put("content", contentList);
        jobVal.put("setting", setting);
        HashMap<String, HashMap<String, Cloneable>> job = new HashMap<String, HashMap<String, Cloneable>>();
        job.put("job", jobVal);
        String str = JSON.toJSONString(job);
        JSONObject object = JSONObject.parseObject((String)str);
        str = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        StringBuffer buffer = new StringBuffer(str);
        return buffer;
    }

    static JSONObject getTableCol(List<TableColInfoPO> tableColInfoPOList, String DBType, Map<String, String> dataXDataType, String rwFlag) {
        StringBuffer sql = new StringBuffer();
        int sortId = 0;
        for (TableColInfoPO columm : tableColInfoPOList) {
            if ("sync_time".equals(columm.getColumnName())) continue;
            if (0 < sortId++) {
                sql.append(",");
            }
            if ("HIVE".equalsIgnoreCase(DBType) && "writer".equals(rwFlag)) {
                String colType = dataXDataType.get(columm.getDataType());
                String colType1 = StringUtils.isEmpty((Object)colType) ? columm.getDataType() : colType;
                HashMap<String, Object> hiveMap = new HashMap<String, Object>();
                if ("reader".equalsIgnoreCase(rwFlag)) {
                    hiveMap.put("index", sortId);
                } else {
                    hiveMap.put("name", columm.getColumnName());
                }
                hiveMap.put("type", colType1);
                sql.append(JSON.parseObject((String)JSON.toJSONString(hiveMap)));
                continue;
            }
            sql.append("\"" + columm.getColumnName() + "\"");
        }
        return JSON.parseObject((String)("{\"column\":[" + sql.toString() + "]}"));
    }

    static JSONObject mysqlReader(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> readerMap = new HashMap<String, Object>();
        readerMap.put("name", dataXRWMysqlBO.getName());
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("username", dataXRWMysqlBO.getReaderUserName());
        parameter.put("password", dataXRWMysqlBO.getReaderPassword());
        parameter.put("column", dataXRWMysqlBO.getReaderColumn().get((Object)"column"));
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderWhere())) {
            parameter.put("where", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderWhere());
                }
            });
        }
        parameter.put("splitPk", dataXRWMysqlBO.getReaderSplitPk());
        final HashMap<String, ArrayList> connectionMap = new HashMap<String, ArrayList>();
        connectionMap.put("jdbcUrl", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getReaderJdbcUrl());
            }
        });
        connectionMap.put("table", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getReaderTableName());
            }
        });
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderQuerySql())) {
            connectionMap.put("querySql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderQuerySql());
                }
            });
        }
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        readerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(readerMap));
    }

    static JSONObject mysqlWriter(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        writerMap.put("name", "mysqlwriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("writeMode", StringUtils.isEmpty((Object)dataXRWMysqlBO.getWriteMode()) ? "insert" : dataXRWMysqlBO.getWriteMode());
        parameter.put("username", dataXRWMysqlBO.getWriterUserName());
        parameter.put("password", dataXRWMysqlBO.getWriterPassword());
        parameter.put("column", dataXRWMysqlBO.getWriterColumn().get((Object)"column"));
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePreSql())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePreSql());
                }
            });
        }
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePostSql())) {
            parameter.put("postSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePostSql());
                }
            });
        }
        final HashMap<String, Object> connectionMap = new HashMap<String, Object>();
        connectionMap.put("jdbcUrl", dataXRWMysqlBO.getWriterJdbcUrl());
        connectionMap.put("table", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getWriterTableName());
            }
        });
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        writerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(writerMap));
    }

    static JSONObject hdfsReader(DataXRWHDFSBO dataXRWHDFSBO) {
        HashMap<String, Object> hdfsMap = new HashMap<String, Object>();
        hdfsMap.put("name", "hdfsreader");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (StringUtils.isEmpty((Object)dataXRWHDFSBO.getReaderPartionWhere())) {
            parameter.put("path", dataXRWHDFSBO.getPath());
        } else {
            parameter.put("path", dataXRWHDFSBO.getPath() + "/" + dataXRWHDFSBO.getReaderPartionWhere());
        }
        parameter.put("defaultFS", dataXRWHDFSBO.getDefaultFS());
        parameter.put("column", dataXRWHDFSBO.getReaderColumn().get((Object)"column"));
        parameter.put("fileType", "TEXT");
        parameter.put("encoding", "UTF-8");
        parameter.put("fieldDelimiter", "\u0001");
        hdfsMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(hdfsMap));
    }

    static JSONObject hdfsWriter(DataXRWHDFSBO dataXRWHDFSBO) {
        HashMap<String, Object> hdfsWriterMap = new HashMap<String, Object>();
        hdfsWriterMap.put("name", "hdfswriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("path", dataXRWHDFSBO.getPath() + "/dt=${dt}");
        parameter.put("defaultFS", dataXRWHDFSBO.getDefaultFS());
        parameter.put("fileName", dataXRWHDFSBO.getFileName());
        parameter.put("column", dataXRWHDFSBO.getWriterColumn().get((Object)"column"));
        parameter.put("fileType", "TEXT");
        parameter.put("writeMode", StringUtils.isEmpty((Object)dataXRWHDFSBO.getWriteMode()) ? "append" : dataXRWHDFSBO.getWriteMode());
        parameter.put("encoding", "UTF-8");
        parameter.put("fieldDelimiter", "\u0001");
        hdfsWriterMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(hdfsWriterMap));
    }

    static JSONObject rdbmsReader(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> readerMap = new HashMap<String, Object>();
        readerMap.put("name", dataXRWMysqlBO.getName());
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("username", dataXRWMysqlBO.getReaderUserName());
        parameter.put("password", dataXRWMysqlBO.getReaderPassword());
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderWhere())) {
            parameter.put("where", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderWhere());
                }
            });
        }
        parameter.put("splitPk", dataXRWMysqlBO.getReaderSplitPk());
        final HashMap<String, ArrayList> connectionMap = new HashMap<String, ArrayList>();
        connectionMap.put("jdbcUrl", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getReaderJdbcUrl());
            }
        });
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderQuerySql())) {
            connectionMap.put("querySql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderQuerySql());
                }
            });
        } else {
            connectionMap.put("table", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getReaderTableName());
                }
            });
            parameter.put("column", dataXRWMysqlBO.getReaderColumn().get((Object)"column"));
        }
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        readerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(readerMap));
    }

    static JSONObject rdbmsWriter(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        writerMap.put("name", "rdbmswriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("writeMode", "insert");
        parameter.put("username", dataXRWMysqlBO.getWriterUserName());
        parameter.put("password", dataXRWMysqlBO.getWriterPassword());
        parameter.put("column", dataXRWMysqlBO.getWriterColumn().get((Object)"column"));
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePreSql())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePreSql());
                }
            });
        } else if ("20".equalsIgnoreCase(dataXRWMysqlBO.getWriteMode())) {
            parameter.put("preSql", new ArrayList<String>(){
                {
                    this.add("truncate table " + dataXRWMysqlBO.getWriterTableName());
                }
            });
        }
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePostSql())) {
            parameter.put("postSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePostSql());
                }
            });
        }
        final HashMap<String, Object> connectionMap = new HashMap<String, Object>();
        connectionMap.put("jdbcUrl", dataXRWMysqlBO.getWriterJdbcUrl());
        connectionMap.put("table", new ArrayList<String>(){
            {
                this.add(dataXRWMysqlBO.getWriterTableName());
            }
        });
        parameter.put("connection", new ArrayList<Object>(){
            {
                this.add(connectionMap);
            }
        });
        writerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(writerMap));
    }
}

