/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.database;

import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.database.bo.SwapUpdateDatabaseInfoReqBO;
import com.yqsmartcity.data.swap.api.database.service.SwapUpdateDatabaseInfoBusiService;
import com.yqsmartcity.data.swap.dao.DatabaseDbidInfoDao;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.DatabaseInfoLogDao;
import com.yqsmartcity.data.swap.dao.DeptInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseDbidInfoPO;
import com.yqsmartcity.data.swap.po.DatabaseInfoLogPO;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.DeptInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateDatabaseInfoBusiServiceImpl
implements SwapUpdateDatabaseInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateDatabaseInfoBusiServiceImpl.class);
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private DeptInfoDao deptInfoDao;
    @Autowired
    private DatabaseInfoLogDao databaseInfoLogDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private DatabaseDbidInfoDao databaseDbidInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public void updateDatabaseInfo(SwapUpdateDatabaseInfoReqBO swapUpdateDatabaseInfoReqBO) throws ZTBusinessException {
        int result;
        this.validateParam(swapUpdateDatabaseInfoReqBO);
        DatabaseInfoPO qryPO = new DatabaseInfoPO();
        qryPO.setUnid(swapUpdateDatabaseInfoReqBO.getUnid());
        qryPO.setStatus("1");
        DatabaseInfoPO databaseInfoPO = this.databaseInfoDao.getModelBy(qryPO);
        if (null == databaseInfoPO) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6761\u6570\u636e!");
        }
        DeptInfoPO deptInfoPO = new DeptInfoPO();
        deptInfoPO.setSourceDeptCode(swapUpdateDatabaseInfoReqBO.getDeptCode());
        deptInfoPO.setStatus("1");
        DeptInfoPO deptInfoPO1 = this.deptInfoDao.getModelBy(deptInfoPO);
        String deptNo = null;
        if (null == deptInfoPO1) {
            DeptInfoPO addDeptInfoPO = new DeptInfoPO();
            deptNo = this.deptInfoDao.abbrDeptName(swapUpdateDatabaseInfoReqBO.getDeptName()).toLowerCase();
            if (deptNo.length() > 4) {
                deptNo = deptNo.substring(0, 4);
            } else if (deptNo.length() < 4) {
                StringBuffer sb = null;
                while (deptNo.length() < 4) {
                    sb = new StringBuffer();
                    sb.append(deptNo).append("0");
                    deptNo = sb.toString();
                }
            }
            addDeptInfoPO.setDeptCode(deptNo);
            addDeptInfoPO.setDeptName(swapUpdateDatabaseInfoReqBO.getDeptName());
            addDeptInfoPO.setSourceDeptCode(swapUpdateDatabaseInfoReqBO.getDeptCode());
            addDeptInfoPO.setStatus("1");
            addDeptInfoPO.setCreateTime(new Date());
            addDeptInfoPO.setUpdateTime(new Date());
            result = this.deptInfoDao.insert(addDeptInfoPO);
            if (result < 1) {
                throw new ZTBusinessException("\u90e8\u95e8\u65b0\u589e\u5931\u8d25!");
            }
        }
        DatabaseInfoLogPO databaseInfoLogPO = new DatabaseInfoLogPO();
        BeanUtils.copyProperties((Object)databaseInfoPO, (Object)databaseInfoLogPO);
        databaseInfoLogPO.setOperId2(swapUpdateDatabaseInfoReqBO.getOperId());
        databaseInfoLogPO.setOperDate(new Date());
        databaseInfoLogPO.setUnid(null);
        result = this.databaseInfoLogDao.insert(databaseInfoLogPO);
        if (result < 1) {
            throw new ZTBusinessException("\u5c06\u6e90\u6570\u636e\u590d\u5236\u5230\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
        }
        DatabaseInfoPO databaseInfoPO1 = new DatabaseInfoPO();
        BeanUtils.copyProperties((Object)swapUpdateDatabaseInfoReqBO, (Object)databaseInfoPO1);
        if (null == deptInfoPO1) {
            databaseInfoPO1.setDeptCode(deptNo);
        } else {
            databaseInfoPO1.setDeptCode(deptInfoPO1.getDeptCode());
        }
        databaseInfoPO1.setUpdateTime(new Date());
        if (null != swapUpdateDatabaseInfoReqBO.getUserId()) {
            databaseInfoPO1.setOperId(String.valueOf(swapUpdateDatabaseInfoReqBO.getUserId()));
        }
        databaseInfoPO1.setOperName(swapUpdateDatabaseInfoReqBO.getName());
        if ("******".equals(swapUpdateDatabaseInfoReqBO.getUserPass())) {
            databaseInfoPO1.setUserPass(null);
        } else {
            try {
                databaseInfoPO1.setUserPass(ConfigTools.encrypt((String)databaseInfoPO1.getUserPass()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int updateResult = this.databaseInfoDao.updateById(databaseInfoPO1);
        if (updateResult < 1) {
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25!");
        }
        DatabaseDbidInfoPO qryDatabaseDbidInfoPO = new DatabaseDbidInfoPO();
        qryDatabaseDbidInfoPO.setDatabaseCode(databaseInfoPO.getDatabaseCode());
        qryDatabaseDbidInfoPO.setStatus("1");
        DatabaseDbidInfoPO databaseDbidInfoPO = this.databaseDbidInfoDao.getModelBy(qryDatabaseDbidInfoPO);
        if (!databaseDbidInfoPO.getDbid().equals(swapUpdateDatabaseInfoReqBO.getDbId())) {
            databaseDbidInfoPO.setDbid(swapUpdateDatabaseInfoReqBO.getDbId());
        }
        databaseDbidInfoPO.setConfigState(swapUpdateDatabaseInfoReqBO.getConfigState());
        databaseDbidInfoPO.setUpdateTime(new Date());
        int result1 = this.databaseDbidInfoDao.updateById(databaseDbidInfoPO);
        if (result1 < 1) {
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25!");
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)swapUpdateDatabaseInfoReqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("M");
        swapInsertOperLogReqBO.setOperContent("\u7f16\u8f91:" + swapUpdateDatabaseInfoReqBO.getDatabaseName() + "\u6570\u636e\u6e90");
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapUpdateDatabaseInfoReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getDeptCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u7f16\u7801\u3010deptCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDeptName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u540d\u79f0\u3010deptName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u3010databaseName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u7c7b\u578b\u3010databaseType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseTypeDesc())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u7c7b\u578b\u63cf\u8ff0\u3010databaseTypeDesc\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u7f16\u7801\u3010nodeCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u540d\u79f0\u3010nodeName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getUserName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7528\u6237\u540d\u3010userName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getUserPass())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5bc6\u7801\u3010userPass\u3011\u4e3a\u7a7a");
        }
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010unid\u3011\u4e3a\u7a7a");
        }
        if (null == reqBO.getDbId()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8d44\u6e90\u76ee\u5f55\u6570\u636e\u6e90ID\u3010dbId\u3011\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }
}

