/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.linkdb.bo.AutoCreateTableReqBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.AutoCreateTableRspBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.JdbcQueryBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapAutomaticTableCreationService;
import com.yqsmartcity.data.swap.dao.AutoTableColInfoDao;
import com.yqsmartcity.data.swap.dao.AutoTableInfoDao;
import com.yqsmartcity.data.swap.dao.ColumnDataTypeChangeDao;
import com.yqsmartcity.data.swap.po.AutoTableColInfoPO;
import com.yqsmartcity.data.swap.po.AutoTableInfoPO;
import com.yqsmartcity.data.swap.po.ColumnDataTypeChangePO;
import com.yqsmartcity.data.swap.service.busi.impl.linkdb.SwapAutoCreateTableServiceImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SwapAutomaticTableCreationServiceImpl
implements SwapAutomaticTableCreationService {
    private static final Logger log = LoggerFactory.getLogger(SwapAutomaticTableCreationServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapAutoCreateTableServiceImpl.class);
    @Autowired
    private AutoTableInfoDao autoTableInfoDao;
    @Autowired
    private AutoTableColInfoDao autoTableColInfoDao;
    @Autowired
    private ColumnDataTypeChangeDao columnDataTypeChangeDao;

    public AutoCreateTableRspBO createTable(AutoCreateTableReqBO reqBO) throws ZTBusinessException {
        AutoCreateTableRspBO rspBO = new AutoCreateTableRspBO();
        this.validateParam(reqBO);
        AutoTableInfoPO autoTableInfoPO = new AutoTableInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)autoTableInfoPO);
        this.autoTableInfoDao.insert(autoTableInfoPO);
        ArrayList<AutoTableColInfoPO> listAutoTableColInfoPO = new ArrayList<AutoTableColInfoPO>();
        reqBO.getColumnInfo().forEach(e -> {
            AutoTableColInfoPO autoTableColInfoPO = new AutoTableColInfoPO();
            BeanUtils.copyProperties((Object)e, (Object)autoTableColInfoPO);
            autoTableColInfoPO.setTableUnid(autoTableInfoPO.getUnid());
            listAutoTableColInfoPO.add(autoTableColInfoPO);
        });
        this.autoTableColInfoDao.insertBatch(listAutoTableColInfoPO);
        if (StringUtils.isEmpty((String)reqBO.getTargetTableName())) {
            rspBO.setSourceTable("");
            reqBO.setTargetTableName("");
        }
        List<ColumnDataTypeChangePO> columnDataTypeChangePOList = null;
        if (!reqBO.getSourceDbType().equals(reqBO.getTargetDbType())) {
            ColumnDataTypeChangePO columnDataTypeChangePO = new ColumnDataTypeChangePO();
            columnDataTypeChangePO.setSourceDbType(reqBO.getSourceDbType());
            columnDataTypeChangePO.setTargetDbType(reqBO.getTargetDbType());
            columnDataTypeChangePO.setStatus("1");
            try {
                columnDataTypeChangePOList = this.columnDataTypeChangeDao.getList(columnDataTypeChangePO);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (CollectionUtils.isEmpty(columnDataTypeChangePOList)) {
                this.throwException(autoTableInfoPO.getUnid(), "\u672a\u5339\u914d\u5230\u6e90\u4e0e\u76ee\u6807\u6570\u636e\u5e93\u5b57\u6bb5\u7c7b\u578b\u8f6c\u6362\u5173\u7cfb");
            }
        }
        String url = reqBO.getTargetDbJdbcUrl();
        String userName = reqBO.getTargetDbUserName();
        String passwd = reqBO.getTargetDbPassword();
        String projectName = reqBO.getTargetDbName();
        String columnStr = "";
        String primaryKey = "";
        String commentStr = "";
        for (ColumnBO columnBO : reqBO.getColumnInfo()) {
            if (!StringUtils.isEmpty((String)columnStr)) {
                columnStr = columnStr + ",";
            }
            columnStr = columnStr + " " + columnBO.getColumnName();
            String dateType = "";
            String lengthFlag2 = "";
            if (!reqBO.getSourceDbType().equals(reqBO.getTargetDbType())) {
                for (ColumnDataTypeChangePO dataTypePO : columnDataTypeChangePOList) {
                    if (!columnBO.getDataType().equals(dataTypePO.getSourceDataType().toUpperCase())) continue;
                    dateType = dataTypePO.getTargetDataType();
                    lengthFlag2 = dataTypePO.getLengthFlag();
                    break;
                }
                if (StringUtils.isEmpty((String)dateType)) {
                    this.throwException(autoTableInfoPO.getUnid(), "\u6e90\u5b57\u6bb5\u7c7b\u578b[" + columnBO.getDataType() + "]\u672a\u5339\u914d\u5230\u76ee\u6807\u5b57\u6bb5\u7c7b\u578b");
                }
                if (StringUtils.isEmpty((String)columnBO.getColumnLength()) && "1".equals(lengthFlag2)) {
                    this.throwException(autoTableInfoPO.getUnid(), "\u6e90\u5b57\u6bb5\u7c7b\u578b[" + columnBO.getDataType() + "]\u7684\u5b57\u6bb5\u957f\u5ea6[ColumnLength]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else {
                dateType = columnBO.getDataType();
            }
            columnStr = !StringUtils.isEmpty((String)columnBO.getColumnLength()) && !"0".equals(lengthFlag2) ? columnStr + " " + dateType + "(" + columnBO.getColumnLength() + ")" : columnStr + " " + dateType;
            if ("Oracle".equals(reqBO.getTargetDbType()) || "MySQL".equals(reqBO.getTargetDbType()) || "SqlServer".equals(reqBO.getTargetDbType())) {
                columnStr = "0".equals(columnBO.getIsNull()) ? columnStr + " not null" : columnStr + " null";
            }
            if ("Oracle".equals(reqBO.getTargetDbType())) {
                commentStr = commentStr + "comment on column  " + reqBO.getTargetTableName() + "." + columnBO.getColumnName() + " is '" + columnBO.getColumnComment() + "';";
                if (!"1".equals(columnBO.getIsPrimary())) continue;
                if (!StringUtils.isEmpty((String)primaryKey)) {
                    primaryKey = primaryKey + ",";
                }
                primaryKey = primaryKey + columnBO.getColumnName();
                continue;
            }
            if ("MySQL".equals(reqBO.getTargetDbType())) {
                columnStr = columnStr + " comment '" + columnBO.getColumnComment() + "'";
                if (!"1".equals(columnBO.getIsPrimary())) continue;
                if (!StringUtils.isEmpty((String)primaryKey)) {
                    primaryKey = primaryKey + ",";
                }
                primaryKey = primaryKey + columnBO.getColumnName();
                continue;
            }
            if (!"SqlServer".equals(reqBO.getTargetDbType()) || !"1".equals(columnBO.getIsPrimary())) continue;
            if (!StringUtils.isEmpty((String)primaryKey)) {
                primaryKey = primaryKey + ",";
            }
            primaryKey = primaryKey + columnBO.getColumnName();
        }
        String tableCheckSql = "";
        String createTableSql = "";
        String driver = "";
        if ("Oracle".equals(reqBO.getTargetDbType())) {
            driver = "oracle.jdbc.driver.OracleDriver";
            tableCheckSql = "select table_name from all_tables where table_name=upper('" + reqBO.getTargetTableName() + "')";
            this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "query", tableCheckSql);
            createTableSql = "create table " + reqBO.getTargetTableName() + "(";
            createTableSql = createTableSql + columnStr;
            if (!StringUtils.isEmpty((String)primaryKey)) {
                createTableSql = createTableSql + ", primary key (" + primaryKey + ")";
            }
            createTableSql = createTableSql + ");";
            if (!StringUtils.isEmpty((String)commentStr)) {
                createTableSql = createTableSql + commentStr;
            }
            this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", createTableSql);
            if ("1".equals(reqBO.getDeleteFlag())) {
                this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", "drop table " + reqBO.getTargetTableName() + ";");
            }
        } else if ("MySQL".equals(reqBO.getTargetDbType())) {
            driver = "com.mysql.jdbc.Driver";
            url = url + "?useUnicode=true&characterEncoding=utf8&serverTimezone=UTC&useSSL=false";
            tableCheckSql = "show tables like '" + reqBO.getTargetTableName() + "'";
            this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "query", tableCheckSql);
            createTableSql = "create table " + reqBO.getTargetTableName() + "(";
            createTableSql = createTableSql + columnStr;
            if (!StringUtils.isEmpty((String)primaryKey)) {
                createTableSql = createTableSql + ", primary key (" + primaryKey + ")";
            }
            createTableSql = createTableSql + ");";
            this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", createTableSql);
            if ("1".equals(reqBO.getDeleteFlag())) {
                this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", "drop table " + reqBO.getTargetTableName() + ";");
            }
        } else if ("SqlServer".equals(reqBO.getTargetDbType())) {
            driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            tableCheckSql = "SELECT NAME FROM sysobjects t WHERE t.xtype='U' and NAME='" + reqBO.getTargetTableName() + "'";
            this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "query", tableCheckSql);
            createTableSql = "create table " + reqBO.getTargetTableName() + "(";
            createTableSql = createTableSql + columnStr;
            if (!StringUtils.isEmpty((String)primaryKey)) {
                createTableSql = createTableSql + ", primary key (" + primaryKey + ")";
            }
            createTableSql = createTableSql + ");";
            if (!StringUtils.isEmpty((String)commentStr)) {
                createTableSql = createTableSql + commentStr;
            }
            this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", createTableSql);
            if ("1".equals(reqBO.getDeleteFlag())) {
                this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", "drop table " + reqBO.getTargetTableName() + ";");
            }
        } else if ("MaxCompute".equals(reqBO.getTargetDbType())) {
            driver = "com.aliyun.odps.jdbc.OdpsDriver";
            createTableSql = "create table " + reqBO.getTargetTableName() + "(" + columnStr + ");";
            if (!StringUtils.isEmpty((String)commentStr)) {
                createTableSql = createTableSql + commentStr;
            }
            this.execOdpsSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", createTableSql, projectName);
            if ("1".equals(reqBO.getDeleteFlag())) {
                this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", "drop table " + reqBO.getTargetTableName() + ";");
            }
        } else if ("Hive".equals(reqBO.getTargetDbType())) {
            String partitonInfo;
            driver = "org.apache.hive.jdbc.HiveDriver";
            createTableSql = "create table " + reqBO.getTargetTableName() + "(" + columnStr + ")";
            if (!StringUtils.isEmpty((String)commentStr)) {
                createTableSql = createTableSql + commentStr;
            }
            if (!StringUtils.isEmpty((String)(partitonInfo = this.partitonColumn(reqBO.getPartitonClumnInfo())))) {
                createTableSql = createTableSql + partitonInfo + "\n";
            }
            createTableSql = createTableSql + " row format delimited fields terminated by \"\\u001\"";
            this.execHiveSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", createTableSql, projectName);
            if ("1".equals(reqBO.getDeleteFlag())) {
                this.executeSql(autoTableInfoPO.getUnid(), driver, url, userName, passwd, "execute", "drop table " + reqBO.getTargetTableName() + "");
            }
        } else {
            this.throwException(autoTableInfoPO.getUnid(), "\u6682\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b:" + reqBO.getTargetDbType());
        }
        autoTableInfoPO.setRemark("\u6210\u529f");
        this.autoTableInfoDao.updateByPrimaryKeySelective(autoTableInfoPO);
        rspBO.setSourceTable(reqBO.getTargetTableName());
        return rspBO;
    }

    private void throwException(Long unid, String comment) {
        AutoTableInfoPO autoTableInfoPO = new AutoTableInfoPO();
        autoTableInfoPO.setUnid(unid);
        autoTableInfoPO.setRemark(comment);
        this.autoTableInfoDao.updateByPrimaryKeySelective(autoTableInfoPO);
        throw new ZTBusinessException(comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(Long unid, String driver, String url, String userName, String passwd, String executeType, String sqlStatement) {
        Connection con = null;
        try {
            Class.forName(driver);
            con = DriverManager.getConnection(url, userName, passwd);
            if (!con.isClosed()) {
                logger.info("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
            }
            try (Statement statement = con.createStatement();){
                try {
                    logger.info("sql=====[" + sqlStatement + "]");
                    if ("query".equals(executeType)) {
                        String[] resultSet = statement.executeQuery(sqlStatement);
                        while (resultSet.next()) {
                            String table = resultSet.getString(1);
                            if (StringUtils.isEmpty((String)table)) continue;
                            throw new ZTBusinessException("\u76ee\u6807\u5e93\u5df2\u5b58\u5728\u8be5\u8868");
                        }
                        resultSet.close();
                    } else {
                        for (String sql : sqlStatement.split(";")) {
                            int re = statement.executeUpdate(sql);
                            if (re != -1) continue;
                            throw new ZTBusinessException("SQL\u6267\u884c\u5931\u8d25");
                        }
                    }
                    con.close();
                    logger.info("\u6570\u636e\u5e93\u5df2\u5173\u95ed\u8fde\u63a5");
                }
                catch (SQLException e) {
                    logger.info("SQL\u6267\u884c\u5931\u8d25");
                    e.printStackTrace();
                    this.throwException(unid, "SQL\u6267\u884c\u5931\u8d25![" + e.getMessage() + "]");
                }
                catch (Exception e) {
                    this.throwException(unid, e.getMessage());
                }
                finally {
                    if (null != con) {
                        try {
                            con.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.throwException(unid, "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01" + e.getMessage());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            this.throwException(unid, "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01" + throwables.getMessage());
        }
    }

    private void sqlServerExecute(AutoCreateTableReqBO reqBO) {
        Object connect = null;
        Object statement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execOdpsSql(Long unid, String driver, String url, String userName, String passwd, String executeType, String sqlStatement, String projectName) throws ZTBusinessException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Properties config = new Properties();
        config.put("access_id", userName);
        config.put("access_key", passwd);
        config.put("project_name", projectName);
        Statement stmt = null;
        Connection conn = null;
        ResultSet rs = null;
        JdbcQueryBO jdbcQueryBO = new JdbcQueryBO();
        try {
            conn = DriverManager.getConnection(url, config);
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            throw new ZTBusinessException("\u8fde\u63a5ODPS\u5931\u8d25\uff01" + e.getMessage());
        }
        logger.info("sql=====[" + sqlStatement + "]");
        try {
            if ("execute".equalsIgnoreCase(executeType)) {
                stmt.execute(sqlStatement);
            } else if ("query".equalsIgnoreCase(executeType)) {
                rs = stmt.executeQuery(sqlStatement);
                jdbcQueryBO.setRs(rs);
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (e.getMessage().indexOf("Table or view already exists") > 0) {
                this.throwException(unid, "SQL\u6267\u884c\u5931\u8d25![\u8868\u6216\u89c6\u56fe\u5df2\u5b58\u5728]");
            }
            this.throwException(unid, "SQL\u6267\u884c\u5931\u8d25![" + e.getMessage() + "]");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execHiveSql(Long unid, String driver, String url, String userName, String passwd, String executeType, String sqlStatement, String projectName) throws ZTBusinessException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.error("\u672a\u627e\u5230hive\u9a71\u52a8");
        }
        ResultSet resultSet = null;
        try (Connection connect = DriverManager.getConnection(url, userName, passwd);){
            logger.debug("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f");
            try (Statement stmt = connect.createStatement();){
                logger.info("\u5f00\u59cb\u67e5\u8be2\u8868\u7684\u5217");
                logger.info("sql=====[" + sqlStatement + "]");
                try {
                    if ("execute".equalsIgnoreCase(executeType)) {
                        stmt.execute(sqlStatement);
                    } else if ("query".equalsIgnoreCase(executeType)) {
                        resultSet = stmt.executeQuery(sqlStatement);
                        while (resultSet.next()) {
                            logger.info("---------------" + resultSet.getString(1));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage().indexOf("already exists") > 0) {
                        this.throwException(unid, "SQL\u6267\u884c\u5931\u8d25![\u8868\u5df2\u5b58\u5728]");
                    }
                    this.throwException(unid, "SQL\u6267\u884c\u5931\u8d25![" + e.getMessage() + "]");
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connect != null) {
                            connect.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new ZTBusinessException("\u8fde\u63a5HIVE\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private String partitonColumn(List<ColumnBO> columnInfo) {
        String partitonInfo = "";
        if (!CollectionUtils.isEmpty(columnInfo)) {
            for (ColumnBO columnBO : columnInfo) {
                if (!StringUtils.isEmpty((String)partitonInfo)) {
                    partitonInfo = partitonInfo + ",";
                }
                partitonInfo = partitonInfo + columnBO.getColumnName() + " " + columnBO.getDataType() + " COMMENT \"" + columnBO.getColumnComment() + "\"";
            }
            if (!StringUtils.isEmpty((String)partitonInfo)) {
                partitonInfo = "PARTITIONED BY (" + partitonInfo + ")";
            }
        }
        return partitonInfo;
    }

    private void validateParam(AutoCreateTableReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getSourceDbType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u5e93\u7c7b\u578b\u3010sourceDbType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSourceTableName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u8868\u540d\u3010sourceTableName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDbJdbcUrl())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7684JDBC\u5730\u5740\u3010targetDbJdbcUrl\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDbType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u5e93\u7c7b\u578b\u3010targetDbType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDbUserName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u7528\u6237\u540d\u3010targetDbUserName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetDbPassword())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u5bc6\u7801\u3010targetDbPassword\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDeleteFlag())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u662f\u5426\u5220\u9664\u6807\u5fd7\u3010deleteFlag\u3011\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getColumnInfo())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u4fe1\u606f\u3010columnInfo\u3011\u4e3a\u7a7a");
        }
        for (ColumnBO columnBO : reqBO.getColumnInfo()) {
            if (StringUtils.isEmpty((String)columnBO.getColumnName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u540d\u3010columnName\u3011\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((String)columnBO.getDataType())) continue;
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u7c7b\u578b\u3010dataType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTargetTableName())) {
            throw new ZTBusinessException("\u81ea\u52a8\u751f\u6210\u8868\u540d\u529f\u80fd\u6682\u672a\u5f00\u653e\uff01");
        }
        if ("MaxCompute".equals(reqBO.getTargetDbType()) && StringUtils.isEmpty((String)reqBO.getTargetDbName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570ODPS\u9879\u76ee\u540d\u79f0\u3010targetDbName\u3011\u4e3a\u7a7a\uff01");
        }
    }
}

