/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SysParaBO;
import com.yqsmartcity.data.swap.api.base.service.SwapQrySysParaListBusiService;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.SwapLinkdbReqBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableInfoListBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapInsertTableColInfoService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkGetDatabaseService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkMysqlService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOracleService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkSqlServerService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.TableColInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SwapInsertTableColInfoServiceImpl
implements SwapInsertTableColInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapInsertTableColInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapInsertTableColInfoServiceImpl.class);
    @Autowired
    private SwapLinkOracleService swapLinkOracleService;
    @Autowired
    private SwapLinkMysqlService swapLinkMysqlService;
    @Autowired
    private SwapLinkSqlServerService swapLinkSqlServerService;
    @Autowired
    private SwapLinkGetDatabaseService swapLinkGetDatabaseService;
    @Autowired
    private SwapQrySysParaListBusiService swapQrySysParaListBusiService;
    @Value(value="${technology.type}")
    private String technologyType;
    @Autowired
    private TableColInfoDao tableColInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private TableInfoDao tableInfoDao;
    Map<String, String> odpsType = new HashMap<String, String>();
    Map<String, String> hiveMysqlType = new HashMap<String, String>();
    Map<String, String> hiveOracleType = new HashMap<String, String>();
    Map<String, String> hiveSqlserverType = new HashMap<String, String>();

    @Transactional(rollbackFor={Exception.class})
    public TableInfoListBO insertTableColInfo(SwapLinkdbReqBO reqBO) throws ZTBusinessException {
        logger.info(reqBO.toString());
        TableInfoListBO tableInfoListBO = new TableInfoListBO();
        ArrayList<TableBO> tableBOList = new ArrayList();
        SwapQrySysParaListReqBO swapQrySysParaListReqBO = new SwapQrySysParaListReqBO();
        swapQrySysParaListReqBO.setParaType("TO_ODPS_TYPE");
        SwapQrySysParaListRspBO odpsTypeList = this.swapQrySysParaListBusiService.qrySysParaList(swapQrySysParaListReqBO);
        if (null != odpsTypeList && !CollectionUtils.isEmpty((Collection)odpsTypeList.getSysParaBOList())) {
            this.odpsType = odpsTypeList.getSysParaBOList().stream().collect(Collectors.toMap(SysParaBO::getParaCode, SysParaBO::getParaName));
        }
        swapQrySysParaListReqBO.setParaType("MYSQL_TO_HIVE_TYPE");
        SwapQrySysParaListRspBO hiveMysqlTypeList = this.swapQrySysParaListBusiService.qrySysParaList(swapQrySysParaListReqBO);
        if (null != hiveMysqlTypeList && !CollectionUtils.isEmpty((Collection)hiveMysqlTypeList.getSysParaBOList())) {
            this.hiveMysqlType = hiveMysqlTypeList.getSysParaBOList().stream().collect(Collectors.toMap(SysParaBO::getParaCode, SysParaBO::getParaName));
        }
        try {
            for (String tableName : reqBO.getDatabaseTable()) {
                TableInfoPO tableInfoPO = new TableInfoPO();
                tableInfoPO.setDatabaseTable(tableName);
                TableInfoPO queryTableInfoPO = this.tableInfoDao.getModelBy(tableInfoPO);
                if (null == queryTableInfoPO) {
                    throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5f52\u96c6\u5e93\u7684\u8868\u914d\u7f6e\uff01");
                }
                DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
                databaseInfoPO.setDatabaseCode(queryTableInfoPO.getDatabaseCode());
                databaseInfoPO.setStatus("1");
                DatabaseInfoPO queryDatabaseInfoPO = this.databaseInfoDao.getModelBy(databaseInfoPO);
                if (null == queryDatabaseInfoPO) {
                    throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u5e93\u914d\u7f6e\uff01");
                }
                DatabaseInfoBO queryDatabaseInfoBO = new DatabaseInfoBO();
                BeanUtils.copyProperties((Object)queryDatabaseInfoPO, (Object)queryDatabaseInfoBO);
                queryDatabaseInfoBO.setSourceTable(queryTableInfoPO.getSourceTable());
                queryDatabaseInfoBO.setDatabaseTable(queryTableInfoPO.getDatabaseTable());
                queryDatabaseInfoBO.setQryTableFlag("col");
                try {
                    tableBOList = this.swapLinkGetDatabaseService.getDatabase(queryDatabaseInfoBO);
                }
                catch (ZTBusinessException e1) {
                    throw new ZTBusinessException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5\u6570\u636e\u6e90\u7684\u914d\u7f6e");
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5\u6570\u636e\u6e90\u7684\u914d\u7f6e");
                }
                try {
                    this.createColumnTable(tableBOList, queryDatabaseInfoPO);
                    this.updateTableColumn(tableBOList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tableInfoListBO.setTableName(tableBOList);
        return tableInfoListBO;
    }

    public void createColumnTable(List<TableBO> tableBOList, DatabaseInfoPO databaseInfoPO) throws Exception {
        logger.info("getCreateTableString====start======tableName=");
        StringBuffer createTableColSql = new StringBuffer();
        for (TableBO odpsTable : tableBOList) {
            TableColInfoPO tableColInfoPO = new TableColInfoPO();
            tableColInfoPO.setTableName(odpsTable.getTableName());
            List<TableColInfoPO> tableColInfoPOQuery = this.tableColInfoDao.getList(tableColInfoPO);
            String operStatus = "a";
            if (!CollectionUtils.isEmpty(tableColInfoPOQuery) && tableColInfoPOQuery.size() > 0) {
                operStatus = "m";
                List<Long> unidList = tableColInfoPOQuery.stream().map(TableColInfoPO::getUnid).collect(Collectors.toList());
                this.tableColInfoDao.deleteByIds(unidList.toArray(new Long[unidList.size()]));
            }
            ArrayList<TableColInfoPO> listTableColInfoPO = new ArrayList<TableColInfoPO>();
            for (ColumnBO colList : odpsTable.getColumnBOList()) {
                TableColInfoPO insertTableColInfoPO = new TableColInfoPO();
                insertTableColInfoPO.setTableName(odpsTable.getTableName());
                insertTableColInfoPO.setColumnName(colList.getColumnName());
                String getDataType = null;
                if ("dataworks".equals(this.technologyType)) {
                    if (null != this.odpsType.get(colList.getDataType())) {
                        getDataType = this.odpsType.get(colList.getDataType());
                    }
                } else if ("opensource".equals(this.technologyType) && null != this.hiveMysqlType.get(colList.getDataType()) && "MS".equals(databaseInfoPO.getDatabaseType())) {
                    getDataType = this.hiveMysqlType.get(colList.getDataType());
                }
                if (StringUtils.isEmpty(getDataType)) {
                    getDataType = colList.getColumnType();
                }
                insertTableColInfoPO.setDataType(getDataType);
                insertTableColInfoPO.setColumnComment(colList.getColumnComment());
                insertTableColInfoPO.setSortId(Integer.parseInt(colList.getOrdinalPosition()));
                insertTableColInfoPO.setOperStatus(operStatus);
                insertTableColInfoPO.setUpdateTime(new Date());
                listTableColInfoPO.add(insertTableColInfoPO);
            }
            TableColInfoPO insertTableColInfoPO = new TableColInfoPO();
            insertTableColInfoPO.setTableName(odpsTable.getTableName());
            insertTableColInfoPO.setColumnName("sync_time");
            if ("dataworks".equals(this.technologyType)) {
                insertTableColInfoPO.setDataType("datetime");
            } else if ("opensource".equals(this.technologyType)) {
                insertTableColInfoPO.setDataType("string");
            }
            insertTableColInfoPO.setColumnComment("\u540c\u6b65\u65f6\u95f4");
            insertTableColInfoPO.setSortId(odpsTable.getColumnBOList().size() + 1);
            insertTableColInfoPO.setOperStatus(operStatus);
            insertTableColInfoPO.setUpdateTime(new Date());
            listTableColInfoPO.add(insertTableColInfoPO);
            this.tableColInfoDao.insertBatch(listTableColInfoPO);
            logger.info("createColumnTable====end======");
        }
    }

    public void updateTableColumn(List<TableBO> tableBOList) throws Exception {
        logger.info("getUpdateTableColumn====start======tableName=");
        ArrayList<TableInfoPO> tableInfoPOList = new ArrayList<TableInfoPO>();
        for (TableBO odpsTable : tableBOList) {
            TableInfoPO tableInfoPO = new TableInfoPO();
            tableInfoPO.setDatabaseTable(odpsTable.getTableName());
            tableInfoPO.setDatabaseTableName(odpsTable.getTableComment());
            tableInfoPOList.add(tableInfoPO);
        }
        this.tableInfoDao.updateBatchDatabaseTableName(tableInfoPOList);
        logger.info("getUpdateTableColumn====end======");
    }
}

