/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkGetDatabaseService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkHiveService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkMysqlService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOracleService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkSqlServerService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapLinkGetDatabaseServiceImpl
implements SwapLinkGetDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(SwapLinkGetDatabaseServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapLinkGetDatabaseServiceImpl.class);
    @Autowired
    private SwapLinkOracleService swapLinkOracleService;
    @Autowired
    private SwapLinkMysqlService swapLinkMysqlService;
    @Autowired
    private SwapLinkSqlServerService swapLinkSqlServerService;
    @Autowired
    private SwapLinkHiveService swapLinkHiveService;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public List<TableBO> getDatabase(DatabaseInfoBO queryDatabaseInfoBO) throws ZTBusinessException {
        logger.info(queryDatabaseInfoBO.toString());
        List tableBOList = null;
        this.validateParam(queryDatabaseInfoBO);
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        if ("******".equals(queryDatabaseInfoBO.getUserPass())) {
            databaseInfoPO.setUnid(queryDatabaseInfoBO.getUnid());
            databaseInfoPO.setStatus("1");
            databaseInfoPO = this.databaseInfoDao.getModelBy(databaseInfoPO);
            if (StringUtils.isEmpty((String)databaseInfoPO.getUserPass())) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u6e90");
            }
        }
        if ("******".equals(queryDatabaseInfoBO.getUserPass()) && !StringUtils.isEmpty((String)queryDatabaseInfoBO.getLinkDatabaseFlag())) {
            try {
                queryDatabaseInfoBO.setUserPass(ConfigTools.decrypt((String)databaseInfoPO.getUserPass()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((String)queryDatabaseInfoBO.getUserPass()) && StringUtils.isEmpty((String)queryDatabaseInfoBO.getLinkDatabaseFlag())) {
            try {
                queryDatabaseInfoBO.setUserPass(ConfigTools.decrypt((String)queryDatabaseInfoBO.getUserPass()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getTableSchema())) {
            queryDatabaseInfoBO.setTableSchema(queryDatabaseInfoBO.getUserName());
        }
        if ("OR".equals(queryDatabaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkOracleService.linkOracle(queryDatabaseInfoBO);
        } else if ("MS".equalsIgnoreCase(queryDatabaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkMysqlService.linkMysql(queryDatabaseInfoBO);
        } else if ("SS".equalsIgnoreCase(queryDatabaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkSqlServerService.linkSqlServer(queryDatabaseInfoBO);
        } else if ("HIVE".equalsIgnoreCase(queryDatabaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkHiveService.linkHive(queryDatabaseInfoBO);
        }
        return tableBOList;
    }

    private void validateParam(DatabaseInfoBO queryDatabaseInfoBO) {
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getDatabaseType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u7c7b\u578b\u3010databaseType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getIpAddr())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u5730\u5740\u3010ipAddr\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getPortNum())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u7aef\u53e3\u3010portNum\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getServerName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u670d\u52a1\u540d\u3010serverName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getUserName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u7528\u6237\u540d\u3010userName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getUserPass())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u5e93\u5bc6\u7801\u3010userPass\u3011\u4e3a\u7a7a");
        }
    }
}

