/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkHiveService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SwapLinkHiveServiceImpl
implements SwapLinkHiveService {
    private static final Logger log = LoggerFactory.getLogger(SwapLinkHiveServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapLinkHiveServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableBO> linkHive(DatabaseInfoBO queryDatabaseInfoBO) throws ZTBusinessException {
        ArrayList<TableBO> tableBOList = new ArrayList<TableBO>();
        ResultSet resultSet = null;
        String ip = queryDatabaseInfoBO.getIpAddr();
        String port = queryDatabaseInfoBO.getPortNum();
        String serverName = queryDatabaseInfoBO.getServerName();
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
        }
        catch (ClassNotFoundException e) {
            logger.error("\u672a\u627e\u5230hive\u9a71\u52a8");
        }
        try {
            String connectDB = "jdbc:hive2://" + ip + ":" + port + "/" + queryDatabaseInfoBO.getTableSchema();
            String user = queryDatabaseInfoBO.getUserName();
            String password = queryDatabaseInfoBO.getUserPass();
            try (Connection connect = DriverManager.getConnection(connectDB, user, password);){
                logger.debug("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f");
                Statement stmt = connect.createStatement();
                logger.debug("\u5f00\u59cb\u67e5\u8be2\u8868\u7684\u5217");
                if ("table".equalsIgnoreCase(queryDatabaseInfoBO.getQryTableFlag())) {
                    String query = "show tables";
                    logger.info("query=====" + query);
                    resultSet = stmt.executeQuery(query);
                    while (resultSet.next()) {
                        TableBO tableBO = new TableBO();
                        tableBO.setTableName(resultSet.getString(1));
                        tableBOList.add(tableBO);
                    }
                } else {
                    String query = "describe " + queryDatabaseInfoBO.getSourceTable();
                    logger.debug("\u67e5\u8be2query=====" + query);
                    resultSet = stmt.executeQuery(query);
                    ResultSetMetaData meta = resultSet.getMetaData();
                    String tableComment1 = null;
                    TableBO tableBO = new TableBO();
                    ArrayList<ColumnBO> columnBOList = new ArrayList<ColumnBO>();
                    while (resultSet.next()) {
                        String colName = resultSet.getString("col_name");
                        ColumnBO columnBO = new ColumnBO();
                        if (!StringUtils.isBlank((String)colName) && !"#".equalsIgnoreCase(colName.substring(0, 1))) {
                            columnBO.setColumnName(colName);
                            columnBO.setDataType(resultSet.getObject("data_type").toString());
                            columnBO.setColumnComment(resultSet.getObject("comment").toString());
                            columnBOList.add(columnBO);
                            continue;
                        }
                        if (!"# Partition Information".equalsIgnoreCase(colName)) continue;
                        resultSet.next();
                        resultSet.next();
                        resultSet.next();
                        String partitionName = resultSet.getString("col_name");
                        for (ColumnBO cnBO : columnBOList) {
                            if (!partitionName.equalsIgnoreCase(cnBO.getColumnName())) continue;
                            cnBO.setIsPrimary("1");
                        }
                    }
                    tableBO.setTableName(queryDatabaseInfoBO.getDatabaseTable());
                    tableBO.setTableComment(tableComment1);
                    tableBO.setColumnBOList(columnBOList);
                    tableBOList.add(tableBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tableBOList;
    }
}

