/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.linkdb;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.TableBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOracleService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SwapLinkOracleServiceImpl
implements SwapLinkOracleService {
    private static final Logger log = LoggerFactory.getLogger(SwapLinkOracleServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapLinkOracleServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableBO> linkOracle(DatabaseInfoBO queryDatabaseInfoBO) throws ZTBusinessException {
        Statement statement = null;
        String ip = queryDatabaseInfoBO.getIpAddr();
        String port = queryDatabaseInfoBO.getPortNum();
        String serverName = queryDatabaseInfoBO.getServerName();
        String userName = queryDatabaseInfoBO.getUserName();
        String userPass = queryDatabaseInfoBO.getUserPass();
        ResultSet resultSet = null;
        ArrayList<TableBO> tableBOList = new ArrayList<TableBO>();
        TableBO tableBO = null;
        if (StringUtils.isEmpty((String)queryDatabaseInfoBO.getServerName())) {
            throw new ZTBusinessException("\u6570\u636e\u5e93\u670d\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            try (Connection connect = DriverManager.getConnection("jdbc:oracle:thin:@" + ip + ":" + port + ":" + serverName, userName, userPass);
                 Statement stmt = connect.createStatement();){
                String query;
                if ("table".equalsIgnoreCase(queryDatabaseInfoBO.getQryTableFlag())) {
                    query = " select  a.TABLE_NAME  as table_name         ,a.COMMENTS as table_comment from   all_tab_comments a  where table_type='TABLE'  and a.OWNER = upper('" + queryDatabaseInfoBO.getTableSchema() + "')";
                    logger.info("query=====" + query);
                    resultSet = stmt.executeQuery(query);
                    while (resultSet.next()) {
                        tableBO = new TableBO();
                        tableBO.setTableName(resultSet.getString("table_name"));
                        tableBO.setTableComment(resultSet.getString("table_comment"));
                        tableBOList.add(tableBO);
                    }
                } else {
                    query = " select  a.TABLE_NAME  as table_name         ,a.COMMENTS as table_comment         ,b.COLUMN_NAME as column_name         ,case when c.data_type ='NUMBER'  and (data_scale=0 or data_scale is null)  then                                        'varchar2'                                      else lower(c.data_type)          end as data_type         ,lower(c.data_type)  as column_type         ,b.COMMENTS  as column_comment         ,c.COLUMN_ID as ordinal_position from   all_tab_comments a,all_col_comments b,all_tab_columns c where  a.TABLE_NAME=b.table_name and a.table_name=c.TABLE_NAME and b.COLUMN_NAME=c.COLUMN_NAME and a.OWNER = b.OWNER  and a.OWNER = c.OWNER  and a.OWNER = upper('" + queryDatabaseInfoBO.getTableSchema() + "') and b.OWNER = upper('" + queryDatabaseInfoBO.getTableSchema() + "') and c.OWNER = upper('" + queryDatabaseInfoBO.getTableSchema() + "') and a.TABLE_NAME = upper('" + queryDatabaseInfoBO.getSourceTable() + "') order by c.COLUMN_ID";
                    logger.info("query=====" + query);
                    resultSet = stmt.executeQuery(query);
                    String tableComment1 = null;
                    tableBO = new TableBO();
                    ArrayList<ColumnBO> columnBOList = new ArrayList<ColumnBO>();
                    while (resultSet.next()) {
                        ColumnBO columnBO = new ColumnBO();
                        columnBO.setColumnName(resultSet.getString("column_name"));
                        columnBO.setDataType(resultSet.getString("data_type"));
                        columnBO.setColumnType(resultSet.getString("column_type"));
                        columnBO.setOrdinalPosition(resultSet.getString("ordinal_position"));
                        columnBO.setColumnComment(resultSet.getString("column_comment"));
                        tableComment1 = resultSet.getString("table_comment");
                        columnBOList.add(columnBO);
                    }
                    tableBO.setTableName(queryDatabaseInfoBO.getDatabaseTable());
                    tableBO.setTableComment(tableComment1);
                    tableBO.setColumnBOList(columnBOList);
                    tableBOList.add(tableBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tableBOList;
    }
}

