/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.node;

import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.node.bo.SwapInsertNodeInfoReqBO;
import com.yqsmartcity.data.swap.api.node.service.SwapInsertNodeInfoService;
import com.yqsmartcity.data.swap.dao.NodeInfoDao;
import com.yqsmartcity.data.swap.po.NodeInfoPO;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapInsertNodeInfoServiceImpl
implements SwapInsertNodeInfoService {
    private static final Logger log = LoggerFactory.getLogger(SwapInsertNodeInfoServiceImpl.class);
    @Autowired
    private NodeInfoDao nodeInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;

    @Transactional(rollbackFor={Exception.class})
    public void insertNodeInfo(SwapInsertNodeInfoReqBO reqBO) throws ZTBusinessException {
        int result;
        this.validateParam(reqBO);
        String nodeCode = SwapInsertNodeInfoServiceImpl.getRandom(12);
        if ("1".equals(reqBO.getNodeType())) {
            NodeInfoPO qryNodeInfoPO = new NodeInfoPO();
            qryNodeInfoPO.setNodeType("1");
            qryNodeInfoPO.setStatus("1");
            NodeInfoPO nodeInfoPO = this.nodeInfoDao.getModelBy(qryNodeInfoPO);
            if (null != nodeInfoPO) {
                throw new ZTBusinessException("\u5df2\u7ecf\u5b58\u5728\u4e2d\u5fc3\u8282\u70b9\uff0c\u6682\u4e0d\u652f\u6301\u591a\u4e2a\u4e2d\u5fc3\u8282\u70b9\uff01");
            }
        }
        NodeInfoPO qryNodeInfoPO2 = new NodeInfoPO();
        qryNodeInfoPO2.setStatus("1");
        qryNodeInfoPO2.setNodeName(reqBO.getNodeName());
        NodeInfoPO nodeInfoPO2 = this.nodeInfoDao.getModelBy(qryNodeInfoPO2);
        if (null != nodeInfoPO2) {
            throw new ZTBusinessException("\u8be5\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        NodeInfoPO nodeInfoPO = new NodeInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)nodeInfoPO);
        nodeInfoPO.setCreateTime(new Date());
        nodeInfoPO.setUpdateTime(new Date());
        nodeInfoPO.setNodeCode(nodeCode);
        nodeInfoPO.setStatus("1");
        if (null != reqBO.getUserId()) {
            nodeInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        nodeInfoPO.setOperName(reqBO.getName());
        if (!StringUtils.isEmpty((String)reqBO.getAdminAgentPassword())) {
            try {
                nodeInfoPO.setAdminAgentPassword(ConfigTools.encrypt((String)reqBO.getAdminAgentPassword()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((result = this.nodeInfoDao.insert(nodeInfoPO)) < 1) {
            throw new ZTBusinessException("\u8c03\u7528\u5931\u8d25!");
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("A");
        if ("1".equals(reqBO.getNodeType())) {
            swapInsertOperLogReqBO.setOperContent("\u65b0\u589e:" + reqBO.getNodeName() + "\u4e2d\u5fc3\u8282\u70b9");
        } else {
            swapInsertOperLogReqBO.setOperContent("\u65b0\u589e:" + reqBO.getNodeName() + "\u524d\u7f6e\u8282\u70b9");
        }
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapInsertNodeInfoReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getNodeName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u540d\u79f0\u3010nodeName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getIpAddress())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570IP\u5730\u5740\u3010ipAddress\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u7c7b\u578b\u3010nodeType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeStatus())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u72b6\u6001\u3010nodeStatus\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getServer())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u670d\u52a1\u5668\u3010server\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNetworkLocation())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7f51\u7edc\u5730\u5740\u3010networkLocation\u3011\u4e3a\u7a7a");
        }
    }

    public static String getRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }
}

