/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.node;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.node.bo.NodeInfoBO;
import com.yqsmartcity.data.swap.api.node.bo.SwapQryNodeListReqBO;
import com.yqsmartcity.data.swap.api.node.bo.SwapQryNodeListRspBO;
import com.yqsmartcity.data.swap.api.node.service.SwapQryNodeListService;
import com.yqsmartcity.data.swap.dao.NodeInfoDao;
import com.yqsmartcity.data.swap.po.NodeInfoPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SwapQryNodeListServiceImpl
implements SwapQryNodeListService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryNodeListServiceImpl.class);
    @Autowired
    private NodeInfoDao nodeInfoDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;

    @Transactional(rollbackFor={Exception.class})
    public SwapQryNodeListRspBO qryNodeList(SwapQryNodeListReqBO reqBO) throws ZTBusinessException {
        SwapQryNodeListRspBO rspBO = new SwapQryNodeListRspBO();
        NodeInfoPO qryNodeInfoPO = new NodeInfoPO();
        qryNodeInfoPO.setNodeName(SwapQryNodeListServiceImpl.queryString(reqBO.getNodeName()));
        qryNodeInfoPO.setStatus("1");
        if (!StringUtils.isEmpty((Object)reqBO.getQueryFlag())) {
            qryNodeInfoPO.setQueryFlag(reqBO.getQueryFlag());
            qryNodeInfoPO.setNodeStatus("1");
        }
        List<NodeInfoPO> nodeInfoPOList = this.nodeInfoDao.getList(qryNodeInfoPO);
        ArrayList<NodeInfoBO> nodeInfoBOList = new ArrayList<NodeInfoBO>();
        if (!CollectionUtils.isEmpty(nodeInfoPOList)) {
            for (NodeInfoPO nodeInfoPO : nodeInfoPOList) {
                NodeInfoBO nodeInfoBO = new NodeInfoBO();
                BeanUtils.copyProperties((Object)nodeInfoPO, (Object)nodeInfoBO);
                nodeInfoBO.setNodeTypeName(this.getSysPara(nodeInfoPO.getNodeType(), "NODE_TYPE"));
                nodeInfoBO.setNodeStatusName(this.getSysPara(nodeInfoPO.getNodeStatus(), "NODE_STATUS_TYPE"));
                nodeInfoBO.setNetworkLocationName(this.getSysPara(nodeInfoPO.getNetworkLocation(), "NETWORK_LOCATION_TYPE"));
                if (!StringUtils.isEmpty((Object)nodeInfoPO.getAdminAgentPassword())) {
                    nodeInfoBO.setAdminAgentPassword("******");
                }
                nodeInfoBOList.add(nodeInfoBO);
            }
        }
        rspBO.setNodeInfoBOList(nodeInfoBOList);
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }

    public static String queryString(String temp) {
        if (temp == null || temp == "") {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(temp.trim());
        StringBuilder tempBuilder = new StringBuilder();
        tempBuilder.append(temp.trim());
        int j = 0;
        for (int i = 0; i < b.length(); ++i) {
            char x = b.charAt(i);
            if (x != '%' && x != '_') continue;
            tempBuilder.insert(i + j, '\\');
            ++j;
        }
        return tempBuilder.toString();
    }
}

