/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.node;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.node.bo.SwapUpdateNodeStatusReqBO;
import com.yqsmartcity.data.swap.api.node.service.SwapUpdateNodeStatusService;
import com.yqsmartcity.data.swap.dao.NodeInfoDao;
import com.yqsmartcity.data.swap.po.NodeInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateNodeStatusServiceImpl
implements SwapUpdateNodeStatusService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateNodeStatusServiceImpl.class);
    @Autowired
    private NodeInfoDao nodeInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;

    @Transactional(rollbackFor={Exception.class})
    public void updateNodeStatus(SwapUpdateNodeStatusReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        NodeInfoPO checkNodeInfoPO = this.nodeInfoDao.getModelById(reqBO.getUnid());
        if (null == checkNodeInfoPO) {
            return;
        }
        if ("1".equals(checkNodeInfoPO.getNodeStatus())) {
            throw new ZTBusinessException("\u8282\u70b9\u6b63\u5728\u4f7f\u7528\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        NodeInfoPO nodeInfoPO = new NodeInfoPO();
        nodeInfoPO.setUnid(reqBO.getUnid());
        nodeInfoPO.setStatus("0");
        nodeInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            nodeInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        nodeInfoPO.setOperName(reqBO.getName());
        int result = this.nodeInfoDao.updateById(nodeInfoPO);
        if (result < 1) {
            throw new ZTBusinessException("\u5220\u9664\u8282\u70b9\u4fe1\u606f\u5931\u8d25!");
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("D");
        if ("1".equals(checkNodeInfoPO.getNodeType())) {
            swapInsertOperLogReqBO.setOperContent("\u5220\u9664:" + checkNodeInfoPO.getNodeName() + "\u4e2d\u5fc3\u8282\u70b9");
        } else {
            swapInsertOperLogReqBO.setOperContent("\u5220\u9664:" + checkNodeInfoPO.getNodeName() + "\u524d\u7f6e\u8282\u70b9");
        }
        this.log(swapInsertOperLogReqBO);
    }

    private void validateParam(SwapUpdateNodeStatusReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010Unid\u3011\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }
}

