/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.node;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.node.bo.SwapUpdateNodeStatusStartEndReqBO;
import com.yqsmartcity.data.swap.api.node.service.SwapUpdateNodeStatusStartEndService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.NodeInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.NodeInfoPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateNodeStatusStartEndServiceImpl
implements SwapUpdateNodeStatusStartEndService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateNodeStatusStartEndServiceImpl.class);
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private NodeInfoDao nodeInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public void updateNodeStatusStart(SwapUpdateNodeStatusStartEndReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        NodeInfoPO checkNodeInfoPO = this.nodeInfoDao.getModelById(reqBO.getUnid());
        if (null == checkNodeInfoPO) {
            return;
        }
        if ("2".equals(reqBO.getNodeStatus())) {
            DatabaseInfoPO qryDatabaseInfoPO = new DatabaseInfoPO();
            qryDatabaseInfoPO.setNodeCode(checkNodeInfoPO.getNodeCode());
            qryDatabaseInfoPO.setStatus("1");
            List<DatabaseInfoPO> databaseInfoPOList = this.databaseInfoDao.getList(qryDatabaseInfoPO);
            if (databaseInfoPOList.size() > 0) {
                throw new ZTBusinessException("\u8282\u70b9\u6b63\u5728\u4f7f\u7528\u4e2d\uff0c\u65e0\u6cd5\u505c\u7528");
            }
        }
        NodeInfoPO nodeInfoPO = new NodeInfoPO();
        nodeInfoPO.setUnid(reqBO.getUnid());
        nodeInfoPO.setNodeStatus(reqBO.getNodeStatus());
        nodeInfoPO.setUpdateTime(new Date());
        if (null != reqBO.getUserId()) {
            nodeInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        nodeInfoPO.setOperName(reqBO.getName());
        int result = this.nodeInfoDao.updateById(nodeInfoPO);
        if (result < 1) {
            throw new ZTBusinessException("\u4fee\u6539\u8282\u70b9\u72b6\u6001\u5931\u8d25!");
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        if ("1".equals(reqBO.getNodeStatus())) {
            swapInsertOperLogReqBO.setOperType("E");
            if ("1".equals(checkNodeInfoPO.getNodeType())) {
                swapInsertOperLogReqBO.setOperContent("\u542f\u7528:" + checkNodeInfoPO.getNodeName() + "\u4e2d\u5fc3\u8282\u70b9");
            } else {
                swapInsertOperLogReqBO.setOperContent("\u542f\u7528:" + checkNodeInfoPO.getNodeName() + "\u524d\u7f6e\u8282\u70b9");
            }
        } else {
            swapInsertOperLogReqBO.setOperType("I");
            if ("1".equals(checkNodeInfoPO.getNodeType())) {
                swapInsertOperLogReqBO.setOperContent("\u505c\u7528:" + checkNodeInfoPO.getNodeName() + "\u4e2d\u5fc3\u8282\u70b9");
            } else {
                swapInsertOperLogReqBO.setOperContent("\u505c\u7528:" + checkNodeInfoPO.getNodeName() + "\u524d\u7f6e\u8282\u70b9");
            }
        }
        this.log(swapInsertOperLogReqBO);
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }

    private void validateParam(SwapUpdateNodeStatusStartEndReqBO reqBO) {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u4e3b\u952e\u3010Unid\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeStatus())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u542f\u7528\u505c\u7528\u6807\u8bc6\u3010nodeStatus\u3011\u4e3a\u7a7a");
        }
    }
}

