/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.odps.bo.ProjectNameAndTimeReqBO;
import com.yqsmartcity.data.swap.api.odps.service.readDataWorksInstances;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.po.DataWorksInstancesPO;
import com.yqsmartcity.data.swap.po.RecordFlagPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReadDataWorksInstancesImpl
implements readDataWorksInstances {
    private static final Logger log = LoggerFactory.getLogger(ReadDataWorksInstancesImpl.class);
    @Autowired
    DataWorksDao dataWorksDao;
    @Value(value="${accessID}")
    private String accessID;
    @Value(value="${accessKey}")
    private String accessKey;
    @Value(value="${odpsUrl}")
    private String odpsUrl;

    public void qryDataWorksInstances(ProjectNameAndTimeReqBO projectNameAndTimeReqBO) {
        int number = 0;
        int successNumber = 0;
        int failNumber = 0;
        AliyunAccount account = new AliyunAccount(this.accessID, this.accessKey);
        Odps odps = new Odps((Account)account);
        odps.setEndpoint(this.odpsUrl);
        odps.setDefaultProject(projectNameAndTimeReqBO.getProjectName());
        for (Instance i : odps.instances()) {
            Date tempTime = projectNameAndTimeReqBO.getTime();
            long zero = tempTime.getTime() / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
            long twelve = zero + 86400000L - 1L;
            long instanceRunDate = i.getEndTime().getTime();
            if (instanceRunDate <= zero || instanceRunDate >= twelve) continue;
            ++number;
            try {
                if (i.isSuccessful()) {
                    ++successNumber;
                    continue;
                }
                ++failNumber;
            }
            catch (OdpsException e) {
                e.printStackTrace();
            }
        }
        DataWorksInstancesPO InstancesPO = new DataWorksInstancesPO();
        InstancesPO.setProjectName(projectNameAndTimeReqBO.getProjectName());
        InstancesPO.setInstancesFailNumber(failNumber);
        InstancesPO.setInstanceNumber(number);
        InstancesPO.setProjectName(InstancesPO.getProjectName());
        InstancesPO.setInstancesSuccessNumber(successNumber);
        InstancesPO.setUpdateTime(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        String dateStr = sdf.format(projectNameAndTimeReqBO.getTime());
        try {
            Date mydate = sdf.parse(dateStr);
            InstancesPO.setInstanceDate(mydate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String Record2 = "1";
        InstancesPO.setRecordFlag(Record2);
        RecordFlagPO recordFlagPO = new RecordFlagPO();
        Date time = InstancesPO.getUpdateTime();
        recordFlagPO.setUpdateTime(time);
        recordFlagPO.setRecordFlag("0");
        this.dataWorksDao.updataInstancesRecordFlag(recordFlagPO);
        int insert = this.dataWorksDao.insertInstances(InstancesPO);
        if (insert < 1) {
            throw new ZTBusinessException("\u8c03\u7528\u5931\u8d25!");
        }
        if (null == InstancesPO.getUnid()) {
            throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25!");
        }
    }
}

