/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.odps;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.odps.bo.ProjectNameReqBO;
import com.yqsmartcity.data.swap.api.odps.service.readDataWorksProjects;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.po.DataWorksProjectsPO;
import com.yqsmartcity.data.swap.po.RecordFlagPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReadDataWorksProjectsImpl
implements readDataWorksProjects {
    private static final Logger log = LoggerFactory.getLogger(ReadDataWorksProjectsImpl.class);
    @Autowired
    DataWorksDao dataWorksDao;
    @Value(value="${accessID}")
    private String accessID;
    @Value(value="${accessKey}")
    private String accessKey;
    @Value(value="${odpsUrl}")
    private String odpsUrl;

    public void qryDataWorksProjects(ProjectNameReqBO projectNameReqBO) {
        AliyunAccount account = new AliyunAccount(this.accessID, this.accessKey);
        Odps odps = new Odps((Account)account);
        DataWorksProjectsPO projectsPO = new DataWorksProjectsPO();
        odps.setEndpoint(this.odpsUrl);
        Project project = null;
        try {
            project = odps.projects().get(projectNameReqBO.getProjectName());
            projectsPO.setProject_status(project.getStatus().toString());
            projectsPO.setProject_owner(project.getOwner());
            projectsPO.setProjectName(project.getName());
        }
        catch (OdpsException e) {
            e.printStackTrace();
        }
        projectsPO.setUpdateTime(new Date());
        Date time = projectsPO.getUpdateTime();
        projectsPO.setRecordFlag("1");
        RecordFlagPO recordFlagPO = new RecordFlagPO();
        recordFlagPO.setUpdateTime(time);
        recordFlagPO.setRecordFlag("0");
        this.dataWorksDao.updataProjectRecordFlag(recordFlagPO);
        int insert = this.dataWorksDao.insertProjects(projectsPO);
        if (insert < 1) {
            throw new ZTBusinessException("\u8c03\u7528\u5931\u8d25!");
        }
        if (null == projectsPO.getUnid()) {
            throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25!");
        }
    }
}

