/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.odps;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.yqsmartcity.data.swap.api.odps.bo.ProjectNameReqBO;
import com.yqsmartcity.data.swap.api.odps.service.readDataWorksTables;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.po.DataWorksTablesPO;
import com.yqsmartcity.data.swap.po.RecordFlagTablePO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReadDataWorksTablesImpl
implements readDataWorksTables {
    private static final Logger log = LoggerFactory.getLogger(ReadDataWorksTablesImpl.class);
    @Autowired
    DataWorksDao dataWorksDao;
    @Value(value="${accessID}")
    private String accessID;
    @Value(value="${accessKey}")
    private String accessKey;
    @Value(value="${odpsUrl}")
    private String odpsUrl;

    public void qryDataWorksTables(ProjectNameReqBO projectNameReqBO) {
        AliyunAccount account = new AliyunAccount(this.accessID, this.accessKey);
        Odps odps = new Odps((Account)account);
        odps.setEndpoint(this.odpsUrl);
        odps.setDefaultProject(projectNameReqBO.getProjectName());
        Date startDate = new Date();
        ArrayList<DataWorksTablesPO> listPO = new ArrayList<DataWorksTablesPO>();
        try {
            for (Table t : odps.tables()) {
                DataWorksTablesPO tablesPO = new DataWorksTablesPO();
                tablesPO.setTableName(t.getName());
                tablesPO.setTableCreatedTime(t.getCreatedTime());
                tablesPO.setTableOwner(t.getOwner());
                tablesPO.setTableSize((double)t.getSize() * 1.0 / 1024.0 + "");
                tablesPO.setTableLifeCycle(t.getLife());
                tablesPO.setTableDataModifiedTime(t.getLastDataModifiedTime());
                tablesPO.setProjectName(t.getProject());
                tablesPO.setTablePartitionFlag(t.isPartitioned());
                if (t.isPartitioned()) {
                    tablesPO.setTablePartitionNumber(t.getPartitions().size());
                } else {
                    tablesPO.setTablePartitionNumber(0);
                }
                Date time = new Date();
                tablesPO.setUpdateTime(time);
                tablesPO.setRecordFlag("1");
                listPO.add(tablesPO);
            }
        }
        catch (OdpsException e) {
            e.printStackTrace();
        }
        this.dataWorksDao.insertTables(listPO);
        RecordFlagTablePO recordFlagTablePO = new RecordFlagTablePO();
        recordFlagTablePO.setStartTime(startDate);
        recordFlagTablePO.setRecord_flag("0");
        this.dataWorksDao.updataTableRecordFlag(recordFlagTablePO);
    }
}

