/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.task.SQLTask;
import com.yqsmartcity.data.swap.api.odps.bo.ProjectNameAndTableReqBO;
import com.yqsmartcity.data.swap.api.odps.service.readDateWorksTableRowNumber;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.po.DataWorksTableRowNumberPO;
import com.yqsmartcity.data.swap.po.RecordFlagPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReadDateWorksTableRowNumberImpl
implements readDateWorksTableRowNumber {
    private static final Logger log = LoggerFactory.getLogger(ReadDateWorksTableRowNumberImpl.class);
    @Autowired
    DataWorksDao dataWorksDao;
    @Value(value="${accessID}")
    private String accessID;
    @Value(value="${accessKey}")
    private String accessKey;
    @Value(value="${odpsUrl}")
    private String odpsUrl;

    public void qryDateWorksTableRowNumber(ProjectNameAndTableReqBO projectNameAndTableReqBO) {
        AliyunAccount account = new AliyunAccount(this.accessID, this.accessKey);
        Odps odps = new Odps((Account)account);
        odps.setEndpoint(this.odpsUrl);
        odps.setDefaultProject(projectNameAndTableReqBO.getProjectName());
        Table t = odps.tables().get(projectNameAndTableReqBO.getTableName());
        DataWorksTableRowNumberPO tableRowNumberPO = new DataWorksTableRowNumberPO();
        tableRowNumberPO.setProjectName(projectNameAndTableReqBO.getProjectName());
        tableRowNumberPO.setTableName(t.getName());
        String rowNumber = null;
        boolean bo = false;
        try {
            bo = t.isPartitioned();
        }
        catch (OdpsException e) {
            e.printStackTrace();
        }
        String sqlpartition = null;
        sqlpartition = "select  count(*) from " + projectNameAndTableReqBO.getTableName() + ";";
        try {
            Instance in = SQLTask.run((Odps)odps, (String)sqlpartition);
            in.waitForSuccess();
            List records = SQLTask.getResult((Instance)in);
            for (Record r : records) {
                rowNumber = r.get(0).toString();
                Long lo = Long.valueOf(rowNumber);
                tableRowNumberPO.setRowNumber(lo);
            }
        }
        catch (OdpsException e) {
            e.printStackTrace();
        }
        tableRowNumberPO.setUpdateTime(new Date());
        Date time = tableRowNumberPO.getUpdateTime();
        tableRowNumberPO.setRecordFlag("1");
        this.dataWorksDao.insertTableRowNumber(tableRowNumberPO);
        RecordFlagPO recordFlagPO = new RecordFlagPO();
        recordFlagPO.setRecordFlag("0");
        recordFlagPO.setUnid(tableRowNumberPO.getUnid());
        this.dataWorksDao.updataTableRowNumber(recordFlagPO);
    }
}

