/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.oozie;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.service.SwapQrySysParaListBusiService;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowBO;
import com.yqsmartcity.data.swap.api.oozie.bo.OozieWorkFlowNodeBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateWorkFlowXmlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CreateWorkFlowXmlServiceImpl
implements CreateWorkFlowXmlService {
    private static final Logger log = LoggerFactory.getLogger(CreateWorkFlowXmlServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(CreateWorkFlowXmlServiceImpl.class);
    @Value(value="${hdfs.hive.path}")
    private String hdfsHivePath;
    @Value(value="${swap.table.prefix}")
    private String swapTablePrefix;
    @Autowired
    private SwapQrySysParaListBusiService swapQrySysParaListBusiService;

    public StringBuffer createWorkFlow(OozieWorkFlowBO oozieWorkFlowBO) throws ZTBusinessException {
        StringBuffer returnString = new StringBuffer();
        returnString.append("<workflow-app xmlns=\"uri:oozie:workflow:0.5\" name=\"" + oozieWorkFlowBO.getWorkFlowName() + "\">\n    <start to=\"" + ((OozieWorkFlowNodeBO)oozieWorkFlowBO.getNodeList().get(0)).getNodeName() + "\"/>\n    \n    \n");
        for (OozieWorkFlowNodeBO oozieWorkFlowNodeBO : oozieWorkFlowBO.getNodeList()) {
            if ("hive".equalsIgnoreCase(oozieWorkFlowNodeBO.getNodeType())) {
                returnString.append(this.hiveNode(oozieWorkFlowNodeBO, oozieWorkFlowBO.getWorkFlowName()));
                continue;
            }
            if ("datax_shell".equalsIgnoreCase(oozieWorkFlowNodeBO.getNodeType())) {
                returnString.append(this.dataxShellNode(oozieWorkFlowNodeBO, oozieWorkFlowBO.getWorkFlowName()));
                continue;
            }
            if (!"switch".equalsIgnoreCase(oozieWorkFlowNodeBO.getNodeType())) continue;
            returnString.append(this.switchNode(oozieWorkFlowNodeBO, this.swapTablePrefix + oozieWorkFlowBO.getWorkFlowName()));
        }
        returnString.append("\n    <kill name=\"fail\">\n        <message>Hive failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message>\n    </kill>\n    <end name=\"end\"/>\n</workflow-app>");
        return returnString;
    }

    private StringBuffer dataxShellNode(OozieWorkFlowNodeBO oozieWorkFlowNodeBO, String workFlowName) throws ZTBusinessException {
        StringBuffer shellNodeString = new StringBuffer();
        shellNodeString.append("    <action name=\"" + oozieWorkFlowNodeBO.getNodeName() + "\">\n        <shell xmlns=\"uri:oozie:shell-action:0.2\">\n            <job-tracker>${jobTracker}</job-tracker>\n            <name-node>${nameNode}</name-node>\n            <configuration>\n                <property>\n                    <name>mapred.job.queue.name</name>\n                    <value>${queueName}</value>\n                </property>\n            </configuration>\n            <exec>" + oozieWorkFlowNodeBO.getScriptFileName() + "</exec>\n            <argument>${yesterday}</argument>\n            <argument>${beforeyesterday}</argument>\n            <file>" + oozieWorkFlowNodeBO.getScriptFileName() + "</file>\n            <file>" + oozieWorkFlowNodeBO.getNodeName() + ".json</file>\n            <capture-output/> \n        </shell>\n        <ok to=\"" + oozieWorkFlowNodeBO.getNextNodeName() + "\"/>\n        <error to=\"fail\"/>\n    </action>\n");
        return shellNodeString;
    }

    private StringBuffer hiveNode(OozieWorkFlowNodeBO oozieWorkFlowNodeBO, String workFlowName) throws ZTBusinessException {
        StringBuffer hiveNodeString = new StringBuffer();
        hiveNodeString.append("    <action name=\"" + oozieWorkFlowNodeBO.getNodeName() + "\">\n        <hive xmlns=\"uri:oozie:hive-action:0.2\">\n            <job-tracker>${jobTracker}</job-tracker>\n            <name-node>${nameNode}</name-node>\n            <job-xml>${nameNode}/user/oozie/hive-site.xml</job-xml>\n            <configuration>\n                <property>\n                    <name>mapred.job.queue.name</name>\n                    <value>${queueName}</value>\n                </property>\n            </configuration>\n            <script>" + oozieWorkFlowNodeBO.getScriptFileName() + "</script>\n            <param>p_start_time=${rundatetime}</param>\n            <param>bizdate=${yesterday}</param>\n            <param>beforebizdate=${beforeyesterday}</param>\n            <param>taskid=${wf:id()}</param>\n        </hive>\n        <ok to=\"" + oozieWorkFlowNodeBO.getNextNodeName() + "\"/>\n        <error to=\"fail\"/>\n    </action>\n");
        return hiveNodeString;
    }

    private StringBuffer switchNode(OozieWorkFlowNodeBO oozieWorkFlowNodeBO, String workFlowName) throws ZTBusinessException {
        StringBuffer hiveNodeString = new StringBuffer();
        hiveNodeString.append("    <decision name=\"" + oozieWorkFlowNodeBO.getNodeName() + "\">\n        <switch>\n            <case to=\"" + oozieWorkFlowNodeBO.getScriptFileName() + "\">${!fs:exists(\"" + this.hdfsHivePath + "/" + workFlowName + "/dt=${yesterday}\")}\n            </case> \n            <case to=\"" + oozieWorkFlowNodeBO.getScriptFileName() + "\">${!fs:exists(\"" + this.hdfsHivePath + "/" + workFlowName + "_ad\")}\n            </case> \n            <case to=\"" + oozieWorkFlowNodeBO.getScriptFileName() + "\">${!fs:exists(\"" + this.hdfsHivePath + "/" + workFlowName + "_dl\")}\n            </case> \n            <default to=\"" + oozieWorkFlowNodeBO.getNextNodeName() + "\"/>  \n        </switch>\n    </decision>\n");
        return hiveNodeString;
    }
}

