/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.swap;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.swap.bo.QryChangeRuleReqBO;
import com.yqsmartcity.data.swap.api.swap.bo.QryChangeRuleRspBO;
import com.yqsmartcity.data.swap.api.swap.service.QryChangeRuleService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryChangeRuleServiceImpl
implements QryChangeRuleService {
    private static final Logger log = LoggerFactory.getLogger(QryChangeRuleServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    public QryChangeRuleRspBO qryChangeRule(QryChangeRuleReqBO reqBO) throws ZTBusinessException {
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QryChangeRuleRspBO rspBO = new QryChangeRuleRspBO();
        TableInfoPO tableInfoPO = this.tableInfoDao.getAllTableInfoByTaskUnid(reqBO.getUnid());
        rspBO.setSwapMode(tableInfoPO.getSwapMode());
        rspBO.setQueryWhere(tableInfoPO.getQueryWhere());
        rspBO.setPartionMode(tableInfoPO.getPartionMode());
        rspBO.setPartionWhere(tableInfoPO.getPartionWhere());
        rspBO.setSwapModeDesc(this.getSysPara(tableInfoPO.getSwapMode(), "SWAP_MODE_TYPE"));
        rspBO.setPartionModeDesc(this.getSysPara(tableInfoPO.getPartionMode(), "PARTION_MODE_TYPE"));
        rspBO.setSourceTableName(tableInfoPO.getSourceTable());
        rspBO.setTargetTableName(tableInfoPO.getDatabaseTable());
        DatabaseInfoPO sourceDatabaseInfoPO = new DatabaseInfoPO();
        sourceDatabaseInfoPO.setDatabaseCode(tableInfoPO.getDatabaseCode());
        sourceDatabaseInfoPO = this.databaseInfoDao.getModelBy(sourceDatabaseInfoPO);
        rspBO.setSourceDeptName(sourceDatabaseInfoPO.getDeptName());
        rspBO.setSourceSysName(sourceDatabaseInfoPO.getSysName());
        rspBO.setSourceDatabaseName(sourceDatabaseInfoPO.getDatabaseName());
        DatabaseInfoPO targetDatabaseInfoPO = new DatabaseInfoPO();
        targetDatabaseInfoPO.setDatabaseCode(tableInfoPO.getTargetDatabaseCode());
        targetDatabaseInfoPO = this.databaseInfoDao.getModelBy(targetDatabaseInfoPO);
        rspBO.setTargetDeptName(targetDatabaseInfoPO.getDeptName());
        rspBO.setTargetSysName(targetDatabaseInfoPO.getSysName());
        rspBO.setTargetDatabaseName(targetDatabaseInfoPO.getDatabaseName());
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

