/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.table;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.table.bo.SwapQryTableColumnListReqBO;
import com.yqsmartcity.data.swap.api.table.bo.SwapQryTableColumnListRspBO;
import com.yqsmartcity.data.swap.api.table.bo.TableColumnBO;
import com.yqsmartcity.data.swap.api.table.service.SwapQryTableColumnListService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TableResourceInfoDao;
import com.yqsmartcity.data.swap.po.TableResourceInfoPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapQryTableColumnListServiceImpl
implements SwapQryTableColumnListService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryTableColumnListServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TableResourceInfoDao tableResourceInfoDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    @Transactional(rollbackFor={Exception.class})
    public SwapQryTableColumnListRspBO qryTableColumnList(SwapQryTableColumnListReqBO reqBO) throws ZTBusinessException {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SwapQryTableColumnListRspBO rspBO = new SwapQryTableColumnListRspBO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)reqBO.getUpdateTime())) {
            String[] updateTimeList = reqBO.getUpdateTime().split("~");
            String updateTimeStart = updateTimeList[0].trim() + " 00:00:00";
            String updateTimeEnd = updateTimeList[1].trim() + " 23:59:59";
            try {
                Date updateStart = sdf.parse(updateTimeStart);
                Date updateEnd = sdf.parse(updateTimeEnd);
                reqBO.setUpdateStart(updateStart);
                reqBO.setUpdateEnd(updateEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        reqBO.setStatus("1");
        List<TableColumnBO> tableColumnBOList = this.tableInfoDao.getTableColumnListPage((Page<TableColumnBO>)page, reqBO);
        if (tableColumnBOList != null && tableColumnBOList.size() > 0) {
            for (TableColumnBO tableColumnBO : tableColumnBOList) {
                TableResourceInfoPO qryTableResourceInfoPO = new TableResourceInfoPO();
                qryTableResourceInfoPO.setDatabaseTableId(tableColumnBO.getDatabaseTableId());
                qryTableResourceInfoPO.setStatus("1");
                TableResourceInfoPO tableResourceInfoPO = this.tableResourceInfoDao.getModelBy(qryTableResourceInfoPO);
                if (null == tableResourceInfoPO) {
                    tableColumnBO.setBindFlag("2");
                } else {
                    tableColumnBO.setBindFlag("1");
                }
                tableColumnBO.setBindFlagName(this.getSysPara(tableColumnBO.getBindFlag(), "BINGING_RELATIONSHIP"));
            }
        }
        rspBO.setRows(tableColumnBOList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

