/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.table;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.table.service.SwapUpdateConfigStateAutoService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TableResourceInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.DataDetailPO;
import com.yqsmartcity.data.swap.po.UpdateConfigStatusPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapUpdateConfigStateAutoServiceImpl
implements SwapUpdateConfigStateAutoService {
    private static final Logger log = LoggerFactory.getLogger(SwapUpdateConfigStateAutoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapUpdateConfigStateAutoServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private TableResourceInfoDao tableResourceInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public void updateConfigStateAuto() throws ZTBusinessException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        String count_date = sdf.format(c.getTime());
        DataDetailPO qryDataDetailPO = new DataDetailPO();
        qryDataDetailPO.setCountDate(count_date);
        List<UpdateConfigStatusPO> updateConfigStatusPOList = this.tableInfoDao.getDataDetailList(qryDataDetailPO);
        if (updateConfigStatusPOList != null && updateConfigStatusPOList.size() > 0) {
            ArrayList<Long> tableUnidList = new ArrayList<Long>();
            ArrayList<Long> taskUnidList = new ArrayList<Long>();
            ArrayList<Long> databaseUnidList = new ArrayList<Long>();
            for (UpdateConfigStatusPO updateConfigStatusPO : updateConfigStatusPOList) {
                if ("0".equals(updateConfigStatusPO.getTableConfigStatus())) {
                    tableUnidList.add(updateConfigStatusPO.getTableUnid());
                }
                if ("0".equals(updateConfigStatusPO.getTaskConfigStatus())) {
                    taskUnidList.add(updateConfigStatusPO.getTaskunid());
                }
                if (!"0".equals(updateConfigStatusPO.getDatabaseConfigStatus())) continue;
                databaseUnidList.add(updateConfigStatusPO.getDatabaseUnid());
            }
            if (tableUnidList.size() > 0) {
                this.tableInfoDao.updateBatchConfigState(tableUnidList.toArray(new Long[tableUnidList.size()]));
            }
            if (taskUnidList.size() > 0) {
                this.taskInfoDao.updateBatchConfigState(taskUnidList.toArray(new Long[taskUnidList.size()]));
            }
            if (databaseUnidList.size() > 0) {
                this.databaseInfoDao.updateBatchConfigState(databaseUnidList.toArray(new Long[databaseUnidList.size()]));
            }
        }
    }
}

